/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geysermc.event.Listener;
import org.geysermc.event.subscribe.Subscribe;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.event.lifecycle.ShutdownEvent;
import org.geysermc.floodgate.core.platform.util.PlatformUtils;
import org.geysermc.floodgate.core.util.AutoBind;
import org.geysermc.floodgate.shadow.bstats.MetricsBase;
import org.geysermc.floodgate.shadow.bstats.charts.DrilldownPie;
import org.geysermc.floodgate.shadow.bstats.charts.SimplePie;
import org.geysermc.floodgate.shadow.bstats.charts.SingleLineChart;
import org.geysermc.floodgate.shadow.bstats.json.JsonObjectBuilder;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.geysermc.floodgate.shadow.google.inject.name.Named;

@Listener
@AutoBind
public final class Metrics {
    private final MetricsBase metricsBase;

    @Inject
    Metrics(FloodgateConfig config, PlatformUtils platformUtils, FloodgateApi api, @Named(value="implementationName") String implementationName, FloodgateLogger logger) {
        FloodgateConfig.MetricsConfig metricsConfig = config.getMetrics();
        this.metricsBase = new MetricsBase("server-implementation", metricsConfig.getUuid(), 14649, metricsConfig.isEnabled(), this::appendPlatformData, jsonObjectBuilder -> {}, null, () -> true, (x$0, x$1) -> logger.error((String)x$0, (Throwable)x$1, new Object[0]), x$0 -> logger.info((String)x$0, new Object[0]), false, false, false);
        this.metricsBase.addCustomChart(new SingleLineChart("players", api::getPlayerCount));
        this.metricsBase.addCustomChart(new DrilldownPie("player_count", () -> {
            int playerCount = api.getPlayerCount();
            int category = playerCount / 5 * 5;
            String categoryName = category + " - " + (category + 4);
            return Collections.singletonMap(implementationName, Collections.singletonMap(categoryName, 1));
        }));
        this.metricsBase.addCustomChart(new SimplePie("authentication", () -> platformUtils.authType().name().toLowerCase(Locale.ROOT)));
        this.metricsBase.addCustomChart(new SimplePie("floodgate_version", () -> "2.2.3-SNAPSHOT (b1-07b516f)"));
        this.metricsBase.addCustomChart(new DrilldownPie("platform", () -> Collections.singletonMap(implementationName, Collections.singletonMap(platformUtils.serverImplementationName(), 1))));
        this.metricsBase.addCustomChart(new DrilldownPie("minecraft_version", () -> Collections.singletonMap(implementationName, Collections.singletonMap(platformUtils.minecraftVersion(), 1))));
        this.metricsBase.addCustomChart(new DrilldownPie("java_version", () -> {
            String release;
            HashMap map = new HashMap();
            String javaVersion = System.getProperty("java.version");
            HashMap<String, Integer> entry = new HashMap<String, Integer>();
            entry.put(javaVersion, 1);
            String majorVersion = javaVersion.split("\\.")[0];
            int indexOf = javaVersion.lastIndexOf(46);
            if (majorVersion.equals("1")) {
                release = "Java " + javaVersion.substring(0, indexOf);
            } else {
                Matcher versionMatcher = Pattern.compile("\\d+").matcher(majorVersion);
                if (versionMatcher.find()) {
                    majorVersion = versionMatcher.group(0);
                }
                release = "Java " + majorVersion;
            }
            map.put(release, entry);
            return map;
        }));
    }

    private void appendPlatformData(JsonObjectBuilder builder) {
        builder.appendField("osName", System.getProperty("os.name"));
        builder.appendField("osArch", System.getProperty("os.arch"));
        builder.appendField("osVersion", System.getProperty("os.version"));
        builder.appendField("coreCount", Runtime.getRuntime().availableProcessors());
    }

    @Subscribe
    public void onShutdown(ShutdownEvent ignored) {
        this.metricsBase.shutdown();
    }
}

