/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.data;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.util.AttributeKey;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.core.api.SimpleFloodgateApi;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.core.util.Utils;
import org.geysermc.floodgate.mod.data.ModDataHandler;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.geysermc.floodgate.shadow.google.inject.name.Named;

public final class ModDataAddon
implements InjectorAddon {
    @Inject
    private FloodgateHandshakeHandler handshakeHandler;
    @Inject
    private FloodgateConfig config;
    @Inject
    private SimpleFloodgateApi api;
    @Inject
    private FloodgateLogger logger;
    @Inject
    @Named(value="packetHandler")
    private String packetHandlerName;
    @Inject
    @Named(value="kickMessageAttribute")
    private AttributeKey<String> kickMessageAttribute;
    @Inject
    @Named(value="playerAttribute")
    private AttributeKey<FloodgatePlayer> playerAttribute;

    @Override
    public void onInject(Channel channel, boolean toServer) {
        channel.pipeline().addBefore(this.packetHandlerName, "floodgate_data_handler", (ChannelHandler)new ModDataHandler(this.handshakeHandler, this.config, this.kickMessageAttribute, this.logger));
    }

    @Override
    public void onChannelClosed(Channel channel) {
        FloodgatePlayer player = (FloodgatePlayer)channel.attr(this.playerAttribute).get();
        if (player != null && this.api.setPendingRemove(player)) {
            this.logger.translatedInfo("floodgate.ingame.disconnect_name", player.getCorrectUsername());
        }
    }

    @Override
    public void onRemoveInject(Channel channel) {
        Utils.removeHandler(channel.pipeline(), "floodgate_data_handler");
    }

    @Override
    public boolean shouldInject() {
        return true;
    }
}

