/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.data;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Objects;
import net.minecraft.class_140;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2561;
import net.minecraft.class_2889;
import net.minecraft.class_2915;
import net.minecraft.class_3248;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.core.addon.data.CommonDataHandler;
import org.geysermc.floodgate.core.addon.data.PacketBlocker;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.geysermc.floodgate.mod.mixin.ClientIntentionPacketMixinInterface;
import org.geysermc.floodgate.mod.mixin.ConnectionMixin;
import org.slf4j.Logger;

public final class ModDataHandler
extends CommonDataHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final FloodgateLogger logger;
    private class_2535 networkManager;
    private FloodgatePlayer player;

    public ModDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute, FloodgateLogger logger) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
        this.logger = logger;
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ((ConnectionMixin)this.networkManager).setAddress(newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) {
        ((ClientIntentionPacketMixinInterface)handshakePacket).setAddress(hostname);
        return handshakePacket;
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        if (result.getResultType() == FloodgateHandshakeHandler.ResultType.SUCCESS) {
            this.logger.info("Floodgate player who is logged in as {} {} joined", this.player.getCorrectUsername(), this.player.getCorrectUniqueId());
        }
        return false;
    }

    @Override
    protected boolean channelRead(Object packet) {
        if (packet instanceof class_2889) {
            class_2889 intentionPacket = (class_2889)packet;
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = (class_2535)this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, intentionPacket.comp_1564());
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) {
        if (packet instanceof class_2915) {
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                class_2561 message = class_2561.method_30163((String)kickMessage);
                class_2547 class_25472 = this.networkManager.method_10744();
                if (class_25472 instanceof class_3248) {
                    class_3248 loginPacketListener = (class_3248)class_25472;
                    loginPacketListener.method_14380(message);
                } else {
                    this.networkManager.method_10747(message);
                }
                return true;
            }
            class_2547 loginPacketListener = this.networkManager.method_10744();
            if (!(loginPacketListener instanceof class_3248)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            class_3248 packetListener = (class_3248)loginPacketListener;
            GameProfile gameProfile = new GameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername());
            if (this.player.isLinked() && this.player.getCorrectUniqueId().version() == 4) {
                this.verifyLinkedPlayerAsync(packetListener, gameProfile);
            } else {
                packetListener.method_52417(gameProfile);
            }
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    private void verifyLinkedPlayerAsync(final class_3248 packetListener, final GameProfile gameProfile) {
        Thread texturesThread = new Thread(this, "Bedrock Linked Player Texture Download"){

            @Override
            public void run() {
                GameProfile effectiveProfile = gameProfile;
                try {
                    MinecraftSessionService service = MinecraftServerHolder.get().method_73550().comp_837();
                    effectiveProfile = Objects.requireNonNull(service.fetchProfile(effectiveProfile.id(), true)).profile();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to get Bedrock linked player textures for " + effectiveProfile.name(), (Throwable)e);
                }
                packetListener.method_52417(effectiveProfile);
            }
        };
        texturesThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER));
        texturesThread.start();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (this.config.isDebug()) {
            LOGGER.error("Exception caught in FabricDataHandler", cause);
        }
    }
}

