/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.util;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_11560;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3340;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.platform.command.CommandUtil;
import org.geysermc.floodgate.core.player.UserAudience;
import org.geysermc.floodgate.core.util.LanguageManager;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.incendo.cloud.CommandManager;

public final class ModCommandUtil
extends CommandUtil {
    private final FloodgateLogger logger;
    private UserAudience console;
    private CommandManager<UserAudience> commandManager;

    public ModCommandUtil(LanguageManager manager, FloodgateApi api, FloodgateLogger logger) {
        super(manager, api);
        this.logger = logger;
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof class_2168)) {
            throw new IllegalArgumentException();
        }
        class_2168 stack = (class_2168)sourceObj;
        if (stack.method_9228() == null) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(stack, this);
            return this.console;
        }
        class_3222 player = stack.method_44023();
        return new UserAudience.PlayerAudience(player.method_5667(), player.method_7334().name(), "en_US", stack, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((class_3222)source).method_7334().name();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((class_3222)source).method_5667();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        class_3222 player = MinecraftServerHolder.get().method_3760().method_14602(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        class_3222 player = MinecraftServerHolder.get().method_3760().method_14566(username);
        return player != null ? player : username;
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return MinecraftServerHolder.get().method_3760().method_14571();
    }

    @Override
    public boolean hasPermission(Object source, String permission) {
        return this.commandManager.hasPermission((Object)this.getUserAudience(source), permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        class_2168 commandSource = (class_2168)target;
        if (commandSource.method_9228() instanceof class_3222) {
            MinecraftServerHolder.get().execute(() -> ((class_3222)commandSource.method_9228()).method_7353((class_2561)class_2561.method_43470((String)message), false));
        } else {
            this.logger.info(message, new Object[0]);
        }
    }

    @Override
    public void kickPlayer(Object o, String message) {
        if (o instanceof class_3222) {
            class_3222 player = (class_3222)o;
            player.field_13987.method_52396((class_2561)class_2561.method_43470((String)message));
        }
    }

    @Override
    public boolean whitelistPlayer(UUID uuid, String username) {
        class_11560 nameAndId = new class_11560(uuid, username);
        MinecraftServerHolder.get().method_3760().method_14590().method_74008(new class_3340(nameAndId));
        return true;
    }

    @Override
    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        class_11560 nameAndId = new class_11560(uuid, username);
        MinecraftServerHolder.get().method_3760().method_14590().method_74009(nameAndId);
        return true;
    }

    public void setCommandManager(CommandManager<UserAudience> commandManager) {
        this.commandManager = commandManager;
    }
}

