/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.platform.fabric.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.server.MinecraftServer;

public class TaskTimer
implements ServerTickEvents.EndTick {
    public static final TaskTimer INSTANCE = new TaskTimer();
    private final List<Task> tasks = new LinkedList<Task>();

    public void runLater(Runnable runnable, int delay) {
        this.tasks.add(new Task(delay, runnable));
    }

    public void onEndTick(MinecraftServer server) {
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (--task.ticks > 0L) continue;
            try {
                task.run.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            iterator.remove();
        }
    }

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register((Object)INSTANCE);
    }

    private static class Task {
        long ticks;
        Runnable run;

        Task(long ticks, Runnable run) {
            this.ticks = ticks;
            this.run = run;
        }
    }
}

