/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geysermc.floodgate.shadow.google.inject.ConfigurationException;
import org.geysermc.floodgate.shadow.google.inject.TypeLiteral;
import org.geysermc.floodgate.shadow.google.inject.internal.EncounterImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.google.inject.internal.ErrorsException;
import org.geysermc.floodgate.shadow.google.inject.internal.FailableCache;
import org.geysermc.floodgate.shadow.google.inject.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.MembersInjectorImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.SingleFieldInjector;
import org.geysermc.floodgate.shadow.google.inject.internal.SingleMemberInjector;
import org.geysermc.floodgate.shadow.google.inject.internal.SingleMethodInjector;
import org.geysermc.floodgate.shadow.google.inject.spi.InjectionPoint;
import org.geysermc.floodgate.shadow.google.inject.spi.TypeListener;
import org.geysermc.floodgate.shadow.google.inject.spi.TypeListenerBinding;

final class MembersInjectorStore {
    private final InjectorImpl injector;
    private final ImmutableList<TypeListenerBinding> typeListenerBindings;
    private final FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>> cache = new FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>>(){

        @Override
        protected MembersInjectorImpl<?> create(TypeLiteral<?> type, Errors errors) throws ErrorsException {
            return MembersInjectorStore.this.createWithListeners(type, errors);
        }
    };

    MembersInjectorStore(InjectorImpl injector, List<TypeListenerBinding> typeListenerBindings) {
        this.injector = injector;
        this.typeListenerBindings = ImmutableList.copyOf(typeListenerBindings);
    }

    public boolean hasTypeListeners() {
        return !this.typeListenerBindings.isEmpty();
    }

    public <T> MembersInjectorImpl<T> get(TypeLiteral<T> key, Errors errors) throws ErrorsException {
        return this.cache.get(key, errors);
    }

    boolean remove(TypeLiteral<?> type) {
        return this.cache.remove(type);
    }

    private <T> MembersInjectorImpl<T> createWithListeners(TypeLiteral<T> type, Errors errors) throws ErrorsException {
        Set injectionPoints;
        int numErrorsBefore = errors.size();
        try {
            injectionPoints = InjectionPoint.forInstanceMethodsAndFields(type);
        }
        catch (ConfigurationException e) {
            errors.merge(e.getErrorMessages());
            injectionPoints = (Set)e.getPartialValue();
        }
        ImmutableList<SingleMemberInjector> injectors = this.getInjectors(injectionPoints, errors);
        errors.throwIfNewErrors(numErrorsBefore);
        EncounterImpl encounter = new EncounterImpl(errors, this.injector.lookups);
        HashSet alreadySeenListeners = Sets.newHashSet();
        for (TypeListenerBinding binding : this.typeListenerBindings) {
            TypeListener typeListener = binding.getListener();
            if (alreadySeenListeners.contains(typeListener) || !binding.getTypeMatcher().matches(type)) continue;
            alreadySeenListeners.add(typeListener);
            try {
                typeListener.hear(type, encounter);
            }
            catch (RuntimeException e) {
                errors.errorNotifyingTypeListener(binding, type, e);
            }
        }
        encounter.invalidate();
        errors.throwIfNewErrors(numErrorsBefore);
        return new MembersInjectorImpl<T>(this.injector, type, encounter, injectors);
    }

    ImmutableList<SingleMemberInjector> getInjectors(Set<InjectionPoint> injectionPoints, Errors errors) {
        ArrayList injectors = Lists.newArrayList();
        for (InjectionPoint injectionPoint : injectionPoints) {
            try {
                Errors errorsForMember = injectionPoint.isOptional() ? new Errors(injectionPoint) : errors.withSource(injectionPoint);
                SingleMemberInjector injector = injectionPoint.getMember() instanceof Field ? new SingleFieldInjector(this.injector, injectionPoint, errorsForMember) : new SingleMethodInjector(this.injector, injectionPoint, errorsForMember);
                injectors.add(injector);
            }
            catch (ErrorsException errorsException) {}
        }
        return ImmutableList.copyOf((Collection)injectors);
    }

    ImmutableListMultimap<TypeLiteral<?>, InjectionPoint> getAllInjectionPoints() {
        return (ImmutableListMultimap)this.cache.asMap().entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, entry -> ((MembersInjectorImpl)entry.getValue()).getInjectionPoints().stream()));
    }
}

