/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import com.google.common.base.Preconditions;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.aopalliance.intercept.MethodInterceptor;
import org.geysermc.floodgate.shadow.google.inject.matcher.Matcher;
import org.geysermc.floodgate.shadow.google.inject.spi.InterceptorBinding;

final class MethodAspect {
    private final Matcher<? super Class<?>> classMatcher;
    private final Matcher<? super Method> methodMatcher;
    private final List<MethodInterceptor> interceptors;

    static MethodAspect fromBinding(InterceptorBinding binding) {
        return new MethodAspect(binding.getClassMatcher(), binding.getMethodMatcher(), binding.getInterceptors());
    }

    MethodAspect(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, List<MethodInterceptor> interceptors) {
        this.classMatcher = (Matcher)Preconditions.checkNotNull(classMatcher, (Object)"class matcher");
        this.methodMatcher = (Matcher)Preconditions.checkNotNull(methodMatcher, (Object)"method matcher");
        this.interceptors = (List)Preconditions.checkNotNull(interceptors, (Object)"interceptors");
    }

    MethodAspect(Matcher<? super Class<?>> classMatcher, Matcher<? super Method> methodMatcher, MethodInterceptor ... interceptors) {
        this(classMatcher, methodMatcher, Arrays.asList(interceptors));
    }

    boolean matches(Class<?> clazz) {
        return this.classMatcher.matches(clazz);
    }

    boolean matches(Method method) {
        return this.methodMatcher.matches(method);
    }

    List<MethodInterceptor> interceptors() {
        return this.interceptors;
    }
}

