/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Primitives;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Map;
import org.geysermc.floodgate.shadow.google.inject.Binding;
import org.geysermc.floodgate.shadow.google.inject.Injector;
import org.geysermc.floodgate.shadow.google.inject.Key;
import org.geysermc.floodgate.shadow.google.inject.TypeLiteral;
import org.geysermc.floodgate.shadow.google.inject.internal.GuiceInternal;
import org.geysermc.floodgate.shadow.google.inject.internal.Messages;
import org.geysermc.floodgate.shadow.google.inject.internal.SourceFormatter;
import org.geysermc.floodgate.shadow.google.inject.spi.BindingSourceRestriction;
import org.geysermc.floodgate.shadow.google.inject.spi.UntargettedBinding;

final class MissingImplementationErrorHints {
    private static final int MAX_MATCHING_TYPES_REPORTED = 3;
    private static final int MAX_RELATED_TYPES_REPORTED = 3;
    private static final ImmutableSet<Class<?>> COMMON_AMBIGUOUS_TYPES = ImmutableSet.builder().add(Object.class).add(String.class).addAll((Iterable)Primitives.allWrapperTypes()).build();

    private MissingImplementationErrorHints() {
    }

    static <T> ImmutableList<String> getSuggestions(Key<T> key, Injector injector) {
        ImmutableList.Builder suggestions = ImmutableList.builder();
        TypeLiteral<T> type = key.getTypeLiteral();
        BindingSourceRestriction.getMissingImplementationSuggestion(GuiceInternal.GUICE_INTERNAL, key).ifPresent(arg_0 -> ((ImmutableList.Builder)suggestions).add(arg_0));
        ArrayList<String> possibleMatches = new ArrayList<String>();
        ImmutableList sameTypes = (ImmutableList)injector.findBindingsByType(type).stream().filter(b -> !(b instanceof UntargettedBinding)).collect(ImmutableList.toImmutableList());
        if (!sameTypes.isEmpty()) {
            suggestions.add((Object)"\nDid you mean?");
            int howMany = Math.min(sameTypes.size(), 3);
            for (int i = 0; i < howMany; ++i) {
                Key bindingKey = ((Binding)sameTypes.get(i)).getKey();
                suggestions.add((Object)Messages.format("\n    * %s", MissingImplementationErrorHints.formatSuggestion(bindingKey, injector.getExistingBinding(bindingKey))));
            }
            int remaining = sameTypes.size() - 3;
            if (remaining > 0) {
                String plural = remaining == 1 ? "" : "s";
                suggestions.add((Object)Messages.format("\n    * %d more binding%s with other annotations.", remaining, plural));
            }
        } else {
            String want = type.toString();
            Map<Key<?>, Binding<?>> bindingMap = injector.getAllBindings();
            for (Key<?> bindingKey : bindingMap.keySet()) {
                String have;
                Binding<?> binding = bindingMap.get(bindingKey);
                if (binding instanceof UntargettedBinding || !(have = bindingKey.getTypeLiteral().toString()).contains(want) && !want.contains(have)) continue;
                possibleMatches.add(MissingImplementationErrorHints.formatSuggestion(bindingKey, bindingMap.get(bindingKey)));
                if (possibleMatches.size() <= 3) continue;
                break;
            }
            if (!possibleMatches.isEmpty() && possibleMatches.size() <= 3) {
                suggestions.add((Object)"\nDid you mean?");
                for (String possibleMatch : possibleMatches) {
                    suggestions.add((Object)Messages.format("\n    * %s", possibleMatch));
                }
            }
        }
        if (sameTypes.isEmpty() && possibleMatches.isEmpty() && key.getAnnotationType() == null && COMMON_AMBIGUOUS_TYPES.contains(key.getTypeLiteral().getRawType())) {
            suggestions.add((Object)"\nThe key seems very generic, did you forget an annotation?");
        }
        return suggestions.build();
    }

    private static String formatSuggestion(Key<?> key, Binding<?> binding) {
        Formatter fmt = new Formatter();
        fmt.format("%s bound ", Messages.convert(key));
        new SourceFormatter(binding.getSource(), fmt, false).format();
        return fmt.toString();
    }
}

