/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.geysermc.floodgate.shadow.google.inject.Binder;
import org.geysermc.floodgate.shadow.google.inject.Key;
import org.geysermc.floodgate.shadow.google.inject.Provider;
import org.geysermc.floodgate.shadow.google.inject.internal.BindingImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.GuiceInternal;
import org.geysermc.floodgate.shadow.google.inject.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalFactory;
import org.geysermc.floodgate.shadow.google.inject.internal.Scoping;
import org.geysermc.floodgate.shadow.google.inject.spi.BindingTargetVisitor;
import org.geysermc.floodgate.shadow.google.inject.spi.Dependency;
import org.geysermc.floodgate.shadow.google.inject.spi.Elements;
import org.geysermc.floodgate.shadow.google.inject.spi.HasDependencies;
import org.geysermc.floodgate.shadow.google.inject.spi.InjectionPoint;
import org.geysermc.floodgate.shadow.google.inject.spi.ProviderInstanceBinding;
import org.geysermc.floodgate.shadow.google.inject.spi.ProviderWithExtensionVisitor;
import org.geysermc.floodgate.shadow.google.inject.util.Providers;

class ProviderInstanceBindingImpl<T>
extends BindingImpl<T>
implements ProviderInstanceBinding<T> {
    final javax.inject.Provider<? extends T> providerInstance;
    final ImmutableSet<InjectionPoint> injectionPoints;

    public ProviderInstanceBindingImpl(InjectorImpl injector, Key<T> key, Object source, InternalFactory<? extends T> internalFactory, Scoping scoping, javax.inject.Provider<? extends T> providerInstance, Set<InjectionPoint> injectionPoints) {
        super(injector, key, source, internalFactory, scoping);
        this.providerInstance = providerInstance;
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
    }

    public ProviderInstanceBindingImpl(Object source, Key<T> key, Scoping scoping, Set<InjectionPoint> injectionPoints, javax.inject.Provider<? extends T> providerInstance) {
        super(source, key, scoping);
        this.injectionPoints = ImmutableSet.copyOf(injectionPoints);
        this.providerInstance = providerInstance;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> visitor) {
        if (this.providerInstance instanceof ProviderWithExtensionVisitor) {
            return ((ProviderWithExtensionVisitor)this.providerInstance).acceptExtensionVisitor(visitor, this);
        }
        return visitor.visit(this);
    }

    @Override
    public Provider<? extends T> getProviderInstance() {
        return Providers.guicify(this.providerInstance);
    }

    @Override
    public javax.inject.Provider<? extends T> getUserSuppliedProvider() {
        return this.providerInstance;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.injectionPoints;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return this.providerInstance instanceof HasDependencies ? ImmutableSet.copyOf(((HasDependencies)this.providerInstance).getDependencies()) : Dependency.forInjectionPoints(this.injectionPoints);
    }

    @Override
    public BindingImpl<T> withScoping(Scoping scoping) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), this.getKey(), scoping, (Set<InjectionPoint>)this.injectionPoints, this.providerInstance);
    }

    @Override
    public BindingImpl<T> withKey(Key<T> key) {
        return new ProviderInstanceBindingImpl<T>(this.getSource(), key, this.getScoping(), (Set<InjectionPoint>)this.injectionPoints, this.providerInstance);
    }

    @Override
    public void applyTo(Binder binder) {
        this.getScoping().applyTo(Elements.withTrustedSource(GuiceInternal.GUICE_INTERNAL, binder, this.getSource()).bind(this.getKey()).toProvider(this.getUserSuppliedProvider()));
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ProviderInstanceBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("scope", (Object)this.getScoping()).add("provider", this.providerInstance).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProviderInstanceBindingImpl) {
            ProviderInstanceBindingImpl o = (ProviderInstanceBindingImpl)obj;
            return this.getKey().equals(o.getKey()) && this.getScoping().equals(o.getScoping()) && Objects.equal(this.providerInstance, o.providerInstance);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getKey(), this.getScoping()});
    }
}

