/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.loader.validate;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.configutils.loader.validate.ValidationResult;
import org.geysermc.configutils.loader.validate.Validator;

public final class Validations {
    private final Map<String, Set<Validator>> validations;

    private Validations(Map<String, Set<Validator>> validations) {
        this.validations = validations;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ValidationResult validate(String key, Object value) {
        Validator validator;
        Set<Validator> validators = this.validations.get(key);
        if (validators == null || validators.isEmpty()) {
            return ValidationResult.ok(value);
        }
        ValidationResult result = null;
        Iterator<Validator> iterator = validators.iterator();
        while (iterator.hasNext() && (result = (validator = iterator.next()).validate(key, value)).success()) {
            value = result.value();
        }
        return result;
    }

    public static final class Builder {
        private final Map<String, Set<Validator>> validations = new HashMap<String, Set<Validator>>();

        private Builder() {
        }

        public @NonNull Builder validation(@NonNull String key, @NonNull Validator validator) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(validator);
            this.validations.computeIfAbsent(key, k -> new LinkedHashSet()).add(validator);
            return this;
        }

        public @NonNull Builder validation(@NonNull String key, @NonNull Function<Object, ValidationResult> validator) {
            return this.validation(key, (String ignored, Object value) -> (ValidationResult)validator.apply(value));
        }

        public Validations build() {
            return new Validations(this.validations);
        }
    }
}

