/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.configutils.parser.template.action.storage;

import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.IntObjectImmutablePair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.geysermc.configutils.parser.template.action.storage.Singleton;
import org.geysermc.configutils.parser.template.action.storage.Storable;
import org.geysermc.configutils.parser.template.action.storage.Unfinished;

public final class Storables {
    private final Map<Class<? extends Storable>, List<Storable>> storables = new HashMap<Class<? extends Storable>, List<Storable>>();
    private final Map<Class<? extends Storable>, List<Unfinished>> notFinished = new HashMap<Class<? extends Storable>, List<Unfinished>>();

    public boolean has(@NonNull Class<? extends Storable> storableType) {
        return this.first(storableType) != null;
    }

    public boolean hasMany(@NonNull Class<? extends Storable> storableType) {
        return this.all(storableType).size() > 1;
    }

    public <T extends Storable> @Nullable T first(@NonNull Class<T> storableType) {
        Objects.requireNonNull(storableType);
        List<Storable> items = this.storables.get(storableType);
        if (items != null && !items.isEmpty()) {
            return (T)items.get(0);
        }
        return null;
    }

    public <T extends Storable> @NonNull List<T> all(@NonNull Class<T> storableType) {
        Objects.requireNonNull(storableType);
        List<Storable> items = this.storables.get(storableType);
        if (items != null && !items.isEmpty()) {
            return Collections.unmodifiableList(items);
        }
        return Collections.emptyList();
    }

    public boolean add(@NonNull Storable storable) {
        Objects.requireNonNull(storable);
        List items = this.storables.computeIfAbsent(storable.getClass(), $ -> new ArrayList());
        if (!(items.contains(storable) || storable instanceof Singleton && !items.isEmpty())) {
            if (storable instanceof Unfinished) {
                this.notFinished.computeIfAbsent(storable.getClass(), $ -> new ArrayList()).add((Unfinished)((Object)storable));
            }
            return items.add(storable);
        }
        return false;
    }

    public <T extends Storable> T removeFirst(@NonNull Class<T> storableType) {
        Storable removed;
        Objects.requireNonNull(storableType);
        List<Storable> items = this.storables.get(storableType);
        if (items == null) {
            return null;
        }
        if (items.size() <= 1) {
            this.storables.remove(storableType);
        }
        if ((removed = items.remove(0)) instanceof Unfinished) {
            List<Unfinished> unfinished = this.notFinished.get(storableType);
            unfinished.remove(removed);
            if (unfinished.isEmpty()) {
                this.notFinished.remove(storableType);
            }
        }
        return (T)removed;
    }

    public <T extends Storable> List<T> removeAll(@NonNull Class<T> storableType) {
        Objects.requireNonNull(storableType);
        this.notFinished.remove(storableType);
        List<Storable> items = this.storables.remove(storableType);
        if (items == null) {
            return Collections.emptyList();
        }
        return items;
    }

    public boolean hasUnfinished() {
        return !this.notFinished.isEmpty();
    }

    @SafeVarargs
    public final @Nullable Unfinished firstUnfinished(Class<? extends Unfinished> ... items) {
        List random;
        Objects.requireNonNull(items);
        if (this.notFinished.isEmpty()) {
            return null;
        }
        if (items.length > 0) {
            int bestMatchIndex = Integer.MAX_VALUE;
            Unfinished bestMatch = null;
            for (Class<? extends Storable> unfinished : this.notFinished.keySet()) {
                List<Unfinished> unfinisheds = this.notFinished.get(unfinished);
                if (unfinisheds == null || unfinisheds.isEmpty()) continue;
                for (int i = 0; i < items.length; ++i) {
                    Class<? extends Unfinished> item = items[i];
                    if (!item.equals(unfinished) || i >= bestMatchIndex) continue;
                    bestMatchIndex = i;
                    bestMatch = unfinisheds.get(0);
                    if (i != 0) continue;
                    return bestMatch;
                }
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        if ((random = (List)this.notFinished.values().stream().findFirst().orElse(null)) != null && !random.isEmpty()) {
            return (Unfinished)random.get(0);
        }
        return null;
    }

    @SafeVarargs
    public final @NonNull List<Unfinished> allUnfinished(Class<Unfinished> ... items) {
        Objects.requireNonNull(items);
        if (this.notFinished.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IntObjectImmutablePair> matches = new ArrayList<IntObjectImmutablePair>();
        int nextMatchIndex = items.length;
        block0: for (Map.Entry<Class<? extends Storable>, List<Unfinished>> entry : this.notFinished.entrySet()) {
            List<Unfinished> unfinisheds = entry.getValue();
            if (unfinisheds == null || unfinisheds.isEmpty()) continue;
            for (int i = 0; i < items.length; ++i) {
                Class<Unfinished> item = items[i];
                if (!item.equals(entry.getKey())) continue;
                matches.add(new IntObjectImmutablePair(i, (Object)unfinisheds.get(0)));
                continue block0;
            }
            matches.add(new IntObjectImmutablePair(nextMatchIndex++, (Object)unfinisheds.get(0)));
        }
        return matches.stream().sorted(Comparator.comparing(Pair::left)).map(Pair::right).collect(Collectors.toList());
    }
}

