/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.addon;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.core.addon.packethandler.ChannelInPacketHandler;
import org.geysermc.floodgate.core.addon.packethandler.ChannelOutPacketHandler;
import org.geysermc.floodgate.core.packet.PacketHandlersImpl;
import org.geysermc.floodgate.core.util.Utils;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.geysermc.floodgate.shadow.google.inject.name.Named;

public class PacketHandlerAddon
implements InjectorAddon {
    @Inject
    private PacketHandlersImpl packetHandlers;
    @Inject
    @Named(value="packetEncoder")
    private String packetEncoder;
    @Inject
    @Named(value="packetDecoder")
    private String packetDecoder;

    @Override
    public void onInject(Channel channel, boolean toServer) {
        channel.pipeline().addAfter(this.packetEncoder, "floodgate_phaddon_out", (ChannelHandler)new ChannelOutPacketHandler(this.packetHandlers, toServer)).addAfter(this.packetDecoder, "floodgate_phaddon_in", (ChannelHandler)new ChannelInPacketHandler(this.packetHandlers, toServer));
    }

    @Override
    public void onRemoveInject(Channel channel) {
        ChannelPipeline pipeline = channel.pipeline();
        Utils.removeHandler(pipeline, "floodgate_phaddon_out");
        Utils.removeHandler(pipeline, "floodgate_phaddon_in");
    }

    @Override
    public boolean shouldInject() {
        return this.packetHandlers.hasHandlers();
    }
}

