/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.addon.debug;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.concurrent.atomic.AtomicInteger;
import org.geysermc.floodgate.api.logger.FloodgateLogger;

@ChannelHandler.Sharable
public final class ChannelOutDebugHandler
extends MessageToByteEncoder<ByteBuf> {
    private final String direction;
    private final FloodgateLogger logger;
    private final AtomicInteger packetCount;

    public ChannelOutDebugHandler(String implementationType, boolean toServer, AtomicInteger packetCount, FloodgateLogger logger) {
        this.direction = implementationType + (toServer ? " -> Server" : " -> Player");
        this.logger = logger;
        this.packetCount = packetCount;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf msg, ByteBuf out) {
        try {
            int index = msg.readerIndex();
            if (this.packetCount.getAndIncrement() < 25) {
                this.logger.info("{} {}:\n{}", this.direction, this.packetCount.get(), ByteBufUtil.prettyHexDump((ByteBuf)msg));
            }
            msg.readerIndex(index);
            out.writeBytes(msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

