/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.command;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.UUID;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.command.CommonCommandMessage;
import org.geysermc.floodgate.core.command.util.Permission;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.config.ProxyFloodgateConfig;
import org.geysermc.floodgate.core.platform.command.CommandUtil;
import org.geysermc.floodgate.core.platform.command.FloodgateCommand;
import org.geysermc.floodgate.core.platform.command.TranslatableMessage;
import org.geysermc.floodgate.core.player.UserAudience;
import org.geysermc.floodgate.core.player.audience.PlayerAudienceArgument;
import org.geysermc.floodgate.core.player.audience.ProfileAudience;
import org.geysermc.floodgate.core.util.HttpClient;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.incendo.cloud.Command;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.context.CommandContext;
import org.incendo.cloud.description.Description;

public class WhitelistCommand
implements FloodgateCommand {
    @Inject
    private FloodgateConfig config;
    @Inject
    private HttpClient httpClient;
    @Inject
    private FloodgateLogger logger;

    public Command<UserAudience> buildCommand(CommandManager<UserAudience> commandManager) {
        Command.Builder builder = commandManager.commandBuilder("fwhitelist", Description.of((String)"Easy way to whitelist Bedrock players"), new String[0]).permission(Permission.COMMAND_WHITELIST.get());
        commandManager.command(builder.literal("add", new String[]{"a"}).argument(PlayerAudienceArgument.ofAnyIdentifierBedrock("player")).handler(context -> this.performCommand((CommandContext<UserAudience>)context, true)));
        return builder.literal("remove", new String[]{"r"}).argument(PlayerAudienceArgument.ofAnyIdentifierBedrock("player")).handler(context -> this.performCommand((CommandContext<UserAudience>)context, false)).build();
    }

    public void performCommand(CommandContext<UserAudience> context, boolean add) {
        UserAudience sender = (UserAudience)context.sender();
        ProfileAudience profile = (ProfileAudience)context.get("player");
        UUID uuid = profile.uuid();
        String name = profile.username();
        if (name == null && uuid == null) {
            sender.sendMessage(Message.UNEXPECTED_ERROR, new Object[0]);
            return;
        }
        if (uuid != null) {
            if (!FloodgateApi.getInstance().isFloodgateId(uuid)) {
                sender.sendMessage(Message.INVALID_USERNAME, new Object[0]);
                return;
            }
            CommandUtil commandUtil = (CommandUtil)context.get("CommandUtil");
            if (add) {
                if (commandUtil.whitelistPlayer(uuid, "unknown")) {
                    sender.sendMessage(Message.PLAYER_ADDED, uuid.toString());
                } else {
                    sender.sendMessage(Message.PLAYER_ALREADY_WHITELISTED, uuid.toString());
                }
            } else if (commandUtil.removePlayerFromWhitelist(uuid, "unknown")) {
                sender.sendMessage(Message.PLAYER_REMOVED, uuid.toString());
            } else {
                sender.sendMessage(Message.PLAYER_NOT_WHITELISTED, uuid.toString());
            }
            return;
        }
        if (name.startsWith(this.config.getUsernamePrefix())) {
            name = name.substring(this.config.getUsernamePrefix().length());
        }
        if (name.isEmpty() || name.length() > 16) {
            sender.sendMessage(Message.INVALID_USERNAME, new Object[0]);
            return;
        }
        String tempName = name;
        if (this.config.isReplaceSpaces()) {
            tempName = tempName.replace(' ', '_');
        }
        String correctName = this.config.getUsernamePrefix() + tempName;
        String strippedName = name;
        this.httpClient.asyncGet("https://api.geysermc.org/v2/xbox/xuid/" + name).whenComplete((result, error) -> {
            JsonElement xuidElement;
            if (error != null) {
                sender.sendMessage(Message.API_UNAVAILABLE, new Object[0]);
                error.printStackTrace();
                return;
            }
            JsonObject response = (JsonObject)result.getResponse();
            if (!result.isCodeOk()) {
                sender.sendMessage(Message.UNEXPECTED_ERROR, new Object[0]);
                this.logger.error("Got an error from requesting the xuid of a Bedrock player: {}", response.get("message").getAsString());
            }
            if ((xuidElement = response.get("xuid")) == null) {
                sender.sendMessage(Message.USER_NOT_FOUND, new Object[0]);
                return;
            }
            String xuid = xuidElement.getAsString();
            CommandUtil commandUtil = (CommandUtil)context.get("CommandUtil");
            try {
                if (add) {
                    if (commandUtil.whitelistPlayer(xuid, correctName)) {
                        sender.sendMessage(Message.PLAYER_ADDED, strippedName);
                    } else {
                        sender.sendMessage(Message.PLAYER_ALREADY_WHITELISTED, strippedName);
                    }
                } else if (commandUtil.removePlayerFromWhitelist(xuid, correctName)) {
                    sender.sendMessage(Message.PLAYER_REMOVED, strippedName);
                } else {
                    sender.sendMessage(Message.PLAYER_NOT_WHITELISTED, strippedName);
                }
            }
            catch (Exception exception) {
                this.logger.error("An unexpected error happened while executing the whitelist command", exception, new Object[0]);
            }
        });
    }

    @Override
    public boolean shouldRegister(FloodgateConfig config) {
        return !(config instanceof ProxyFloodgateConfig);
    }

    public static enum Message implements TranslatableMessage
    {
        INVALID_USERNAME("floodgate.command.fwhitelist.invalid_username"),
        API_UNAVAILABLE("floodgate.command.fwhitelist.api_unavailable " + CommonCommandMessage.CHECK_CONSOLE),
        USER_NOT_FOUND("floodgate.command.fwhitelist.user_not_found"),
        PLAYER_ADDED("floodgate.command.fwhitelist.player_added"),
        PLAYER_REMOVED("floodgate.command.fwhitelist.player_removed"),
        PLAYER_ALREADY_WHITELISTED("floodgate.command.fwhitelist.player_already_whitelisted"),
        PLAYER_NOT_WHITELISTED("floodgate.command.fwhitelist.player_not_whitelisted"),
        UNEXPECTED_ERROR("floodgate.command.fwhitelist.unexpected_error " + CommonCommandMessage.CHECK_CONSOLE);

        private final String rawMessage;
        private final String[] translateParts;

        private Message(String rawMessage) {
            this.rawMessage = rawMessage;
            this.translateParts = rawMessage.split(" ");
        }

        @Override
        public String getRawMessage() {
            return this.rawMessage;
        }

        @Override
        public String[] getTranslateParts() {
            return this.translateParts;
        }
    }
}

