/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.command.main;

import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.Pair;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import org.geysermc.floodgate.core.command.util.Permission;
import org.geysermc.floodgate.core.platform.command.FloodgateSubCommand;
import org.geysermc.floodgate.core.player.UserAudience;
import org.geysermc.floodgate.core.util.HttpClient;
import org.geysermc.floodgate.core.util.Utils;
import org.geysermc.floodgate.shadow.google.inject.Inject;
import org.incendo.cloud.context.CommandContext;

final class FirewallCheckSubcommand
extends FloodgateSubCommand {
    @Inject
    private HttpClient httpClient;

    FirewallCheckSubcommand() {
    }

    @Override
    public String name() {
        return "firewall";
    }

    @Override
    public String description() {
        return "Check if your outgoing firewall allows Floodgate to work properly";
    }

    @Override
    public Permission permission() {
        return Permission.COMMAND_MAIN_FIREWALL;
    }

    @Override
    public void execute(CommandContext<UserAudience> context) {
        UserAudience sender = (UserAudience)context.sender();
        this.executeChecks(this.globalApiCheck(sender)).whenComplete((response, $) -> sender.sendMessage(String.format("\u00a7eThe checks have finished. %s/%s were successful", response.left(), (Integer)response.left() + (Integer)response.right())));
    }

    private BooleanSupplier globalApiCheck(UserAudience sender) {
        return this.executeFirewallText(sender, "global api", () -> {
            HttpClient.HttpResponse<JsonElement> response = this.httpClient.get("https://api.geysermc.org/health", JsonElement.class);
            if (!response.isCodeOk()) {
                throw new IllegalStateException(String.format("Didn't receive an 'ok' http code. Got: %s, response: %s", response.getHttpCode(), response.getResponse()));
            }
        });
    }

    private BooleanSupplier executeFirewallText(UserAudience sender, String name, Runnable runnable) {
        return () -> {
            sender.sendMessage("\u00a7eTesting " + name + "...");
            try {
                runnable.run();
                sender.sendMessage("\u00a7aWas able to connect to " + name + "!");
                return true;
            }
            catch (Exception e) {
                sender.sendMessage("\u00a7cFailed to connect:");
                sender.sendMessage(Utils.getStackTrace(e));
                return false;
            }
        };
    }

    private CompletableFuture<Pair<Integer, Integer>> executeChecks(BooleanSupplier ... checks) {
        return CompletableFuture.supplyAsync(() -> {
            AtomicInteger okCount = new AtomicInteger();
            AtomicInteger failCount = new AtomicInteger();
            for (BooleanSupplier check : checks) {
                if (check.getAsBoolean()) {
                    okCount.getAndIncrement();
                    continue;
                }
                failCount.getAndIncrement();
            }
            return Pair.of((Object)okCount.get(), (Object)failCount.get());
        });
    }
}

