/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.Key;
import org.geysermc.configutils.loader.callback.CallbackResult;
import org.geysermc.configutils.loader.callback.GenericPostInitializeCallback;
import org.geysermc.floodgate.core.config.ConfigLoader;
import org.geysermc.floodgate.core.config.ProxyFloodgateConfig;

public class FloodgateConfig
implements GenericPostInitializeCallback<ConfigLoader> {
    private String keyFileName;
    private String usernamePrefix = "";
    private boolean replaceSpaces;
    private String defaultLocale;
    private DisconnectMessages disconnect;
    private PlayerLinkConfig playerLink;
    private MetricsConfig metrics;
    private boolean debug;
    private int configVersion;
    private Key key;
    private String rawUsernamePrefix;

    public boolean isProxy() {
        return this instanceof ProxyFloodgateConfig;
    }

    @Override
    public CallbackResult postInitialize(ConfigLoader loader) {
        Path keyPath = loader.getDataDirectory().resolve(this.getKeyFileName());
        if (!Files.exists(keyPath, new LinkOption[0])) {
            loader.generateKey(keyPath);
        }
        try {
            Key floodgateKey = loader.getKeyProducer().produceFrom(keyPath);
            loader.getCipher().init(floodgateKey);
            this.key = floodgateKey;
        }
        catch (IOException exception) {
            return CallbackResult.failed(exception.getMessage());
        }
        this.rawUsernamePrefix = this.usernamePrefix;
        if (this.usernamePrefix.length() >= 16) {
            this.usernamePrefix = ".";
        }
        return CallbackResult.ok();
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public String getUsernamePrefix() {
        return this.usernamePrefix;
    }

    public boolean isReplaceSpaces() {
        return this.replaceSpaces;
    }

    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    public DisconnectMessages getDisconnect() {
        return this.disconnect;
    }

    public PlayerLinkConfig getPlayerLink() {
        return this.playerLink;
    }

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getConfigVersion() {
        return this.configVersion;
    }

    public Key getKey() {
        return this.key;
    }

    public String getRawUsernamePrefix() {
        return this.rawUsernamePrefix;
    }

    public static class MetricsConfig {
        private boolean enabled;
        private String uuid;

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getUuid() {
            return this.uuid;
        }
    }

    public static class PlayerLinkConfig {
        private boolean enabled;
        private boolean requireLink;
        private boolean enableOwnLinking;
        private boolean allowed;
        private long linkCodeTimeout;
        private String type;
        private boolean enableGlobalLinking;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isRequireLink() {
            return this.requireLink;
        }

        public boolean isEnableOwnLinking() {
            return this.enableOwnLinking;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public long getLinkCodeTimeout() {
            return this.linkCodeTimeout;
        }

        public String getType() {
            return this.type;
        }

        public boolean isEnableGlobalLinking() {
            return this.enableGlobalLinking;
        }
    }

    public static class DisconnectMessages {
        private String invalidKey;
        private String invalidArgumentsLength;

        public String getInvalidKey() {
            return this.invalidKey;
        }

        public String getInvalidArgumentsLength() {
            return this.invalidArgumentsLength;
        }
    }
}

