/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.inject;

import io.netty.channel.Channel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.geysermc.floodgate.api.inject.InjectorAddon;
import org.geysermc.floodgate.api.inject.PlatformInjector;

public abstract class CommonPlatformInjector
implements PlatformInjector {
    private final Set<Channel> injectedClients = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final Map<Class<?>, InjectorAddon> addons = new HashMap();

    protected boolean addInjectedClient(Channel channel) {
        return this.injectedClients.add(channel);
    }

    public boolean removeInjectedClient(Channel channel) {
        return this.injectedClients.remove(channel);
    }

    public Set<Channel> injectedClients() {
        return this.injectedClients;
    }

    @Override
    public boolean addAddon(InjectorAddon addon) {
        return this.addons.putIfAbsent(addon.getClass(), addon) == null;
    }

    @Override
    public <T extends InjectorAddon> T removeAddon(Class<T> addon) {
        return (T)this.addons.remove(addon);
    }

    public void injectAddonsCall(Channel channel, boolean proxyToServer) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onInject(channel, proxyToServer);
        }
    }

    public void channelClosedCall(Channel channel) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onChannelClosed(channel);
        }
    }

    public void removeAddonsCall(Channel channel) {
        for (InjectorAddon addon : this.addons.values()) {
            if (!addon.shouldInject()) continue;
            addon.onRemoveInject(channel);
        }
    }
}

