/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.packet;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geysermc.floodgate.api.packet.PacketHandler;
import org.geysermc.floodgate.api.packet.PacketHandlers;
import org.geysermc.floodgate.api.util.TriFunction;

public final class PacketHandlersImpl
implements PacketHandlers {
    private final Map<PacketHandler, List<HandlerEntry>> handlers = new HashMap<PacketHandler, List<HandlerEntry>>();
    private final Set<TriFunction<ChannelHandlerContext, Object, Boolean, Object>> globalPacketHandlers = new HashSet<TriFunction<ChannelHandlerContext, Object, Boolean, Object>>();
    private final Map<Class<?>, Set<TriFunction<ChannelHandlerContext, Object, Boolean, Object>>> packetHandlers = new HashMap();

    @Override
    public void register(PacketHandler handler, Class<?> packetClass, TriFunction<ChannelHandlerContext, Object, Boolean, Object> consumer) {
        if (handler == null || packetClass == null || consumer == null) {
            return;
        }
        this.handlers.computeIfAbsent(handler, $ -> new ArrayList()).add(new HandlerEntry(packetClass, consumer));
        this.packetHandlers.computeIfAbsent(packetClass, $ -> new HashSet<TriFunction<ChannelHandlerContext, Object, Boolean, Object>>(this.globalPacketHandlers)).add(consumer);
    }

    @Override
    public void registerAll(PacketHandler handler) {
        if (handler == null) {
            return;
        }
        TriFunction<ChannelHandlerContext, Object, Boolean, Object> packetHandler = handler::handle;
        this.handlers.computeIfAbsent(handler, $ -> new ArrayList()).add(new HandlerEntry(null, packetHandler));
        this.globalPacketHandlers.add(packetHandler);
        for (Set<TriFunction<ChannelHandlerContext, Object, Boolean, Object>> handle : this.packetHandlers.values()) {
            handle.add(packetHandler);
        }
    }

    @Override
    public void deregister(PacketHandler handler) {
        if (handler == null) {
            return;
        }
        List<HandlerEntry> values = this.handlers.remove(handler);
        if (values != null) {
            for (HandlerEntry value : values) {
                Set<TriFunction<ChannelHandlerContext, Object, Boolean, Object>> handlers = this.packetHandlers.get(value.getPacket());
                if (handlers != null) {
                    handlers.removeIf(o -> o.equals(value.getHandler()));
                    if (handlers.isEmpty()) {
                        this.packetHandlers.remove(value.getPacket());
                    }
                }
                this.globalPacketHandlers.remove(value.getHandler());
            }
        }
    }

    public Collection<TriFunction<ChannelHandlerContext, Object, Boolean, Object>> getPacketHandlers(Class<?> packet) {
        return this.packetHandlers.getOrDefault(packet, Collections.emptySet());
    }

    public boolean hasHandlers() {
        return !this.handlers.isEmpty();
    }

    private static final class HandlerEntry {
        private final Class<?> packet;
        private final TriFunction<ChannelHandlerContext, Object, Boolean, Object> handler;

        public HandlerEntry(Class<?> packet, TriFunction<ChannelHandlerContext, Object, Boolean, Object> handler) {
            this.packet = packet;
            this.handler = handler;
        }

        public Class<?> getPacket() {
            return this.packet;
        }

        public TriFunction<ChannelHandlerContext, Object, Boolean, Object> getHandler() {
            return this.handler;
        }
    }
}

