/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.core.player;

import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.core.platform.command.CommandUtil;
import org.geysermc.floodgate.core.platform.command.TranslatableMessage;

public class UserAudience {
    private final @NonNull UUID uuid;
    private final @NonNull String username;
    private final @NonNull String locale;
    private final @NonNull Object source;
    private final @NonNull CommandUtil commandUtil;

    public UserAudience(@NonNull UUID uuid, @NonNull String username, @NonNull String locale, @NonNull Object source, @NonNull CommandUtil commandUtil) {
        this.uuid = Objects.requireNonNull(uuid);
        this.username = username;
        this.locale = Objects.requireNonNull(locale);
        this.source = Objects.requireNonNull(source);
        this.commandUtil = Objects.requireNonNull(commandUtil);
    }

    public boolean hasPermission(@NonNull String permission) {
        return this.commandUtil.hasPermission(this.source(), permission);
    }

    public void sendMessage(String message) {
        this.commandUtil.sendMessage(this.source(), message);
    }

    public void sendMessage(TranslatableMessage message, Object ... args) {
        this.sendMessage(this.translateMessage(message, args));
    }

    public void disconnect(@NonNull String reason) {
        this.commandUtil.kickPlayer(this.source(), reason);
    }

    public void disconnect(TranslatableMessage message, Object ... args) {
        this.disconnect(this.translateMessage(message, args));
    }

    public String translateMessage(TranslatableMessage message, Object ... args) {
        return this.commandUtil.translateMessage(this.locale(), message, args);
    }

    public @NonNull UUID uuid() {
        return this.uuid;
    }

    public @NonNull String username() {
        return this.username;
    }

    public @NonNull String locale() {
        return this.locale;
    }

    public @NonNull Object source() {
        return this.source;
    }

    public @NonNull CommandUtil commandUtil() {
        return this.commandUtil;
    }

    public static class ConsoleAudience
    extends UserAudience {
        public ConsoleAudience(@NonNull Object source, @NonNull CommandUtil commandUtil) {
            super(new UUID(0L, 0L), "CONSOLE", "en_us", source, commandUtil);
        }
    }

    public static class PlayerAudience
    extends UserAudience {
        private final boolean online;

        public PlayerAudience(@NonNull UUID uuid, @NonNull String username, @NonNull String locale, @NonNull Object source, @NonNull CommandUtil commandUtil, boolean online) {
            super(uuid, username, locale, source, commandUtil);
            this.online = online;
        }

        public boolean online() {
            return this.online;
        }
    }
}

