/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod;

import java.io.IOException;
import java.io.InputStream;
import net.minecraft.server.MinecraftServer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.FloodgatePlatform;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.geysermc.floodgate.mod.module.ModAddonModule;
import org.geysermc.floodgate.mod.module.ModListenerModule;
import org.geysermc.floodgate.shadow.google.inject.Guice;
import org.geysermc.floodgate.shadow.google.inject.Injector;
import org.geysermc.floodgate.shadow.google.inject.Module;

public abstract class FloodgateMod {
    public static FloodgateMod INSTANCE;
    private boolean started;
    private FloodgatePlatform platform;
    protected Injector injector;

    protected void init(Module ... modules) {
        INSTANCE = this;
        this.injector = Guice.createInjector(modules);
        this.platform = this.injector.getInstance(FloodgatePlatform.class);
    }

    protected void enable(MinecraftServer server) {
        long ctm = System.currentTimeMillis();
        MinecraftServerHolder.set(server);
        if (!this.started) {
            this.platform.enable(new ModAddonModule(), new ModListenerModule());
            this.started = true;
        }
        long endCtm = System.currentTimeMillis();
        this.injector.getInstance(FloodgateLogger.class).translatedInfo("floodgate.core.finish", endCtm - ctm);
    }

    protected void disable() {
        this.platform.disable();
    }

    protected void enable(Module ... module) {
        this.platform.enable(module);
    }

    public abstract @NonNull InputStream resourceStream(String var1) throws IOException;

    public abstract void schedule(Runnable var1, int var2);

    public abstract boolean isClient();
}

