/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.data;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.logging.LogUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.Objects;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.handshake.ClientIntentionPacket;
import net.minecraft.network.protocol.login.ServerboundHelloPacket;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.core.addon.data.CommonDataHandler;
import org.geysermc.floodgate.core.addon.data.PacketBlocker;
import org.geysermc.floodgate.core.config.FloodgateConfig;
import org.geysermc.floodgate.core.player.FloodgateHandshakeHandler;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.geysermc.floodgate.mod.mixin.ClientIntentionPacketMixinInterface;
import org.geysermc.floodgate.mod.mixin.ConnectionMixin;
import org.slf4j.Logger;

public final class ModDataHandler
extends CommonDataHandler {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final FloodgateLogger logger;
    private Connection networkManager;
    private FloodgatePlayer player;

    public ModDataHandler(FloodgateHandshakeHandler handshakeHandler, FloodgateConfig config, AttributeKey<String> kickMessageAttribute, FloodgateLogger logger) {
        super(handshakeHandler, config, kickMessageAttribute, new PacketBlocker());
        this.logger = logger;
    }

    @Override
    protected void setNewIp(Channel channel, InetSocketAddress newIp) {
        ((ConnectionMixin)this.networkManager).setAddress(newIp);
    }

    @Override
    protected Object setHostname(Object handshakePacket, String hostname) {
        ((ClientIntentionPacketMixinInterface)handshakePacket).setAddress(hostname);
        return handshakePacket;
    }

    @Override
    protected boolean shouldRemoveHandler(FloodgateHandshakeHandler.HandshakeResult result) {
        this.player = result.getFloodgatePlayer();
        if (this.getKickMessage() != null) {
            return false;
        }
        if (this.player == null) {
            return true;
        }
        if (result.getResultType() == FloodgateHandshakeHandler.ResultType.SUCCESS) {
            this.logger.info("Floodgate player who is logged in as {} {} joined", this.player.getCorrectUsername(), this.player.getCorrectUniqueId());
        }
        return false;
    }

    @Override
    protected boolean channelRead(Object packet) {
        if (packet instanceof ClientIntentionPacket) {
            ClientIntentionPacket intentionPacket = (ClientIntentionPacket)packet;
            this.ctx.pipeline().addAfter("splitter", "floodgate_packet_blocker", (ChannelHandler)this.blocker);
            this.networkManager = (Connection)this.ctx.channel().pipeline().get("packet_handler");
            this.handle(packet, intentionPacket.hostName());
            return false;
        }
        return !this.checkAndHandleLogin(packet);
    }

    private boolean checkAndHandleLogin(Object packet) {
        if (packet instanceof ServerboundHelloPacket) {
            String kickMessage = this.getKickMessage();
            if (kickMessage != null) {
                Component message = Component.nullToEmpty((String)kickMessage);
                PacketListener packetListener = this.networkManager.getPacketListener();
                if (packetListener instanceof ServerLoginPacketListenerImpl) {
                    ServerLoginPacketListenerImpl loginPacketListener = (ServerLoginPacketListenerImpl)packetListener;
                    loginPacketListener.disconnect(message);
                } else {
                    this.networkManager.disconnect(message);
                }
                return true;
            }
            PacketListener loginPacketListener = this.networkManager.getPacketListener();
            if (!(loginPacketListener instanceof ServerLoginPacketListenerImpl)) {
                this.ctx.pipeline().remove((ChannelHandler)this);
                return true;
            }
            ServerLoginPacketListenerImpl packetListener = (ServerLoginPacketListenerImpl)loginPacketListener;
            GameProfile gameProfile = new GameProfile(this.player.getCorrectUniqueId(), this.player.getCorrectUsername());
            if (this.player.isLinked() && this.player.getCorrectUniqueId().version() == 4) {
                this.verifyLinkedPlayerAsync(packetListener, gameProfile);
            } else {
                packetListener.startClientVerification(gameProfile);
            }
            this.ctx.pipeline().remove((ChannelHandler)this);
            return true;
        }
        return false;
    }

    private void verifyLinkedPlayerAsync(final ServerLoginPacketListenerImpl packetListener, final GameProfile gameProfile) {
        Thread texturesThread = new Thread(this, "Bedrock Linked Player Texture Download"){

            @Override
            public void run() {
                GameProfile effectiveProfile = gameProfile;
                try {
                    MinecraftSessionService service = MinecraftServerHolder.get().services().sessionService();
                    effectiveProfile = Objects.requireNonNull(service.fetchProfile(effectiveProfile.id(), true)).profile();
                }
                catch (Exception e) {
                    LOGGER.error("Unable to get Bedrock linked player textures for " + effectiveProfile.name(), (Throwable)e);
                }
                packetListener.startClientVerification(effectiveProfile);
            }
        };
        texturesThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(LOGGER));
        texturesThread.start();
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        if (this.config.isDebug()) {
            LOGGER.error("Exception caught in FabricDataHandler", cause);
        }
    }
}

