/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.inject;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.inject.CommonPlatformInjector;
import org.geysermc.floodgate.shadow.google.inject.Inject;

public final class ModInjector
extends CommonPlatformInjector {
    public static ModInjector INSTANCE = new ModInjector();
    private final boolean injected = true;
    @Inject
    private FloodgateLogger logger;

    @Override
    public void inject() throws Exception {
    }

    public void injectClient(ChannelFuture future) {
        if (future.channel().pipeline().names().contains("floodgate-init")) {
            this.logger.debug("Tried to inject twice!", new Object[0]);
            return;
        }
        future.channel().pipeline().addFirst("floodgate-init", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelRead(@NonNull ChannelHandlerContext ctx, @NonNull Object msg) throws Exception {
                super.channelRead(ctx, msg);
                if (!(msg instanceof Channel)) {
                    return;
                }
                Channel channel = (Channel)msg;
                channel.pipeline().addLast(new ChannelHandler[]{new ChannelInitializer<Channel>(){

                    protected void initChannel(@NonNull Channel channel) {
                        ModInjector.this.injectAddonsCall(channel, false);
                        ModInjector.this.addInjectedClient(channel);
                        channel.closeFuture().addListener(listener -> {
                            ModInjector.this.channelClosedCall(channel);
                            ModInjector.this.removeInjectedClient(channel);
                        });
                    }
                }});
            }
        });
    }

    @Override
    public void removeInjection() throws Exception {
    }

    @Override
    public boolean isInjected() {
        return this.injected;
    }
}

