/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.pluginmessage;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collections;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoRemovePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.event.skin.SkinApplyEvent;
import org.geysermc.floodgate.api.player.FloodgatePlayer;
import org.geysermc.floodgate.core.skin.SkinApplier;
import org.geysermc.floodgate.mod.FloodgateMod;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.geysermc.floodgate.mod.mixin.ChunkMapMixin;
import org.geysermc.floodgate.mod.mixin.PlayerAccessor;

public final class ModSkinApplier
implements SkinApplier {
    @Override
    public void applySkin(@NonNull FloodgatePlayer floodgatePlayer, @NonNull SkinApplyEvent.SkinData skinData) {
        this.applySkin(floodgatePlayer, skinData, true);
    }

    public void applySkin(@NonNull FloodgatePlayer floodgatePlayer, @NonNull SkinApplyEvent.SkinData skinData, boolean firstTry) {
        MinecraftServerHolder.get().execute(() -> {
            ServerPlayer bedrockPlayer = MinecraftServerHolder.get().getPlayerList().getPlayer(floodgatePlayer.getCorrectUniqueId());
            if (bedrockPlayer == null) {
                if (firstTry) {
                    FloodgateMod.INSTANCE.schedule(() -> this.applySkin(floodgatePlayer, skinData, false), 200);
                }
                return;
            }
            ListMultimap properties = MultimapBuilder.hashKeys().arrayListValues().build();
            properties.put((Object)"textures", (Object)new Property("textures", skinData.value(), skinData.signature()));
            ((PlayerAccessor)bedrockPlayer).setGameProfile(new GameProfile(bedrockPlayer.getGameProfile().id(), bedrockPlayer.getGameProfile().name(), new PropertyMap((Multimap)properties)));
            ChunkMap tracker = ((ServerLevel)bedrockPlayer.level).getChunkSource().chunkMap;
            ChunkMap.TrackedEntity entry = (ChunkMap.TrackedEntity)((ChunkMapMixin)tracker).getEntityMap().get(bedrockPlayer.getId());
            for (ServerPlayer otherPlayer : MinecraftServerHolder.get().getPlayerList().getPlayers()) {
                boolean samePlayer;
                boolean bl = samePlayer = otherPlayer == bedrockPlayer;
                if (!samePlayer) {
                    entry.removePlayer(otherPlayer);
                }
                otherPlayer.connection.send((Packet)new ClientboundPlayerInfoRemovePacket(Collections.singletonList(bedrockPlayer.getUUID())));
                otherPlayer.connection.send((Packet)ClientboundPlayerInfoUpdatePacket.createPlayerInitializing(Collections.singletonList(bedrockPlayer)));
                if (samePlayer || bedrockPlayer.level != otherPlayer.level) continue;
                entry.updatePlayer(otherPlayer);
            }
        });
    }
}

