/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.mod.util;

import java.util.Collection;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.NameAndId;
import net.minecraft.server.players.UserWhiteListEntry;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.logger.FloodgateLogger;
import org.geysermc.floodgate.core.platform.command.CommandUtil;
import org.geysermc.floodgate.core.player.UserAudience;
import org.geysermc.floodgate.core.util.LanguageManager;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.incendo.cloud.CommandManager;

public final class ModCommandUtil
extends CommandUtil {
    private final FloodgateLogger logger;
    private UserAudience console;
    private CommandManager<UserAudience> commandManager;

    public ModCommandUtil(LanguageManager manager, FloodgateApi api, FloodgateLogger logger) {
        super(manager, api);
        this.logger = logger;
    }

    @Override
    public @NonNull UserAudience getUserAudience(@NonNull Object sourceObj) {
        if (!(sourceObj instanceof CommandSourceStack)) {
            throw new IllegalArgumentException();
        }
        CommandSourceStack stack = (CommandSourceStack)sourceObj;
        if (stack.getEntity() == null) {
            if (this.console != null) {
                return this.console;
            }
            this.console = new UserAudience.ConsoleAudience(stack, this);
            return this.console;
        }
        ServerPlayer player = stack.getPlayer();
        return new UserAudience.PlayerAudience(player.getUUID(), player.getGameProfile().name(), "en_US", stack, this, true);
    }

    @Override
    protected String getUsernameFromSource(@NonNull Object source) {
        return ((ServerPlayer)source).getGameProfile().name();
    }

    @Override
    protected UUID getUuidFromSource(@NonNull Object source) {
        return ((ServerPlayer)source).getUUID();
    }

    @Override
    public Object getPlayerByUuid(@NonNull UUID uuid) {
        ServerPlayer player = MinecraftServerHolder.get().getPlayerList().getPlayer(uuid);
        return player != null ? player : uuid;
    }

    @Override
    public Object getPlayerByUsername(@NonNull String username) {
        ServerPlayer player = MinecraftServerHolder.get().getPlayerList().getPlayerByName(username);
        return player != null ? player : username;
    }

    @Override
    protected Collection<?> getOnlinePlayers() {
        return MinecraftServerHolder.get().getPlayerList().getPlayers();
    }

    @Override
    public boolean hasPermission(Object source, String permission) {
        return this.commandManager.hasPermission((Object)this.getUserAudience(source), permission);
    }

    @Override
    public void sendMessage(Object target, String message) {
        CommandSourceStack commandSource = (CommandSourceStack)target;
        if (commandSource.getEntity() instanceof ServerPlayer) {
            MinecraftServerHolder.get().execute(() -> ((ServerPlayer)commandSource.getEntity()).displayClientMessage((Component)Component.literal((String)message), false));
        } else {
            this.logger.info(message, new Object[0]);
        }
    }

    @Override
    public void kickPlayer(Object o, String message) {
        if (o instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)o;
            player.connection.disconnect((Component)Component.literal((String)message));
        }
    }

    @Override
    public boolean whitelistPlayer(UUID uuid, String username) {
        NameAndId nameAndId = new NameAndId(uuid, username);
        MinecraftServerHolder.get().getPlayerList().getWhiteList().add(new UserWhiteListEntry(nameAndId));
        return true;
    }

    @Override
    public boolean removePlayerFromWhitelist(UUID uuid, String username) {
        NameAndId nameAndId = new NameAndId(uuid, username);
        MinecraftServerHolder.get().getPlayerList().getWhiteList().remove(nameAndId);
        return true;
    }

    public void setCommandManager(CommandManager<UserAudience> commandManager) {
        this.commandManager = commandManager;
    }
}

