/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.platform.neoforge.pluginmessage;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.geysermc.floodgate.core.platform.pluginmessage.PluginMessageUtils;
import org.geysermc.floodgate.mod.MinecraftServerHolder;
import org.geysermc.floodgate.mod.pluginmessage.payloads.FormPayload;
import org.geysermc.floodgate.mod.pluginmessage.payloads.PacketPayload;
import org.geysermc.floodgate.mod.pluginmessage.payloads.SkinPayload;
import org.geysermc.floodgate.mod.pluginmessage.payloads.TransferPayload;

public class NeoForgePluginMessageUtils
extends PluginMessageUtils {
    @Override
    public boolean sendMessage(UUID uuid, String channel, byte[] data) {
        try {
            ServerPlayer player = MinecraftServerHolder.get().getPlayerList().getPlayer(uuid);
            Record payload = switch (channel) {
                case "floodgate:form" -> new FormPayload(data);
                case "floodgate:packet" -> new PacketPayload(data);
                case "floodgate:skin" -> new SkinPayload(data);
                case "floodgate:transfer" -> new TransferPayload(data);
                default -> throw new IllegalArgumentException("unknown channel: " + channel);
            };
            Objects.requireNonNull(player);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

