/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.platform.neoforge.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public final class TaskTimer {
    public static final TaskTimer INSTANCE = new TaskTimer();
    private final List<Task> tasks = new LinkedList<Task>();

    public void runLater(Runnable runnable, int delay) {
        this.tasks.add(new Task(delay, runnable));
    }

    public void onEndTick(ServerTickEvent.Post event) {
        Iterator<Task> iterator = this.tasks.iterator();
        while (iterator.hasNext()) {
            Task task = iterator.next();
            if (--task.ticks > 0L) continue;
            try {
                task.run.run();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            iterator.remove();
        }
    }

    private static class Task {
        long ticks;
        Runnable run;

        Task(long ticks, Runnable run) {
            this.ticks = ticks;
            this.run = run;
        }
    }
}

