/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import com.google.common.base.Preconditions;
import org.geysermc.floodgate.shadow.google.inject.Provider;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalContext;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalFactory;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalProvisionException;
import org.geysermc.floodgate.shadow.google.inject.spi.Dependency;

final class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Provider<? extends T> provider;
    private final Object source;

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider, Object source) {
        this.provider = (Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
    }

    @Override
    public T get(InternalContext context, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        context.setDependency(dependency);
        try {
            T t = this.provider.get();
            if (t == null && !dependency.isNullable()) {
                InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
            }
            return t;
        }
        catch (RuntimeException userException) {
            throw InternalProvisionException.errorInProvider(userException).addSource(this.source);
        }
    }

    public String toString() {
        return this.provider.toString();
    }
}

