/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import org.geysermc.floodgate.shadow.google.inject.Provider;
import org.geysermc.floodgate.shadow.google.inject.internal.AbstractProcessor;
import org.geysermc.floodgate.shadow.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.google.inject.internal.ErrorsException;
import org.geysermc.floodgate.shadow.google.inject.internal.MembersInjectorImpl;
import org.geysermc.floodgate.shadow.google.inject.spi.MembersInjectorLookup;
import org.geysermc.floodgate.shadow.google.inject.spi.ProviderLookup;

final class LookupProcessor
extends AbstractProcessor {
    LookupProcessor(Errors errors) {
        super(errors);
    }

    @Override
    public <T> Boolean visit(MembersInjectorLookup<T> lookup) {
        try {
            MembersInjectorImpl<T> membersInjector = this.injector.membersInjectorStore.get(lookup.getType(), this.errors);
            lookup.initializeDelegate(membersInjector);
            this.injector.getBindingData().putMembersInjectorLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }

    @Override
    public <T> Boolean visit(ProviderLookup<T> lookup) {
        try {
            Provider<T> provider = this.injector.getProviderOrThrow(lookup.getDependency(), this.errors);
            lookup.initializeDelegate(provider);
            this.injector.getBindingData().putProviderLookup(lookup);
        }
        catch (ErrorsException e) {
            this.errors.merge(e.getErrors());
        }
        return true;
    }
}

