/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BiFunction;
import org.geysermc.floodgate.shadow.google.inject.internal.BytecodeGen;
import org.geysermc.floodgate.shadow.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.google.inject.internal.ErrorsException;
import org.geysermc.floodgate.shadow.google.inject.internal.InjectorImpl;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalContext;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalFlags;
import org.geysermc.floodgate.shadow.google.inject.internal.InternalProvisionException;
import org.geysermc.floodgate.shadow.google.inject.internal.SingleMemberInjector;
import org.geysermc.floodgate.shadow.google.inject.internal.SingleParameterInjector;
import org.geysermc.floodgate.shadow.google.inject.spi.InjectionPoint;

final class SingleMethodInjector
implements SingleMemberInjector {
    private final InjectorImpl.MethodInvoker methodInvoker;
    private final SingleParameterInjector<?>[] parameterInjectors;
    private final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        int modifiers;
        if (InternalFlags.isBytecodeGenEnabled()) {
            try {
                final BiFunction<Object, Object[], Object> fastMethod = BytecodeGen.fastMethod(method);
                if (fastMethod != null) {
                    return new InjectorImpl.MethodInvoker(this){

                        @Override
                        public Object invoke(Object target, Object ... parameters) throws InvocationTargetException {
                            try {
                                return fastMethod.apply(target, parameters);
                            }
                            catch (Throwable e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                }
            }
            catch (Exception | LinkageError fastMethod) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(modifiers = method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            method.setAccessible(true);
        }
        return new InjectorImpl.MethodInvoker(this){

            @Override
            public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(target, parameters);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(InternalContext context, Object o) throws InternalProvisionException {
        Object[] parameters = SingleParameterInjector.getAll(context, this.parameterInjectors);
        try {
            this.methodInvoker.invoke(o, parameters);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            throw InternalProvisionException.errorInjectingMethod(cause).addSource(this.injectionPoint);
        }
    }
}

