/*
 * Decompiled with CFR 0.152.
 */
package org.geysermc.floodgate.shadow.google.inject.spi;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.geysermc.floodgate.shadow.google.inject.Binder;
import org.geysermc.floodgate.shadow.google.inject.Key;
import org.geysermc.floodgate.shadow.google.inject.Provider;
import org.geysermc.floodgate.shadow.google.inject.internal.Errors;
import org.geysermc.floodgate.shadow.google.inject.spi.Dependency;
import org.geysermc.floodgate.shadow.google.inject.spi.Element;
import org.geysermc.floodgate.shadow.google.inject.spi.ElementVisitor;
import org.geysermc.floodgate.shadow.google.inject.spi.ProviderWithDependencies;
import org.geysermc.floodgate.shadow.google.inject.util.Types;

public final class ProviderLookup<T>
implements Element {
    private final Object source;
    private final Dependency<T> dependency;
    private Provider<T> delegate;

    public ProviderLookup(Object source, Key<T> key) {
        this(source, Dependency.get((Key)Preconditions.checkNotNull(key, (Object)"key")));
    }

    public ProviderLookup(Object source, Dependency<T> dependency) {
        this.source = Preconditions.checkNotNull((Object)source, (Object)"source");
        this.dependency = (Dependency)Preconditions.checkNotNull(dependency, (Object)"dependency");
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public Key<T> getKey() {
        return this.dependency.getKey();
    }

    public Dependency<T> getDependency() {
        return this.dependency;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public void initializeDelegate(Provider<T> delegate) {
        Preconditions.checkState((this.delegate == null ? 1 : 0) != 0, (Object)"delegate already initialized");
        this.delegate = (Provider)Preconditions.checkNotNull(delegate, (Object)"delegate");
    }

    @Override
    public void applyTo(Binder binder) {
        this.initializeDelegate(binder.withSource(this.getSource()).getProvider(this.dependency));
    }

    public Provider<T> getDelegate() {
        return this.delegate;
    }

    public Provider<T> getProvider() {
        return new ProviderWithDependencies<T>(){

            @Override
            public T get() {
                Provider local = ProviderLookup.this.delegate;
                if (local == null) {
                    throw new IllegalStateException("This Provider cannot be used until the Injector has been created.");
                }
                return local.get();
            }

            @Override
            public Set<Dependency<?>> getDependencies() {
                Key<?> providerKey = ProviderLookup.this.getKey().ofType(Types.providerOf(ProviderLookup.this.getKey().getTypeLiteral().getType()));
                return ImmutableSet.of(Dependency.get(providerKey));
            }

            public String toString() {
                return "Provider<" + ProviderLookup.this.getKey().getTypeLiteral() + ">";
            }
        };
    }

    public String toString() {
        return MoreObjects.toStringHelper(ProviderLookup.class).add("dependency", this.dependency).add("source", Errors.convert(this.source)).toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof ProviderLookup && ((ProviderLookup)obj).dependency.equals(this.dependency) && ((ProviderLookup)obj).source.equals(this.source);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dependency, this.source});
    }
}

