/*
 * Decompiled with CFR 0.152.
 */
package net.arthurorsi.mineralbackpacks.world.inventory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.arthurorsi.mineralbackpacks.init.MineralBackpacksModMenus;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class GuiNetheriteMenu
extends AbstractContainerMenu
implements Supplier<Map<Integer, Slot>> {
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private IItemHandler internal;
    private final Map<Integer, Slot> customSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    private BlockEntity boundBlockEntity = null;

    public GuiNetheriteMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)MineralBackpacksModMenus.GUI_NETHERITE.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        this.internal = new ItemStackHandler(88);
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            if (extraData.readableBytes() == 1) {
                byte hand = extraData.readByte();
                itemstack = hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem();
                this.boundItemMatcher = () -> itemstack == (hand == 0 ? this.entity.getMainHandItem() : this.entity.getOffhandItem());
                IItemHandler cap = (IItemHandler)itemstack.getCapability(Capabilities.ItemHandler.ITEM);
                if (cap != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else if (extraData.readableBytes() > 1) {
                IItemHandler cap;
                extraData.readByte();
                this.boundEntity = this.world.getEntity(extraData.readVarInt());
                if (this.boundEntity != null && (cap = (IItemHandler)this.boundEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
                    this.internal = cap;
                    this.bound = true;
                }
            } else {
                this.boundBlockEntity = this.world.getBlockEntity(pos);
                itemstack = this.boundBlockEntity;
                if (itemstack instanceof BaseContainerBlockEntity) {
                    BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)itemstack;
                    this.internal = new InvWrapper((Container)baseContainerBlockEntity);
                    this.bound = true;
                }
            }
        }
        this.customSlots.put(0, this.addSlot((Slot)new SlotItemHandler(this.internal, 0, 7, 7){
            private final int slot = 0;
            private int x;
            private int y;
            {
                this.slot = 0;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(1, this.addSlot((Slot)new SlotItemHandler(this.internal, 1, 25, 7){
            private final int slot = 1;
            private int x;
            private int y;
            {
                this.slot = 1;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(2, this.addSlot((Slot)new SlotItemHandler(this.internal, 2, 43, 7){
            private final int slot = 2;
            private int x;
            private int y;
            {
                this.slot = 2;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(3, this.addSlot((Slot)new SlotItemHandler(this.internal, 3, 61, 7){
            private final int slot = 3;
            private int x;
            private int y;
            {
                this.slot = 3;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(4, this.addSlot((Slot)new SlotItemHandler(this.internal, 4, 79, 7){
            private final int slot = 4;
            private int x;
            private int y;
            {
                this.slot = 4;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(5, this.addSlot((Slot)new SlotItemHandler(this.internal, 5, 97, 7){
            private final int slot = 5;
            private int x;
            private int y;
            {
                this.slot = 5;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(6, this.addSlot((Slot)new SlotItemHandler(this.internal, 6, 115, 7){
            private final int slot = 6;
            private int x;
            private int y;
            {
                this.slot = 6;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(7, this.addSlot((Slot)new SlotItemHandler(this.internal, 7, 133, 7){
            private final int slot = 7;
            private int x;
            private int y;
            {
                this.slot = 7;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(8, this.addSlot((Slot)new SlotItemHandler(this.internal, 8, 151, 7){
            private final int slot = 8;
            private int x;
            private int y;
            {
                this.slot = 8;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(9, this.addSlot((Slot)new SlotItemHandler(this.internal, 9, 169, 7){
            private final int slot = 9;
            private int x;
            private int y;
            {
                this.slot = 9;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(10, this.addSlot((Slot)new SlotItemHandler(this.internal, 10, 187, 7){
            private final int slot = 10;
            private int x;
            private int y;
            {
                this.slot = 10;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(11, this.addSlot((Slot)new SlotItemHandler(this.internal, 11, 7, 25){
            private final int slot = 11;
            private int x;
            private int y;
            {
                this.slot = 11;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(12, this.addSlot((Slot)new SlotItemHandler(this.internal, 12, 25, 25){
            private final int slot = 12;
            private int x;
            private int y;
            {
                this.slot = 12;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(13, this.addSlot((Slot)new SlotItemHandler(this.internal, 13, 43, 25){
            private final int slot = 13;
            private int x;
            private int y;
            {
                this.slot = 13;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(14, this.addSlot((Slot)new SlotItemHandler(this.internal, 14, 61, 25){
            private final int slot = 14;
            private int x;
            private int y;
            {
                this.slot = 14;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(15, this.addSlot((Slot)new SlotItemHandler(this.internal, 15, 79, 25){
            private final int slot = 15;
            private int x;
            private int y;
            {
                this.slot = 15;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(16, this.addSlot((Slot)new SlotItemHandler(this.internal, 16, 97, 25){
            private final int slot = 16;
            private int x;
            private int y;
            {
                this.slot = 16;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(17, this.addSlot((Slot)new SlotItemHandler(this.internal, 17, 115, 25){
            private final int slot = 17;
            private int x;
            private int y;
            {
                this.slot = 17;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(18, this.addSlot((Slot)new SlotItemHandler(this.internal, 18, 133, 25){
            private final int slot = 18;
            private int x;
            private int y;
            {
                this.slot = 18;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(19, this.addSlot((Slot)new SlotItemHandler(this.internal, 19, 151, 25){
            private final int slot = 19;
            private int x;
            private int y;
            {
                this.slot = 19;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(20, this.addSlot((Slot)new SlotItemHandler(this.internal, 20, 169, 25){
            private final int slot = 20;
            private int x;
            private int y;
            {
                this.slot = 20;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(21, this.addSlot((Slot)new SlotItemHandler(this.internal, 21, 187, 25){
            private final int slot = 21;
            private int x;
            private int y;
            {
                this.slot = 21;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(22, this.addSlot((Slot)new SlotItemHandler(this.internal, 22, 7, 43){
            private final int slot = 22;
            private int x;
            private int y;
            {
                this.slot = 22;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(23, this.addSlot((Slot)new SlotItemHandler(this.internal, 23, 25, 43){
            private final int slot = 23;
            private int x;
            private int y;
            {
                this.slot = 23;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(24, this.addSlot((Slot)new SlotItemHandler(this.internal, 24, 43, 43){
            private final int slot = 24;
            private int x;
            private int y;
            {
                this.slot = 24;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(25, this.addSlot((Slot)new SlotItemHandler(this.internal, 25, 61, 43){
            private final int slot = 25;
            private int x;
            private int y;
            {
                this.slot = 25;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(26, this.addSlot((Slot)new SlotItemHandler(this.internal, 26, 79, 43){
            private final int slot = 26;
            private int x;
            private int y;
            {
                this.slot = 26;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(27, this.addSlot((Slot)new SlotItemHandler(this.internal, 27, 97, 43){
            private final int slot = 27;
            private int x;
            private int y;
            {
                this.slot = 27;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(28, this.addSlot((Slot)new SlotItemHandler(this.internal, 28, 115, 43){
            private final int slot = 28;
            private int x;
            private int y;
            {
                this.slot = 28;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(29, this.addSlot((Slot)new SlotItemHandler(this.internal, 29, 133, 43){
            private final int slot = 29;
            private int x;
            private int y;
            {
                this.slot = 29;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(30, this.addSlot((Slot)new SlotItemHandler(this.internal, 30, 151, 43){
            private final int slot = 30;
            private int x;
            private int y;
            {
                this.slot = 30;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(31, this.addSlot((Slot)new SlotItemHandler(this.internal, 31, 169, 43){
            private final int slot = 31;
            private int x;
            private int y;
            {
                this.slot = 31;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(32, this.addSlot((Slot)new SlotItemHandler(this.internal, 32, 187, 43){
            private final int slot = 32;
            private int x;
            private int y;
            {
                this.slot = 32;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(33, this.addSlot((Slot)new SlotItemHandler(this.internal, 33, 7, 61){
            private final int slot = 33;
            private int x;
            private int y;
            {
                this.slot = 33;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(34, this.addSlot((Slot)new SlotItemHandler(this.internal, 34, 25, 61){
            private final int slot = 34;
            private int x;
            private int y;
            {
                this.slot = 34;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(35, this.addSlot((Slot)new SlotItemHandler(this.internal, 35, 43, 61){
            private final int slot = 35;
            private int x;
            private int y;
            {
                this.slot = 35;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(36, this.addSlot((Slot)new SlotItemHandler(this.internal, 36, 61, 61){
            private final int slot = 36;
            private int x;
            private int y;
            {
                this.slot = 36;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(37, this.addSlot((Slot)new SlotItemHandler(this.internal, 37, 79, 61){
            private final int slot = 37;
            private int x;
            private int y;
            {
                this.slot = 37;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(38, this.addSlot((Slot)new SlotItemHandler(this.internal, 38, 97, 61){
            private final int slot = 38;
            private int x;
            private int y;
            {
                this.slot = 38;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(39, this.addSlot((Slot)new SlotItemHandler(this.internal, 39, 115, 61){
            private final int slot = 39;
            private int x;
            private int y;
            {
                this.slot = 39;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(40, this.addSlot((Slot)new SlotItemHandler(this.internal, 40, 133, 61){
            private final int slot = 40;
            private int x;
            private int y;
            {
                this.slot = 40;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(41, this.addSlot((Slot)new SlotItemHandler(this.internal, 41, 151, 61){
            private final int slot = 41;
            private int x;
            private int y;
            {
                this.slot = 41;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(42, this.addSlot((Slot)new SlotItemHandler(this.internal, 42, 169, 61){
            private final int slot = 42;
            private int x;
            private int y;
            {
                this.slot = 42;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(43, this.addSlot((Slot)new SlotItemHandler(this.internal, 43, 187, 61){
            private final int slot = 43;
            private int x;
            private int y;
            {
                this.slot = 43;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(44, this.addSlot((Slot)new SlotItemHandler(this.internal, 44, 7, 79){
            private final int slot = 44;
            private int x;
            private int y;
            {
                this.slot = 44;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(45, this.addSlot((Slot)new SlotItemHandler(this.internal, 45, 25, 79){
            private final int slot = 45;
            private int x;
            private int y;
            {
                this.slot = 45;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(46, this.addSlot((Slot)new SlotItemHandler(this.internal, 46, 43, 79){
            private final int slot = 46;
            private int x;
            private int y;
            {
                this.slot = 46;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(47, this.addSlot((Slot)new SlotItemHandler(this.internal, 47, 61, 79){
            private final int slot = 47;
            private int x;
            private int y;
            {
                this.slot = 47;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(48, this.addSlot((Slot)new SlotItemHandler(this.internal, 48, 79, 79){
            private final int slot = 48;
            private int x;
            private int y;
            {
                this.slot = 48;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(49, this.addSlot((Slot)new SlotItemHandler(this.internal, 49, 97, 79){
            private final int slot = 49;
            private int x;
            private int y;
            {
                this.slot = 49;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(50, this.addSlot((Slot)new SlotItemHandler(this.internal, 50, 115, 79){
            private final int slot = 50;
            private int x;
            private int y;
            {
                this.slot = 50;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(51, this.addSlot((Slot)new SlotItemHandler(this.internal, 51, 133, 79){
            private final int slot = 51;
            private int x;
            private int y;
            {
                this.slot = 51;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(52, this.addSlot((Slot)new SlotItemHandler(this.internal, 52, 151, 79){
            private final int slot = 52;
            private int x;
            private int y;
            {
                this.slot = 52;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(53, this.addSlot((Slot)new SlotItemHandler(this.internal, 53, 169, 79){
            private final int slot = 53;
            private int x;
            private int y;
            {
                this.slot = 53;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(54, this.addSlot((Slot)new SlotItemHandler(this.internal, 54, 187, 79){
            private final int slot = 54;
            private int x;
            private int y;
            {
                this.slot = 54;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(55, this.addSlot((Slot)new SlotItemHandler(this.internal, 55, 7, 97){
            private final int slot = 55;
            private int x;
            private int y;
            {
                this.slot = 55;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(56, this.addSlot((Slot)new SlotItemHandler(this.internal, 56, 25, 97){
            private final int slot = 56;
            private int x;
            private int y;
            {
                this.slot = 56;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(57, this.addSlot((Slot)new SlotItemHandler(this.internal, 57, 43, 97){
            private final int slot = 57;
            private int x;
            private int y;
            {
                this.slot = 57;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(58, this.addSlot((Slot)new SlotItemHandler(this.internal, 58, 61, 97){
            private final int slot = 58;
            private int x;
            private int y;
            {
                this.slot = 58;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(59, this.addSlot((Slot)new SlotItemHandler(this.internal, 59, 79, 97){
            private final int slot = 59;
            private int x;
            private int y;
            {
                this.slot = 59;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(60, this.addSlot((Slot)new SlotItemHandler(this.internal, 60, 97, 97){
            private final int slot = 60;
            private int x;
            private int y;
            {
                this.slot = 60;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(61, this.addSlot((Slot)new SlotItemHandler(this.internal, 61, 115, 97){
            private final int slot = 61;
            private int x;
            private int y;
            {
                this.slot = 61;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(62, this.addSlot((Slot)new SlotItemHandler(this.internal, 62, 133, 97){
            private final int slot = 62;
            private int x;
            private int y;
            {
                this.slot = 62;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(63, this.addSlot((Slot)new SlotItemHandler(this.internal, 63, 151, 97){
            private final int slot = 63;
            private int x;
            private int y;
            {
                this.slot = 63;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(64, this.addSlot((Slot)new SlotItemHandler(this.internal, 64, 169, 97){
            private final int slot = 64;
            private int x;
            private int y;
            {
                this.slot = 64;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(65, this.addSlot((Slot)new SlotItemHandler(this.internal, 65, 187, 97){
            private final int slot = 65;
            private int x;
            private int y;
            {
                this.slot = 65;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(66, this.addSlot((Slot)new SlotItemHandler(this.internal, 66, 7, 115){
            private final int slot = 66;
            private int x;
            private int y;
            {
                this.slot = 66;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(67, this.addSlot((Slot)new SlotItemHandler(this.internal, 67, 25, 115){
            private final int slot = 67;
            private int x;
            private int y;
            {
                this.slot = 67;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(68, this.addSlot((Slot)new SlotItemHandler(this.internal, 68, 43, 115){
            private final int slot = 68;
            private int x;
            private int y;
            {
                this.slot = 68;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(69, this.addSlot((Slot)new SlotItemHandler(this.internal, 69, 61, 115){
            private final int slot = 69;
            private int x;
            private int y;
            {
                this.slot = 69;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(70, this.addSlot((Slot)new SlotItemHandler(this.internal, 70, 79, 115){
            private final int slot = 70;
            private int x;
            private int y;
            {
                this.slot = 70;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(71, this.addSlot((Slot)new SlotItemHandler(this.internal, 71, 97, 115){
            private final int slot = 71;
            private int x;
            private int y;
            {
                this.slot = 71;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(72, this.addSlot((Slot)new SlotItemHandler(this.internal, 72, 115, 115){
            private final int slot = 72;
            private int x;
            private int y;
            {
                this.slot = 72;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(73, this.addSlot((Slot)new SlotItemHandler(this.internal, 73, 133, 115){
            private final int slot = 73;
            private int x;
            private int y;
            {
                this.slot = 73;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(74, this.addSlot((Slot)new SlotItemHandler(this.internal, 74, 151, 115){
            private final int slot = 74;
            private int x;
            private int y;
            {
                this.slot = 74;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(75, this.addSlot((Slot)new SlotItemHandler(this.internal, 75, 169, 115){
            private final int slot = 75;
            private int x;
            private int y;
            {
                this.slot = 75;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(76, this.addSlot((Slot)new SlotItemHandler(this.internal, 76, 187, 115){
            private final int slot = 76;
            private int x;
            private int y;
            {
                this.slot = 76;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(77, this.addSlot((Slot)new SlotItemHandler(this.internal, 77, 7, 133){
            private final int slot = 77;
            private int x;
            private int y;
            {
                this.slot = 77;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(78, this.addSlot((Slot)new SlotItemHandler(this.internal, 78, 25, 133){
            private final int slot = 78;
            private int x;
            private int y;
            {
                this.slot = 78;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(79, this.addSlot((Slot)new SlotItemHandler(this.internal, 79, 43, 133){
            private final int slot = 79;
            private int x;
            private int y;
            {
                this.slot = 79;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(80, this.addSlot((Slot)new SlotItemHandler(this.internal, 80, 61, 133){
            private final int slot = 80;
            private int x;
            private int y;
            {
                this.slot = 80;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(81, this.addSlot((Slot)new SlotItemHandler(this.internal, 81, 79, 133){
            private final int slot = 81;
            private int x;
            private int y;
            {
                this.slot = 81;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(82, this.addSlot((Slot)new SlotItemHandler(this.internal, 82, 97, 133){
            private final int slot = 82;
            private int x;
            private int y;
            {
                this.slot = 82;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(83, this.addSlot((Slot)new SlotItemHandler(this.internal, 83, 115, 133){
            private final int slot = 83;
            private int x;
            private int y;
            {
                this.slot = 83;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(84, this.addSlot((Slot)new SlotItemHandler(this.internal, 84, 133, 133){
            private final int slot = 84;
            private int x;
            private int y;
            {
                this.slot = 84;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(85, this.addSlot((Slot)new SlotItemHandler(this.internal, 85, 151, 133){
            private final int slot = 85;
            private int x;
            private int y;
            {
                this.slot = 85;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(86, this.addSlot((Slot)new SlotItemHandler(this.internal, 86, 169, 133){
            private final int slot = 86;
            private int x;
            private int y;
            {
                this.slot = 86;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        this.customSlots.put(87, this.addSlot((Slot)new SlotItemHandler(this.internal, 87, 187, 133){
            private final int slot = 87;
            private int x;
            private int y;
            {
                this.slot = 87;
                this.x = GuiNetheriteMenu.this.x;
                this.y = GuiNetheriteMenu.this.y;
            }
        }));
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 26 + sj * 18, 155 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 26 + si * 18, 213));
        }
    }

    public boolean stillValid(Player player) {
        if (this.bound) {
            if (this.boundItemMatcher != null) {
                return this.boundItemMatcher.get();
            }
            if (this.boundBlockEntity != null) {
                return AbstractContainerMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)this.boundBlockEntity.getBlockState().getBlock());
            }
            if (this.boundEntity != null) {
                return this.boundEntity.isAlive();
            }
        }
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 88) {
                if (!this.moveItemStackTo(itemstack1, 88, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 88, false)) {
                if (index < 115 ? !this.moveItemStackTo(itemstack1, 115, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 88, 115, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        block4: {
            super.removed(playerIn);
            if (this.bound || !(playerIn instanceof ServerPlayer)) break block4;
            ServerPlayer serverPlayer = (ServerPlayer)playerIn;
            if (!serverPlayer.isAlive() || serverPlayer.hasDisconnected()) {
                for (int j = 0; j < this.internal.getSlots(); ++j) {
                    if (j == 0 || j == 1 || j == 2 || j == 3 || j == 4 || j == 5 || j == 6 || j == 7 || j == 8 || j == 9 || j == 10 || j == 11 || j == 12 || j == 13 || j == 14 || j == 15 || j == 16 || j == 17 || j == 18 || j == 19 || j == 20 || j == 21 || j == 22 || j == 23 || j == 24 || j == 25 || j == 26 || j == 27 || j == 28 || j == 29 || j == 30 || j == 31 || j == 32 || j == 33 || j == 34 || j == 35 || j == 36 || j == 37 || j == 38 || j == 39 || j == 40 || j == 41 || j == 42 || j == 43 || j == 44 || j == 45 || j == 46 || j == 47 || j == 48 || j == 49 || j == 50 || j == 51 || j == 52 || j == 53 || j == 54 || j == 55 || j == 56 || j == 57 || j == 58 || j == 59 || j == 60 || j == 61 || j == 62 || j == 63 || j == 64 || j == 65 || j == 66 || j == 67 || j == 68 || j == 69 || j == 70 || j == 71 || j == 72 || j == 73 || j == 74 || j == 75 || j == 76 || j == 77 || j == 78 || j == 79 || j == 80 || j == 81 || j == 82 || j == 83 || j == 84 || j == 85 || j == 86 || j == 87) continue;
                    playerIn.drop(this.internal.getStackInSlot(j), false);
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(j, ItemStack.EMPTY);
                }
            } else {
                for (int i = 0; i < this.internal.getSlots(); ++i) {
                    if (i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11 || i == 12 || i == 13 || i == 14 || i == 15 || i == 16 || i == 17 || i == 18 || i == 19 || i == 20 || i == 21 || i == 22 || i == 23 || i == 24 || i == 25 || i == 26 || i == 27 || i == 28 || i == 29 || i == 30 || i == 31 || i == 32 || i == 33 || i == 34 || i == 35 || i == 36 || i == 37 || i == 38 || i == 39 || i == 40 || i == 41 || i == 42 || i == 43 || i == 44 || i == 45 || i == 46 || i == 47 || i == 48 || i == 49 || i == 50 || i == 51 || i == 52 || i == 53 || i == 54 || i == 55 || i == 56 || i == 57 || i == 58 || i == 59 || i == 60 || i == 61 || i == 62 || i == 63 || i == 64 || i == 65 || i == 66 || i == 67 || i == 68 || i == 69 || i == 70 || i == 71 || i == 72 || i == 73 || i == 74 || i == 75 || i == 76 || i == 77 || i == 78 || i == 79 || i == 80 || i == 81 || i == 82 || i == 83 || i == 84 || i == 85 || i == 86 || i == 87) continue;
                    playerIn.getInventory().placeItemBackInInventory(this.internal.getStackInSlot(i));
                    IItemHandler iItemHandler = this.internal;
                    if (!(iItemHandler instanceof IItemHandlerModifiable)) continue;
                    IItemHandlerModifiable ihm = (IItemHandlerModifiable)iItemHandler;
                    ihm.setStackInSlot(i, ItemStack.EMPTY);
                }
            }
        }
    }

    @Override
    public Map<Integer, Slot> get() {
        return this.customSlots;
    }
}

