/*
 * Decompiled with CFR 0.152.
 */
package net.arthurorsi.mineralbackpacks.item.inventory;

import javax.annotation.Nonnull;
import net.arthurorsi.mineralbackpacks.init.MineralBackpacksModItems;
import net.arthurorsi.mineralbackpacks.world.inventory.GuiGoldMenu;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.items.ComponentItemHandler;

@EventBusSubscriber
public class BackpackGoldInventoryCapability
extends ComponentItemHandler {
    @SubscribeEvent
    public static void onItemDropped(ItemTossEvent event) {
        if (event.getEntity().getItem().getItem() == MineralBackpacksModItems.BACKPACK_GOLD.get()) {
            Player player = event.getPlayer();
            if (player.containerMenu instanceof GuiGoldMenu) {
                player.closeContainer();
            }
        }
    }

    public BackpackGoldInventoryCapability(MutableDataComponentHolder parent) {
        super(parent, DataComponents.CONTAINER, 36);
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return stack.getItem() != MineralBackpacksModItems.BACKPACK_GOLD.get();
    }

    public ItemStack getStackInSlot(int slot) {
        return super.getStackInSlot(slot).copy();
    }
}

