/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.MidnightReacharound;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsHud;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.mixin.KeyBindingIDAccessor;
import eu.midnightdust.midnightcontrols.client.ring.ButtonBindingRingAction;
import eu.midnightdust.midnightcontrols.client.ring.MidnightRing;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.util.RainbowColor;
import eu.midnightdust.midnightcontrols.client.util.platform.NetworkUtil;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.MouseClickInterceptor;
import eu.midnightdust.midnightcontrols.packet.ControlsModePayload;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;

public class MidnightControlsClient
extends MidnightControls {
    public static boolean lateInitDone = false;
    public static final class_304.class_11900 MIDNIGHTCONTROLS_CATEGORY = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)"midnightcontrols", (String)"keybinds"));
    public static final class_304 BINDING_LOOK_UP = InputManager.makeKeyBinding(MidnightControlsClient.id("look_up"), class_3675.class_307.field_1668, 328, MIDNIGHTCONTROLS_CATEGORY);
    public static final class_304 BINDING_LOOK_RIGHT = InputManager.makeKeyBinding(MidnightControlsClient.id("look_right"), class_3675.class_307.field_1668, 326, MIDNIGHTCONTROLS_CATEGORY);
    public static final class_304 BINDING_LOOK_DOWN = InputManager.makeKeyBinding(MidnightControlsClient.id("look_down"), class_3675.class_307.field_1668, 322, MIDNIGHTCONTROLS_CATEGORY);
    public static final class_304 BINDING_LOOK_LEFT = InputManager.makeKeyBinding(MidnightControlsClient.id("look_left"), class_3675.class_307.field_1668, 324, MIDNIGHTCONTROLS_CATEGORY);
    public static final class_304 BINDING_RING = InputManager.makeKeyBinding(MidnightControlsClient.id("ring"), class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), MIDNIGHTCONTROLS_CATEGORY);
    public static final class_2960 CONTROLLER_BUTTONS = MidnightControlsClient.id("textures/gui/controller_buttons.png");
    public static final class_2960 CONTROLLER_EXPANDED = MidnightControlsClient.id("textures/gui/controller_expanded.png");
    public static final class_2960 CONTROLLER_AXIS = MidnightControlsClient.id("textures/gui/controller_axis.png");
    public static final File MAPPINGS_FILE = new File("config/gamecontrollercustommappings.txt");
    public static class_310 client = class_310.method_1551();
    public static final MidnightInput input = new MidnightInput();
    public static final MidnightRing ring = new MidnightRing();
    public static final MidnightReacharound reacharound = new MidnightReacharound();
    public static final MouseClickInterceptor clickInterceptor = new MouseClickInterceptor();
    public static boolean isWayland;
    private static MidnightControlsHud hud;
    private static ControlsMode previousControlsMode;
    private static final MidnightControlsClient INSTANCE;

    public static void initClient() {
        client = class_310.method_1551();
        ring.registerAction("buttonbinding", ButtonBindingRingAction.FACTORY);
        int delay = 0;
        int period = 1;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (lateInitDone && client.method_22108() && MidnightControlsConfig.controlsMode != ControlsMode.DEFAULT && (client.method_1569() || MidnightControlsConfig.unfocusedInput)) {
                        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER) {
                            input.tickCameraStick();
                        }
                        input.updateCamera();
                    }
                }
                catch (Error | Exception e) {
                    MidnightControls.logger.error("Exception encountered in camera loop: ", e);
                }
            }
        }, delay, (long)period);
        isWayland = GLFW.glfwGetVersionString().contains("Wayland");
    }

    public static void onMcInit(@NotNull class_310 client) {
        ButtonBinding.init(client.field_1690);
        MidnightControlsConfig.load();
        if (MidnightControlsConfig.configVersion < 2) {
            MidnightControlsConfig.mouseScreens.remove("me.jellysquid.mods.sodium.client.gui");
            MidnightControlsConfig.mouseScreens.remove("net.coderbot.iris.gui");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.class_5375");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.client.gui.screen.pack.PackScreen");
            MidnightControlsConfig.configVersion = 2;
            MidnightControlsConfig.write((String)"midnightcontrols");
        }
        MidnightControlsHud.isVisible = MidnightControlsConfig.hudEnable;
        Controller.updateMappings();
        try {
            GLFW.glfwSetJoystickCallback((jid, event) -> {
                if (event == 262145) {
                    Controller controller = Controller.byId(jid);
                    client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.connected", (Object[])new Object[]{jid}), (class_2561)class_2561.method_43470((String)controller.getName())));
                } else if (event == 262146) {
                    client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.disconnected", (Object[])new Object[]{jid}), null));
                }
                MidnightControlsClient.switchControlsMode();
            });
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        MidnightControlsCompat.init();
    }

    public static void initKeybindings() {
        if (lateInitDone) {
            return;
        }
        if (KeyBindingIDAccessor.getKEYS_BY_ID() == null || KeyBindingIDAccessor.getKEYS_BY_ID().isEmpty()) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"voxelmap") && !KeyBindingIDAccessor.getKEYS_BY_ID().containsKey("key.minimap.toggleingamewaypoints")) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"wynntils") && KeyBindingIDAccessor.getKEYS_BY_ID().entrySet().stream().noneMatch(b -> Objects.equals(((class_304)b.getValue()).method_1423(), "Wynntils"))) {
            return;
        }
        for (int i = 0; i < KeyBindingIDAccessor.getKEYS_BY_ID().size(); ++i) {
            class_304 keyBinding = (class_304)((Map.Entry)KeyBindingIDAccessor.getKEYS_BY_ID().entrySet().stream().toList().get(i)).getValue();
            if (!MidnightControlsConfig.excludedKeybindings.stream().noneMatch(excluded -> keyBinding.method_1431().startsWith((String)excluded)) || keyBinding.method_1431().contains("midnightcontrols")) continue;
            AtomicReference<ButtonCategory> category = new AtomicReference<ButtonCategory>();
            InputManager.streamCategories().forEach(buttonCategory -> {
                if (buttonCategory.getIdentifier().equals((Object)keyBinding.method_1423().comp_4879())) {
                    category.set((ButtonCategory)buttonCategory);
                }
            });
            if (category.get() == null) {
                category.set(new ButtonCategory(keyBinding.method_1423().comp_4879()));
                InputManager.registerCategory((ButtonCategory)category.get());
            }
            ButtonBinding buttonBinding = new ButtonBinding.Builder(keyBinding.method_1431()).category((ButtonCategory)category.get()).linkKeybind(keyBinding).register();
            if (!MidnightControlsConfig.debug) continue;
            MidnightControls.log(keyBinding.method_1431());
            MidnightControls.log(String.valueOf(buttonBinding));
        }
        InputManager.loadButtonBindings();
        lateInitDone = true;
    }

    public static void onTick(@NotNull class_310 client) {
        MidnightControlsClient.initKeybindings();
        input.tick();
        reacharound.tick();
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && (client.method_1569() || MidnightControlsConfig.unfocusedInput)) {
            input.tickController();
        }
        if (BINDING_RING.method_1436()) {
            ring.loadFromUnbound();
            client.method_1507((class_437)new RingScreen());
        }
        if (client.field_1687 != null && MidnightControlsConfig.enableHints && !MidnightControlsConfig.autoSwitchMode && MidnightControlsConfig.controlsMode == ControlsMode.DEFAULT && MidnightControlsConfig.getController().isGamepad()) {
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"midnightcontrols.controller.tutorial.title"), (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.tutorial.description", (Object[])new Object[]{class_2561.method_43471((String)"options.title"), class_2561.method_43471((String)"controls.title"), class_2561.method_43471((String)"midnightcontrols.menu.title.controller")})));
            MidnightControlsConfig.enableHints = false;
            MidnightControlsConfig.save();
        }
        RainbowColor.tick();
        TouchInput.tick();
    }

    public static void onScreenOpen(class_437 screen) {
        client = class_310.method_1551();
        if (screen == null && MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN) {
            screen = new TouchscreenOverlay();
            screen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            MidnightControlsClient.client.field_1743 = false;
            MidnightControlsClient.client.field_1755 = screen;
        } else if (screen != null) {
            input.onScreenOpen(client.method_22683().method_4480(), client.method_22683().method_4507());
        }
    }

    public static void onLeave() {
        MidnightControlsFeature.resetAllAllowed();
    }

    public static void switchControlsMode() {
        if (MidnightControlsConfig.autoSwitchMode) {
            if (MidnightControlsConfig.getController().isGamepad()) {
                previousControlsMode = MidnightControlsConfig.controlsMode;
                MidnightControlsConfig.controlsMode = ControlsMode.CONTROLLER;
            } else {
                if (previousControlsMode == null) {
                    previousControlsMode = ControlsMode.DEFAULT;
                }
                MidnightControlsConfig.controlsMode = previousControlsMode;
            }
            NetworkUtil.sendPayloadC2S(new ControlsModePayload(MidnightControlsConfig.controlsMode.getName()));
        }
    }

    public static void setHudEnabled(boolean enabled) {
        MidnightControlsConfig.hudEnable = enabled;
        MidnightControlsHud.isVisible = enabled;
    }

    @Deprecated
    public static MidnightControlsClient get() {
        return INSTANCE;
    }

    static {
        INSTANCE = new MidnightControlsClient();
    }
}

