/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.ImmutableSet;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.AbstractSprucePressableButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceElement;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.EmotecraftCompat;
import eu.midnightdust.midnightcontrols.client.compat.LibGuiCompat;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.compat.YACLCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.enums.CameraMode;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.config.ControlsInput;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.KeyboardAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import eu.midnightdust.midnightcontrols.client.ring.RingPage;
import eu.midnightdust.midnightcontrols.client.touch.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.InventoryUtil;
import eu.midnightdust.midnightcontrols.client.util.MathUtil;
import eu.midnightdust.midnightcontrols.client.util.storage.AxisStorage;
import eu.midnightdust.midnightcontrols.client.util.storage.ButtonStorage;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_11910;
import net.minecraft.class_1297;
import net.minecraft.class_1690;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_4264;
import net.minecraft.class_4267;
import net.minecraft.class_437;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_528;
import net.minecraft.class_6599;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import net.minecraft.class_8028;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFWGamepadState;

public class MidnightInput {
    public static final Map<Integer, Integer> BUTTON_COOLDOWNS = new HashMap<Integer, Integer>();
    public static final class_11908 ENTER_KEY_INPUT = new class_11908(257, 0, 0);
    public int actionGuiCooldown = 0;
    public int joystickCooldown = 0;
    public boolean ignoreNextARelease = false;
    public boolean ignoreNextXRelease = false;
    private double targetYaw = 0.0;
    private double targetPitch = 0.0;
    private float prevXAxis = 0.0f;
    private float prevYAxis = 0.0f;
    public float mouseSpeedX = 0.0f;
    public float mouseSpeedY = 0.0f;
    public int inventoryInteractionCooldown = 0;
    public int screenCloseCooldown = 0;
    private ControlsInput controlsInput = null;
    final MathUtil.PolarUtil polarUtil = new MathUtil.PolarUtil();
    private double prevX = 0.0;
    private double prevY = 0.0;
    private double xValue;
    private AxisStorage.Polarity xPolarity;

    public void tick() {
        this.targetYaw = 0.0;
        this.targetPitch = 0.0;
        if (MidnightControlsClient.BINDING_LOOK_UP.method_1434()) {
            this.handleFlatLook(AxisStorage.of(3, -0.8f, 0.0));
        } else if (MidnightControlsClient.BINDING_LOOK_DOWN.method_1434()) {
            this.handleFlatLook(AxisStorage.of(3, 0.8f, 0.0));
        }
        if (MidnightControlsClient.BINDING_LOOK_LEFT.method_1434()) {
            this.handleFlatLook(AxisStorage.of(2, -0.8f, 0.0));
        } else if (MidnightControlsClient.BINDING_LOOK_RIGHT.method_1434()) {
            this.handleFlatLook(AxisStorage.of(2, 0.8f, 0.0));
        }
        InputManager.INPUT_MANAGER.tick();
    }

    public void tickController() {
        boolean allowInput;
        BUTTON_COOLDOWNS.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> BUTTON_COOLDOWNS.put((Integer)entry.getKey(), (Integer)entry.getValue() - 1));
        if (this.actionGuiCooldown > 0) {
            --this.actionGuiCooldown;
        }
        if (this.screenCloseCooldown > 0) {
            --this.screenCloseCooldown;
        }
        if (this.joystickCooldown > 0) {
            --this.joystickCooldown;
        }
        InputManager.updateStates();
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            GLFWGamepadState state = controller.getState();
            this.fetchButtonInput(state, false);
            this.fetchTriggerInput(state, false);
            this.fetchJoystickInput(state, false, false);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> {
            GLFWGamepadState state = joycon.getState();
            this.fetchButtonInput(state, true);
            this.fetchTriggerInput(state, true);
            this.fetchJoystickInput(state, true, false);
        });
        boolean bl = allowInput = this.controlsInput == null || this.controlsInput.getFocusedBinding() == null;
        if (allowInput) {
            InputManager.updateBindings();
        }
        if (this.controlsInput != null) {
            InputManager.STATES.forEach((num, button) -> {
                if (button.isPressed()) {
                    System.out.println(num);
                }
            });
        }
        if (this.controlsInput != null && InputManager.STATES.int2ObjectEntrySet().parallelStream().map(Map.Entry::getValue).allMatch(ButtonState::isUnpressed) && this.controlsInput.getFocusedBinding() != null && !this.controlsInput.isWaiting()) {
            int[] buttons = new int[this.controlsInput.getCurrentButtons().size()];
            for (int i = 0; i < this.controlsInput.getCurrentButtons().size(); ++i) {
                buttons[i] = this.controlsInput.getCurrentButtons().get(i);
            }
            this.controlsInput.finishBindingEdit(buttons);
            this.controlsInput = null;
        }
        if (this.inventoryInteractionCooldown > 0) {
            --this.inventoryInteractionCooldown;
        }
    }

    public void tickCameraStick() {
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            this.fetchJoystickInput(controller.getState(), false, true);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> this.fetchJoystickInput(joycon.getState(), true, true));
    }

    public void onPreRenderScreen(@NotNull class_437 screen) {
        if (!MidnightInput.isScreenInteractive(screen)) {
            InputManager.INPUT_MANAGER.updateMousePosition(MidnightControlsClient.client);
        }
    }

    public void updateCamera() {
        if (MidnightControlsClient.client.field_1755 != null && !(MidnightControlsClient.client.field_1755 instanceof TouchscreenOverlay)) {
            return;
        }
        class_746 player = MidnightControlsClient.client.field_1724;
        if (player == null) {
            return;
        }
        if (this.targetYaw != 0.0 || this.targetPitch != 0.0) {
            float rotationYaw = (float)((double)MidnightControlsClient.client.field_1724.field_5982 + this.targetYaw * 0.175);
            float rotationPitch = (float)((double)MidnightControlsClient.client.field_1724.field_6004 + this.targetPitch * 0.175);
            MidnightControlsClient.client.field_1724.field_5982 = rotationYaw;
            MidnightControlsClient.client.field_1724.field_6004 = class_3532.method_15363((float)rotationPitch, (float)-90.0f, (float)90.0f);
            MidnightControlsClient.client.field_1724.method_36456(rotationYaw);
            MidnightControlsClient.client.field_1724.method_36457(class_3532.method_15363((float)rotationPitch, (float)-90.0f, (float)90.0f));
            if (MidnightControlsClient.client.field_1724.method_3144() && MidnightControlsClient.client.field_1724.method_5854() != null) {
                MidnightControlsClient.client.field_1724.method_5854().method_5644((class_1297)MidnightControlsClient.client.field_1724);
            }
            MidnightControlsClient.client.method_1577().method_4908(this.targetPitch, this.targetYaw);
        }
    }

    public void onScreenOpen(int windowWidth, int windowHeight) {
        if (MidnightControlsClient.client.field_1755 == null) {
            this.mouseSpeedY = 0.0f;
            this.mouseSpeedX = 0.0f;
            InputManager.INPUT_MANAGER.resetMousePosition(windowWidth, windowHeight);
        } else if (MidnightInput.isScreenInteractive(MidnightControlsClient.client.field_1755) && MidnightControlsConfig.virtualMouse) {
            ((MouseAccessor)MidnightControlsClient.client.field_1729).midnightcontrols$onCursorPos(MidnightControlsClient.client.method_22683().method_4490(), 0.0, 0.0);
            InputManager.INPUT_MANAGER.resetMouseTarget(MidnightControlsClient.client);
        }
        this.inventoryInteractionCooldown = 5;
    }

    public void beginControlsInput(ControlsInput widget) {
        this.controlsInput = widget;
        if (widget != null) {
            this.controlsInput.getCurrentButtons().clear();
            this.controlsInput.setWaiting(true);
        }
    }

    private void fetchButtonInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        ByteBuffer buffer = gamepadState.buttons();
        for (int i = 0; i < buffer.limit(); ++i) {
            int btn = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            boolean pressed = buffer.get() == 1;
            ButtonState state = ButtonState.NONE;
            ButtonState previousState = (ButtonState)((Object)InputManager.STATES.getOrDefault(btn, (Object)ButtonState.NONE));
            if (pressed != previousState.isPressed()) {
                state = pressed ? ButtonState.PRESS : ButtonState.RELEASE;
                this.handleButton(ButtonStorage.of(btn, state));
                if (pressed) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                }
            } else if (pressed) {
                state = ButtonState.REPEAT;
                if (BUTTON_COOLDOWNS.getOrDefault(btn, 0) == 0) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                    this.handleButton(ButtonStorage.of(btn, state));
                }
            }
            InputManager.STATES.put(btn, (Object)state);
        }
    }

    private void fetchJoystickInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon, boolean cameraTick) {
        boolean isRadialMenu;
        FloatBuffer buffer = gamepadState.axes();
        this.polarUtil.calculate(buffer.get(0), buffer.get(1), 1.0f, MidnightControlsConfig.leftDeadZone);
        float leftX = this.polarUtil.polarX;
        float leftY = this.polarUtil.polarY;
        this.polarUtil.calculate(buffer.get(2), buffer.get(3), 1.0f, MidnightControlsConfig.rightDeadZone);
        float rightX = this.polarUtil.polarX;
        float rightY = this.polarUtil.polarY;
        boolean bl = isRadialMenu = MidnightControlsClient.client.field_1755 instanceof RingScreen || PlatformFunctions.isModLoaded((String)"emotecraft") && EmotecraftCompat.isEmotecraftScreen(MidnightControlsClient.client.field_1755);
        if (!isRadialMenu) {
            for (int i = cameraTick ? 2 : 0; i < (cameraTick ? 4 : 2); ++i) {
                int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
                float value = buffer.get(i);
                switch (i) {
                    case 0: {
                        if (!MidnightControlsConfig.analogMovement) break;
                        value = leftX;
                        break;
                    }
                    case 1: {
                        if (!MidnightControlsConfig.analogMovement) break;
                        value = leftY;
                        break;
                    }
                    case 2: {
                        value = rightX;
                        break;
                    }
                    case 3: {
                        value = rightY;
                    }
                }
                if (i == 1) {
                    value *= -1.0f;
                }
                this.handleJoystickAxis(AxisStorage.of(axis, value));
            }
        } else {
            boolean leftStickActive = leftX != 0.0f || leftY != 0.0f;
            this.handleRadialMenu(leftStickActive ? leftX : rightX, leftStickActive ? leftY : rightY);
        }
    }

    private void fetchTriggerInput(@NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        FloatBuffer buffer = gamepadState.axes();
        for (int i = 4; i <= 5; ++i) {
            int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            float value = buffer.get(i);
            this.handleTriggerAxis(AxisStorage.of(axis, value, MidnightControlsConfig.triggerDeadZone));
        }
    }

    public void handleButton(ButtonStorage storage) {
        if (this.controlsInput != null && this.controlsInput.getFocusedBinding() != null) {
            if (storage.state == ButtonState.PRESS && !this.controlsInput.getCurrentButtons().contains(storage.button)) {
                this.controlsInput.getCurrentButtons().add(storage.button);
                int[] buttons = new int[this.controlsInput.getCurrentButtons().size()];
                for (int i = 0; i < this.controlsInput.getCurrentButtons().size(); ++i) {
                    buttons[i] = this.controlsInput.getCurrentButtons().get(i);
                }
                this.controlsInput.getFocusedBinding().setButton(buttons);
                this.controlsInput.update();
                this.controlsInput.setWaiting(false);
            }
            return;
        }
        if (MidnightControlsClient.client.field_1755 != null && storage.state.isPressed() && storage.button == 3 && MidnightControlsConfig.arrowScreens.contains(MidnightControlsClient.client.field_1755.getClass().getCanonicalName())) {
            this.pressKeyboardKey(MidnightControlsClient.client, 257);
            this.screenCloseCooldown = 5;
        } else if (storage.state.isPressed()) {
            if (MidnightControlsClient.client.field_1755 != null && storage.isDpad() && this.actionGuiCooldown == 0) {
                switch (storage.button) {
                    case 11: {
                        this.changeFocus(MidnightControlsClient.client.field_1755, class_8028.field_41826);
                        break;
                    }
                    case 13: {
                        this.changeFocus(MidnightControlsClient.client.field_1755, class_8028.field_41827);
                        break;
                    }
                    case 14: {
                        this.handleLeftRight(MidnightControlsClient.client.field_1755, false);
                        break;
                    }
                    case 12: {
                        this.handleLeftRight(MidnightControlsClient.client.field_1755, true);
                    }
                }
                if (MidnightControlsConfig.wasdScreens.contains(MidnightControlsClient.client.field_1755.getClass().getCanonicalName())) {
                    switch (storage.button) {
                        case 11: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 87);
                            break;
                        }
                        case 13: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 83);
                            break;
                        }
                        case 14: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 65);
                            break;
                        }
                        case 12: {
                            this.pressKeyboardKey(MidnightControlsClient.client, 68);
                        }
                    }
                }
                return;
            }
        } else if (storage.button == 0 && MidnightControlsClient.client.field_1755 != null && this.actionGuiCooldown == 0) {
            class_364 focused = MidnightControlsClient.client.field_1755.method_25399();
            if (focused != null && MidnightInput.isScreenInteractive(MidnightControlsClient.client.field_1755)) {
                if (this.handleAButton(MidnightControlsClient.client.field_1755, focused)) {
                    this.actionGuiCooldown = 5;
                    return;
                }
            } else if (PlatformFunctions.isModLoaded((String)"libgui")) {
                LibGuiCompat.handlePress(MidnightControlsClient.client.field_1755);
            }
        }
        if (storage.button == 0 && MidnightControlsClient.client.field_1755 != null && !MidnightInput.isScreenInteractive(MidnightControlsClient.client.field_1755) && this.actionGuiCooldown == 0) {
            class_465 handledScreen;
            class_437 class_4372 = MidnightControlsClient.client.field_1755;
            if (class_4372 instanceof class_465 && ((HandledScreenAccessor)(handledScreen = (class_465)class_4372)).midnightcontrols$getSlotAt(MidnightControlsClient.client.field_1729.method_1603() * (double)MidnightControlsClient.client.method_22683().method_4486() / (double)MidnightControlsClient.client.method_22683().method_4480(), MidnightControlsClient.client.field_1729.method_1604() * (double)MidnightControlsClient.client.method_22683().method_4502() / (double)MidnightControlsClient.client.method_22683().method_4507()) != null) {
                return;
            }
            if (!this.ignoreNextARelease && MidnightControlsClient.client.field_1755 != null) {
                MouseAccessor accessor = (MouseAccessor)MidnightControlsClient.client.field_1729;
                accessor.midnightcontrols$onCursorPos(MidnightControlsClient.client.method_22683().method_4490(), MidnightControlsClient.client.field_1729.method_1603(), MidnightControlsClient.client.field_1729.method_1604());
                switch (storage.state) {
                    case PRESS: {
                        accessor.midnightcontrols$onMouseButton(MidnightControlsClient.client.method_22683().method_4490(), new class_11910(0, 0), 1);
                        break;
                    }
                    case RELEASE: {
                        accessor.midnightcontrols$onMouseButton(MidnightControlsClient.client.method_22683().method_4490(), new class_11910(0, 0), 0);
                        MidnightControlsClient.client.field_1755.method_25398(false);
                        break;
                    }
                    case REPEAT: {
                        MidnightControlsClient.client.field_1755.method_25398(true);
                    }
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextARelease = false;
            }
        } else if (storage.button == 2 && MidnightControlsClient.client.field_1755 != null && !MidnightInput.isScreenInteractive(MidnightControlsClient.client.field_1755) && this.actionGuiCooldown == 0) {
            class_465 handledScreen;
            double mouseX = MidnightControlsClient.client.field_1729.method_1603() * (double)MidnightControlsClient.client.method_22683().method_4486() / (double)MidnightControlsClient.client.method_22683().method_4480();
            double mouseY = MidnightControlsClient.client.field_1729.method_1604() * (double)MidnightControlsClient.client.method_22683().method_4502() / (double)MidnightControlsClient.client.method_22683().method_4507();
            class_437 class_4373 = MidnightControlsClient.client.field_1755;
            if (class_4373 instanceof class_465 && ((HandledScreenAccessor)(handledScreen = (class_465)class_4373)).midnightcontrols$getSlotAt(mouseX, mouseY) != null) {
                return;
            }
            if (!this.ignoreNextXRelease && MidnightControlsClient.client.field_1755 != null) {
                if (storage.state == ButtonState.PRESS) {
                    MidnightControlsClient.client.field_1755.method_25402(new class_11909(mouseX, mouseY, new class_11910(1, 1)), false);
                } else if (storage.state == ButtonState.RELEASE) {
                    MidnightControlsClient.client.field_1755.method_25406(new class_11909(mouseX, mouseY, new class_11910(1, 0)));
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextXRelease = false;
            }
        }
    }

    private void handleTriggerAxis(AxisStorage storage) {
        storage.setupButtonStates();
    }

    private void handleJoystickAxis(AxisStorage storage) {
        storage.setupButtonStates();
        this.handleJoystickMovement(storage);
        if (this.handleScreenScrolling(MidnightControlsClient.client.field_1755, storage)) {
            return;
        }
        storage.absValue = (float)class_3532.method_15350((double)((double)storage.absValue / MidnightControlsConfig.getAxisMaxValue(storage.axis)), (double)0.0, (double)1.0);
        if (MidnightControlsClient.client.field_1755 == null) {
            this.handleLook(storage);
        } else {
            boolean allowMouseControl = true;
            if (this.actionGuiCooldown == 0 && MidnightControlsConfig.isMovementAxis(storage.axis) && MidnightInput.isScreenInteractive(MidnightControlsClient.client.field_1755)) {
                if (MidnightControlsConfig.isForwardButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.changeFocus(MidnightControlsClient.client.field_1755, class_8028.field_41826);
                } else if (MidnightControlsConfig.isBackButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.changeFocus(MidnightControlsClient.client.field_1755, class_8028.field_41827);
                } else if (MidnightControlsConfig.isLeftButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.handleLeftRight(MidnightControlsClient.client.field_1755, false);
                } else if (MidnightControlsConfig.isRightButton(storage.axis, false, storage.buttonState)) {
                    allowMouseControl = this.handleLeftRight(MidnightControlsClient.client.field_1755, true);
                }
            }
            float movementX = 0.0f;
            float movementY = 0.0f;
            if (MidnightControlsConfig.isBackButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementY = storage.absValue;
            } else if (MidnightControlsConfig.isForwardButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementY = -storage.absValue;
            } else if (MidnightControlsConfig.isLeftButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementX = -storage.absValue;
            } else if (MidnightControlsConfig.isRightButton(storage.axis, false, storage.value > 0.0f ? ButtonState.PRESS : ButtonState.RELEASE)) {
                movementX = storage.absValue;
            }
            if (MidnightControlsClient.client.field_1755 != null && allowMouseControl) {
                boolean moving;
                boolean bl = moving = movementY != 0.0f || movementX != 0.0f;
                if (moving) {
                    if ((double)Math.abs(this.prevXAxis) < storage.deadZone && (double)Math.abs(this.prevYAxis) < storage.deadZone) {
                        InputManager.INPUT_MANAGER.resetMouseTarget(MidnightControlsClient.client);
                    }
                    this.mouseSpeedX = movementX;
                    this.mouseSpeedY = movementY;
                } else {
                    this.mouseSpeedX = 0.0f;
                    this.mouseSpeedY = 0.0f;
                }
                if (Math.abs(this.mouseSpeedX) >= 0.05f || Math.abs(this.mouseSpeedY) >= 0.05f) {
                    InputManager.queueMoveMousePosition((double)this.mouseSpeedX * MidnightControlsConfig.mouseSpeed, (double)this.mouseSpeedY * MidnightControlsConfig.mouseSpeed);
                }
                InventoryUtil.moveMouseToClosestSlot(MidnightControlsClient.client.field_1755);
            }
            this.prevXAxis = movementX;
            this.prevYAxis = movementY;
        }
    }

    private void handleJoystickMovement(AxisStorage storage) {
        float axisValue = storage.absValue;
        if (!MidnightControlsConfig.analogMovement || MidnightControlsClient.client.field_1724 != null && MidnightControlsClient.client.field_1724.method_5854() instanceof class_1690) {
            axisValue = (float)((double)storage.absValue - storage.deadZone);
            axisValue /= (float)(1.0 - storage.deadZone);
            axisValue *= (float)storage.deadZone;
        }
        axisValue = (float)Math.min((double)axisValue / MidnightControlsConfig.getAxisMaxValue(storage.axis), 1.0);
        if (AxisStorage.isLeftAxis(storage.axis)) {
            MidnightControlsCompat.handleMovement(storage, axisValue);
        }
        InputManager.BUTTON_VALUES.put(storage.getButtonId(true), storage.polarity == AxisStorage.Polarity.PLUS ? axisValue : 0.0f);
        InputManager.BUTTON_VALUES.put(storage.getButtonId(false), storage.polarity == AxisStorage.Polarity.MINUS ? axisValue : 0.0f);
        storage.absValue = axisValue;
    }

    private boolean handleScreenScrolling(class_437 screen, AxisStorage storage) {
        if (screen == null) {
            return false;
        }
        int preferredAxis = 3;
        if (this.controlsInput != null && this.controlsInput.getFocusedBinding() != null) {
            if (storage.buttonState != ButtonState.NONE && !this.controlsInput.getCurrentButtons().contains(storage.getButtonId(storage.buttonState == ButtonState.PRESS))) {
                this.controlsInput.getCurrentButtons().add(storage.getButtonId(storage.buttonState == ButtonState.PRESS));
                int[] buttons = new int[this.controlsInput.getCurrentButtons().size()];
                for (int i = 0; i < this.controlsInput.getCurrentButtons().size(); ++i) {
                    buttons[i] = this.controlsInput.getCurrentButtons().get(i);
                }
                this.controlsInput.getFocusedBinding().setButton(buttons);
                this.controlsInput.update();
                this.controlsInput.setWaiting(false);
            }
            return true;
        }
        if ((double)storage.absValue >= storage.deadZone) {
            if (screen instanceof class_481) {
                class_481 creativeInventoryScreen = (class_481)screen;
                if (storage.axis == preferredAxis) {
                    CreativeInventoryScreenAccessor accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
                    if (accessor.midnightcontrols$hasScrollbar() && (double)storage.absValue >= storage.deadZone) {
                        creativeInventoryScreen.method_25401(0.0, 0.0, 0.0, (double)(-(storage.value * 0.0175f)));
                    }
                    return true;
                }
            } else if (screen instanceof class_457) {
                class_457 advancementsScreen = (class_457)screen;
                if (storage.axis == 2 || storage.axis == 3) {
                    AdvancementsScreenAccessor accessor = (AdvancementsScreenAccessor)advancementsScreen;
                    class_454 tab = accessor.getSelectedTab();
                    tab.method_2313(storage.axis == 2 ? (double)(-storage.value) * 1.0 : 0.0, storage.axis == 3 ? (double)(-storage.value) * 5.0 : 0.0);
                    return true;
                }
            } else if (screen != null) {
                if (storage.axis == preferredAxis && !this.handleListWidgetScrolling(screen.method_25396(), storage.value)) {
                    try {
                        screen.method_25401(0.0, 0.0, 0.0, (double)(-(storage.value * 0.0175f)));
                    }
                    catch (NullPointerException nullPointerException) {}
                } else if (MidnightInput.isScreenInteractive(screen)) {
                    if (this.joystickCooldown == 0) {
                        switch (storage.axis) {
                            case 1: {
                                this.changeFocus(screen, storage.value > 0.0f ? class_8028.field_41826 : class_8028.field_41827);
                                this.joystickCooldown = 4;
                                break;
                            }
                            case 0: {
                                this.handleLeftRight(screen, storage.value > 0.0f);
                                this.joystickCooldown = 4;
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void handleRadialMenu(float x, float y) {
        int index = -1;
        float border = 0.3f;
        if (x < -border) {
            index = 3;
            if (y < -border) {
                index = 0;
            } else if (y > border) {
                index = 5;
            }
        } else if (x > border) {
            index = 4;
            if (y < -border) {
                index = 2;
            } else if (y > border) {
                index = 7;
            }
        } else if (y < -border) {
            index = 1;
        } else if (y > border) {
            index = 6;
        }
        if (MidnightControlsClient.client.field_1755 instanceof RingScreen && index > -1) {
            RingPage.selected = index;
        }
        if (PlatformFunctions.isModLoaded((String)"emotecraft") && EmotecraftCompat.isEmotecraftScreen(MidnightControlsClient.client.field_1755)) {
            EmotecraftCompat.handleEmoteSelector(index);
        }
    }

    public boolean handleListWidgetScrolling(List<? extends class_364> children, float value) {
        return children.stream().filter(element -> element instanceof SpruceEntryListWidget).map(element -> (SpruceEntryListWidget)element).filter(SpruceWidget::isFocusedOrHovered).anyMatch(element -> {
            element.method_25401(0.0, 0.0, 0.0, (double)(-value));
            return true;
        }) || children.stream().filter(element -> element instanceof class_350).map(element -> (class_350)element).filter(element -> element.method_37018().method_37028()).anyMatch(element -> {
            element.method_25401(0.0, 0.0, 0.0, (double)(-value / 30.0f));
            return true;
        });
    }

    public boolean handleAButton(@NotNull class_437 screen, @NotNull class_364 focused) {
        if (focused instanceof class_4264) {
            class_4264 widget = (class_4264)focused;
            widget.method_25354(class_310.method_1551().method_1483());
            widget.method_25306((class_11907)ENTER_KEY_INPUT);
            return true;
        }
        if (focused instanceof AbstractSprucePressableButtonWidget) {
            AbstractSprucePressableButtonWidget widget = (AbstractSprucePressableButtonWidget)focused;
            widget.playDownSound();
            widget.onPress();
            return true;
        }
        if (focused instanceof SpruceLabelWidget) {
            SpruceLabelWidget labelWidget = (SpruceLabelWidget)focused;
            labelWidget.onPress();
            return true;
        }
        if (focused instanceof class_528) {
            class_528 list = (class_528)focused;
            list.method_20159().ifPresent(class_528.class_4272::method_20164);
            return true;
        }
        if (focused instanceof class_4267) {
            class_4267 list = (class_4267)focused;
            class_4267.class_504 entry = (class_4267.class_504)list.method_25334();
            if (entry instanceof class_4267.class_4269 || entry instanceof class_4267.class_4270) {
                entry.method_74043();
            }
        } else if (focused instanceof SpruceParentWidget) {
            SpruceWidget childFocused = ((SpruceParentWidget)focused).getFocused();
            if (childFocused != null) {
                return this.handleAButton(screen, (class_364)childFocused);
            }
        } else if (focused instanceof class_4069) {
            class_4069 widget = (class_4069)focused;
            class_364 childFocused = widget.method_25399();
            if (childFocused != null) {
                return this.handleAButton(screen, childFocused);
            }
        } else {
            if (PlatformFunctions.isModLoaded((String)"yet-another-config-lib") && YACLCompat.handleAButton(screen, focused)) {
                return true;
            }
            this.pressKeyboardKey(screen, 257);
        }
        return false;
    }

    private boolean handleLeftRight(@NotNull class_437 screen, boolean right) {
        if (screen instanceof SpruceScreen) {
            SpruceScreen spruceScreen = (SpruceScreen)screen;
            spruceScreen.onNavigation(new NavigationEvent(right ? class_8028.field_41829 : class_8028.field_41828, false, false));
            this.actionGuiCooldown = 5;
            return false;
        }
        if (PlatformFunctions.isModLoaded((String)"yet-another-config-lib") && YACLCompat.handleLeftRight(screen, right)) {
            this.actionGuiCooldown = 5;
            return false;
        }
        class_364 focused = screen.method_25399();
        if (focused != null && this.handleRightLeftElement(focused, right)) {
            return this.changeFocus(screen, right ? class_8028.field_41829 : class_8028.field_41828);
        }
        return true;
    }

    private boolean handleRightLeftElement(@NotNull class_364 element, boolean right) {
        class_364 class_3642 = element;
        Objects.requireNonNull(class_3642);
        class_364 class_3643 = class_3642;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SpruceElement.class, class_357.class, class_4069.class}, (Object)class_3643, n)) {
            case 0: {
                SpruceElement spruceElement = (SpruceElement)class_3643;
                if (spruceElement.requiresCursor()) {
                    return true;
                }
                return !spruceElement.onNavigation(new NavigationEvent(right ? class_8028.field_41829 : class_8028.field_41828, false, false));
            }
            case 1: {
                class_357 slider = (class_357)class_3643;
                if (!slider.field_22763) break;
                slider.method_25404(new class_11908(right ? 262 : 263, 0, 0));
                this.actionGuiCooldown = 2;
                return true;
            }
            case 2: {
                class_4069 entryList = (class_4069)class_3643;
                class_364 focused = entryList.method_25399();
                if (focused == null) {
                    return true;
                }
                return this.handleRightLeftElement(focused, right);
            }
        }
        return true;
    }

    public void handleLook(AxisStorage storage) {
        if (MidnightControlsClient.client.field_1724 == null || storage.axis != 3 && storage.axis != 2) {
            return;
        }
        if (MidnightControlsConfig.cameraMode == CameraMode.FLAT) {
            this.handleFlatLook(storage);
        } else {
            this.handleAdaptiveLook(storage);
        }
        MidnightControlsCompat.handleCamera(this.targetYaw, this.targetPitch);
    }

    private void handleFlatLook(AxisStorage storage) {
        if (storage.polarity != AxisStorage.Polarity.ZERO) {
            double rotation = Math.pow(storage.value, 2.0) * 0.11 * (double)storage.polarity.multiplier;
            if (storage.axis == 3) {
                this.targetPitch = rotation * MidnightControlsConfig.getRightYAxisSign() * MidnightControlsConfig.yAxisRotationSpeed / 2.0;
            } else {
                this.targetYaw = rotation * MidnightControlsConfig.getRightXAxisSign() * MidnightControlsConfig.rotationSpeed / 2.0;
            }
        }
    }

    private void handleAdaptiveLook(AxisStorage storage) {
        if (storage.axis == 2) {
            this.xValue = storage.value;
            this.xPolarity = storage.polarity;
        } else {
            double sign;
            double yStep = MidnightControlsConfig.yAxisRotationSpeed / 50.0 * (double)0.6f + (double)0.2f;
            double xStep = MidnightControlsConfig.rotationSpeed / 50.0 * (double)0.6f + (double)0.2f;
            float yValue = storage.value;
            AxisStorage.Polarity yPolarity = storage.polarity;
            double cursorDeltaX = 2.0 * this.xValue - this.prevX;
            double cursorDeltaY = (double)(2.0f * yValue) - this.prevY;
            boolean slowdown = MidnightControlsClient.client.field_1690.method_31044().method_31034() && Objects.requireNonNull(MidnightControlsClient.client.field_1724).method_31550();
            double x = cursorDeltaX * xStep * (slowdown ? xStep : 1.0);
            double y = cursorDeltaY * yStep * (slowdown ? yStep : 1.0);
            double powXValue = Math.pow(x, 2.0);
            double powYValue = Math.pow(y, 2.0);
            if (this.xPolarity != AxisStorage.Polarity.ZERO) {
                sign = MidnightControlsConfig.getRightXAxisSign() * MidnightControlsConfig.rotationSpeed;
                this.targetYaw = sign * powXValue * 0.11 * (double)this.xPolarity.multiplier;
            }
            if (yPolarity != AxisStorage.Polarity.ZERO) {
                sign = MidnightControlsConfig.getRightYAxisSign() * MidnightControlsConfig.yAxisRotationSpeed;
                this.targetPitch = sign * powYValue * 0.11 * (double)yPolarity.multiplier;
            }
            this.prevY = yValue;
            this.prevX = this.xValue;
        }
    }

    public void handleTouchscreenLook(AxisStorage storage) {
        if (storage.polarity != AxisStorage.Polarity.ZERO) {
            double rotation = (double)storage.value * 0.11 * MidnightControlsConfig.touchSpeed / 5.0;
            if (storage.axis == 3) {
                this.targetPitch = rotation;
            } else {
                this.targetYaw = rotation;
            }
        }
    }

    private boolean changeFocus(@NotNull class_437 screen, class_8028 direction) {
        if (!MidnightInput.isScreenInteractive(screen) && !screen.getClass().getCanonicalName().contains("me.jellysquid.mods.sodium.client.gui")) {
            return false;
        }
        try {
            if (screen instanceof SpruceScreen) {
                SpruceScreen spruceScreen = (SpruceScreen)screen;
                if (spruceScreen.onNavigation(new NavigationEvent(direction, false, false))) {
                    this.actionGuiCooldown = 5;
                }
                return true;
            }
            switch (direction) {
                case field_41826: {
                    this.pressKeyboardKey(screen, 265);
                    break;
                }
                case field_41827: {
                    this.pressKeyboardKey(screen, 264);
                    break;
                }
                case field_41828: {
                    this.pressKeyboardKey(screen, 263);
                    break;
                }
                case field_41829: {
                    this.pressKeyboardKey(screen, 262);
                }
            }
            this.actionGuiCooldown = 5;
            return true;
        }
        catch (Exception exception) {
            MidnightControls.warn("Unknown exception encountered while trying to change focus: " + String.valueOf(exception));
            return false;
        }
    }

    public boolean tryGoBack(@NotNull class_437 screen) {
        ImmutableSet set = ImmutableSet.of((Object)"gui.back", (Object)"gui.done", (Object)"gui.cancel", (Object)"gui.toTitle", (Object)"gui.toMenu");
        if (screen instanceof class_6599) {
            return false;
        }
        return screen.method_25396().stream().filter(element -> element instanceof class_4264).map(element -> (class_4264)element).filter(element -> element.method_25369() != null && element.method_25369().method_10851() != null).anyMatch(element -> {
            class_7417 patt0$temp = element.method_25369().method_10851();
            if (patt0$temp instanceof class_2588) {
                class_2588 translatableText = (class_2588)patt0$temp;
                if (set.stream().anyMatch(key -> translatableText.method_11022().equals(key))) {
                    element.method_25306((class_11907)ENTER_KEY_INPUT);
                    return true;
                }
            }
            return false;
        });
    }

    public static boolean isScreenInteractive(@NotNull class_437 screen) {
        return !(screen instanceof class_465) && !MidnightControlsConfig.joystickAsMouse && !MidnightControlsConfig.mouseScreens.stream().anyMatch(a -> screen.getClass().toString().contains((CharSequence)a)) && (!(screen instanceof SpruceScreen) || !((SpruceScreen)screen).requiresCursor()) && !MidnightControlsCompat.requireMouseOnScreen(screen);
    }

    public void pressKeyboardKey(class_310 client, int key) {
        ((KeyboardAccessor)client.field_1774).midnightcontrols$onKey(client.method_22683().method_4490(), 1, new class_11908(key, 0, 0));
    }

    public void pressKeyboardKey(class_437 screen, int key) {
        screen.method_25404(new class_11908(key, 0, 0));
    }
}

