/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.enums.ControllerType;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public class MidnightControlsRenderer {
    public static final int ICON_SIZE = 20;
    private static final int BUTTON_SIZE = 15;
    private static final int AXIS_SIZE = 18;

    public static int getButtonSize(int button) {
        return switch (button) {
            case -1 -> 0;
            case 100, 101, 102, 103, 200, 201, 202, 203 -> 18;
            default -> 15;
        };
    }

    public static int getBindingIconWidth(@NotNull ButtonBinding binding) {
        return MidnightControlsRenderer.getBindingIconWidth(binding.getButton());
    }

    public static int getBindingIconWidth(int[] buttons) {
        int width = 0;
        for (int i = 0; i < buttons.length; ++i) {
            width += 20;
            if (i + 1 >= buttons.length) continue;
            width += 2;
        }
        return width;
    }

    public static ButtonSize drawButton(class_332 context, int x, int y, @NotNull ButtonBinding button, @NotNull class_310 client) {
        return MidnightControlsRenderer.drawButton(context, x, y, button.getButton(), client);
    }

    public static ButtonSize drawButton(class_332 context, int x, int y, int[] buttons, @NotNull class_310 client) {
        int height = 0;
        int length = 0;
        int currentX = x;
        for (int i = 0; i < buttons.length; ++i) {
            int btn = buttons[i];
            int size = MidnightControlsRenderer.drawButton(context, currentX, y, btn, client);
            if (size > height) {
                height = size;
            }
            length += size;
            if (i + 1 >= buttons.length) continue;
            currentX = x + (length += 2);
        }
        return new ButtonSize(length, height);
    }

    public static int drawButton(class_332 context, int x, int y, int button, @NotNull class_310 client) {
        int assetSize;
        boolean second = false;
        if (button == -1) {
            return 0;
        }
        if (button >= 500) {
            button -= 1000;
            second = true;
        }
        int controllerType = MidnightControlsConfig.controllerType == ControllerType.DEFAULT ? MidnightControlsConfig.matchControllerToType().getId() : MidnightControlsConfig.controllerType.getId();
        boolean axis = false;
        int buttonOffset = button * 15;
        switch (button) {
            case 15: {
                buttonOffset = 0;
                break;
            }
            case 16: {
                buttonOffset = 18;
                break;
            }
            case 17: {
                buttonOffset = 36;
                break;
            }
            case 18: {
                buttonOffset = 54;
                break;
            }
            case 4: {
                buttonOffset = 105;
                break;
            }
            case 5: {
                buttonOffset = 120;
                break;
            }
            case 6: {
                buttonOffset = 60;
                break;
            }
            case 7: {
                buttonOffset = 90;
                break;
            }
            case 8: {
                buttonOffset = 75;
                break;
            }
            case 9: {
                buttonOffset = 225;
                break;
            }
            case 10: {
                buttonOffset = 240;
                break;
            }
            case 100: {
                buttonOffset = 0;
                axis = true;
                break;
            }
            case 101: {
                buttonOffset = 18;
                axis = true;
                break;
            }
            case 102: {
                buttonOffset = 36;
                axis = true;
                break;
            }
            case 103: {
                buttonOffset = 54;
                axis = true;
                break;
            }
            case 200: {
                buttonOffset = 72;
                axis = true;
                break;
            }
            case 201: {
                buttonOffset = 90;
                axis = true;
                break;
            }
            case 202: {
                buttonOffset = 108;
                axis = true;
                break;
            }
            case 203: {
                buttonOffset = 126;
                axis = true;
                break;
            }
            case 104: 
            case 204: {
                buttonOffset = 135;
                break;
            }
            case 105: 
            case 205: {
                buttonOffset = 150;
            }
        }
        int n = assetSize = axis || button >= 15 && button <= 18 ? 18 : 15;
        context.method_25290(class_10799.field_56883, axis ? MidnightControlsClient.CONTROLLER_AXIS : (button >= 15 && button <= 19 ? MidnightControlsClient.CONTROLLER_EXPANDED : MidnightControlsClient.CONTROLLER_BUTTONS), x + (10 - assetSize / 2), y + (10 - assetSize / 2), (float)buttonOffset, (float)(controllerType * assetSize), assetSize, assetSize, 256, 256);
        return 20;
    }

    public static int drawButtonTip(class_332 context, int x, int y, @NotNull ButtonBinding button, boolean display, @NotNull class_310 client) {
        return MidnightControlsRenderer.drawButtonTip(context, x, y, button.getButton(), button.getTranslationKey(), display, client);
    }

    public static int drawButtonTip(class_332 context, int x, int y, int[] button, @NotNull String action, boolean display, @NotNull class_310 client) {
        if (display) {
            int buttonWidth = MidnightControlsRenderer.drawButton(context, x, y, button, client).length();
            String translatedAction = class_1074.method_4662((String)action, (Object[])new Object[0]);
            Objects.requireNonNull(client.field_1772);
            int textY = 10 - 9 / 2 + 1;
            context.method_25303(client.field_1772, translatedAction, x + buttonWidth + 2, y + textY, -1);
            return x + buttonWidth + 2 + client.field_1772.method_1727(translatedAction);
        }
        return -10;
    }

    private static int getButtonTipWidth(@NotNull String action, @NotNull class_327 textRenderer) {
        return 20 + textRenderer.method_1727(action);
    }

    public record ButtonSize(int length, int height) {
    }
}

