/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.background.Background;
import dev.lambdaurora.spruceui.option.SpruceCyclingOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleInputOption;
import dev.lambdaurora.spruceui.option.SpruceDoubleOption;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSeparatorOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.option.SpruceToggleBooleanOption;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.tooltip.TooltipData;
import dev.lambdaurora.spruceui.widget.AbstractSpruceWidget;
import dev.lambdaurora.spruceui.widget.SpruceLabelWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceOptionListWidget;
import dev.lambdaurora.spruceui.widget.container.tabbed.SpruceTabbedWidget;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.gui.MappingsStringInputWidget;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerControlsWidget;
import eu.midnightdust.midnightcontrols.client.util.platform.NetworkUtil;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.KeyboardLayoutManager;
import eu.midnightdust.midnightcontrols.packet.ControlsModePayload;
import java.util.Objects;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9848;

public class MidnightControlsSettingsScreen
extends SpruceScreen {
    private static final class_2561 SDL2_GAMEPAD_TOOL = class_2561.method_43470((String)"SDL2 Gamepad Tool").method_27692(class_124.field_1060);
    public static final String GAMEPAD_TOOL_URL = "https://generalarcade.com/gamepadtool/";
    private final class_437 parent;
    private final SpruceOption inputModeOption;
    private final SpruceOption autoSwitchModeOption;
    private final SpruceOption rotationSpeedOption;
    private final SpruceOption yAxisRotationSpeedOption;
    private final SpruceOption mouseSpeedOption;
    private final SpruceOption joystickAsMouseOption;
    private final SpruceOption eyeTrackingAsMouseOption;
    private final SpruceOption eyeTrackingDeadzone;
    private final SpruceOption virtualMouseOption;
    private final SpruceOption virtualKeyboardOption;
    private final SpruceOption hideCursorOption;
    private final SpruceOption resetOption;
    private final SpruceOption analogMovementOption;
    private final SpruceOption autoJumpOption;
    private final SpruceOption controllerToggleSneakOption;
    private final SpruceOption controllerToggleSprintOption;
    private final SpruceOption fastBlockPlacingOption;
    private final SpruceOption frontBlockPlacingOption;
    private final SpruceOption verticalReacharoundOption;
    private final SpruceOption flyDriftingOption;
    private final SpruceOption flyVerticalDriftingOption;
    private final SpruceOption controllerTypeOption;
    private final SpruceOption virtualMouseSkinOption;
    private final SpruceOption hudEnableOption;
    private final SpruceOption hudSideOption;
    private final SpruceOption moveChatOption;
    private final SpruceOption controllerOption = new SpruceCyclingOption("midnightcontrols.menu.controller", amount -> {
        int id = MidnightControlsConfig.getController().id();
        if ((id += amount.intValue()) > 15) {
            id = 0;
        }
        id = MidnightControlsSettingsScreen.searchNextAvailableController(id, false);
        MidnightControlsConfig.setController(Controller.byId(id));
        if (MidnightControlsConfig.debug) {
            System.out.println(Controller.byId(id).getName() + "'s Controller GUID: " + Controller.byId(id).getGuid());
        }
    }, option -> {
        Controller controller = MidnightControlsConfig.getController();
        String controllerName = controller.getName();
        if (!controller.isConnected()) {
            return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName).method_27692(class_124.field_1061));
        }
        if (!controller.isGamepad()) {
            return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName).method_27692(class_124.field_1065));
        }
        return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName));
    }, TooltipData.EMPTY);
    private final SpruceOption secondControllerOption = new SpruceCyclingOption("midnightcontrols.menu.controller2", amount -> {
        int id = MidnightControlsConfig.getSecondController().map(Controller::id).orElse(-1);
        if ((id += amount.intValue()) > 15) {
            id = -1;
        }
        MidnightControlsConfig.setSecondController((id = MidnightControlsSettingsScreen.searchNextAvailableController(id, true)) == -1 ? null : Controller.byId(id));
    }, option -> MidnightControlsConfig.getSecondController().map(controller -> {
        String controllerName = controller.getName();
        if (!controller.isConnected()) {
            return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName).method_27692(class_124.field_1061));
        }
        if (!controller.isGamepad()) {
            return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName).method_27692(class_124.field_1065));
        }
        return option.getDisplayText((class_2561)class_2561.method_43470((String)controllerName));
    }).orElse(option.getDisplayText((class_2561)SpruceTexts.OPTIONS_OFF.method_27662().method_27692(class_124.field_1061))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.controller2.tooltip")).build());
    private final SpruceOption unfocusedInputOption;
    private final SpruceOption invertsRightXAxis;
    private final SpruceOption invertsRightYAxis;
    private final SpruceOption cameraModeOption;
    private final SpruceOption toggleControllerProfileOption;
    private final SpruceOption rightDeadZoneOption;
    private final SpruceOption leftDeadZoneOption;
    private final SpruceOption[] maxAnalogValueOptions = new SpruceOption[]{MidnightControlsSettingsScreen.maxAnalogValueOption("midnightcontrols.menu.max_left_x_value", 0), MidnightControlsSettingsScreen.maxAnalogValueOption("midnightcontrols.menu.max_left_y_value", 1), MidnightControlsSettingsScreen.maxAnalogValueOption("midnightcontrols.menu.max_right_x_value", 2), MidnightControlsSettingsScreen.maxAnalogValueOption("midnightcontrols.menu.max_right_y_value", 3)};
    public static final SpruceOption virtualKeyboardLayoutOption = new SpruceCyclingOption("midnightcontrols.menu.virtual_keyboard_layout", amount -> {
        MidnightControlsConfig.keyboardLayout = KeyboardLayoutManager.getNext(KeyboardLayoutManager.getById(MidnightControlsConfig.keyboardLayout)).getId();
    }, option -> option.getDisplayText((class_2561)class_2561.method_43471((String)KeyboardLayoutManager.getById(MidnightControlsConfig.keyboardLayout).getTranslationKey())), TooltipData.EMPTY);
    private final SpruceOption touchWithControllerOption;
    private final SpruceOption touchSpeedOption;
    private final SpruceOption touchBreakDelayOption;
    private final SpruceOption invertTouchOption;
    private final SpruceOption touchTransparencyOption;
    private final SpruceOption touchModeOption;
    private final class_5250 controllerMappingsUrlText = class_2561.method_43470((String)"(").method_10852((class_2561)class_2561.method_43470((String)"https://generalarcade.com/gamepadtool/").method_27692(class_124.field_1065)).method_27693("),");

    private static SpruceOption maxAnalogValueOption(String key, int axis) {
        return new SpruceDoubleOption(key, 0.25, 1.0, 0.05f, () -> MidnightControlsConfig.getAxisMaxValue(axis), newValue -> MidnightControlsConfig.setAxisMaxValue(axis, newValue), option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.format("%.2f", option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)key.concat(".tooltip"))).build());
    }

    public static int searchNextAvailableController(int newId, boolean allowNone) {
        if (allowNone && newId == -1 || newId == 0) {
            return newId;
        }
        Controller candidate = Controller.byId(newId);
        boolean connected = candidate.isConnected();
        if (MidnightControlsConfig.excludedControllers.stream().anyMatch(exclusion -> candidate.getName().matches((String)exclusion))) {
            connected = false;
        }
        if (!connected) {
            ++newId;
        }
        if (newId > 15) {
            newId = allowNone ? -1 : 0;
        }
        return connected ? newId : MidnightControlsSettingsScreen.searchNextAvailableController(newId, allowNone);
    }

    public MidnightControlsSettingsScreen(class_437 parent, boolean hideControls) {
        super((class_2561)class_2561.method_43471((String)"midnightcontrols.title.settings"));
        MidnightControlsConfig.isEditing = true;
        this.parent = parent;
        this.inputModeOption = new SpruceCyclingOption("midnightcontrols.menu.controls_mode", amount -> {
            ControlsMode next;
            MidnightControlsConfig.controlsMode = next = MidnightControlsConfig.controlsMode.next();
            MidnightControlsConfig.save();
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                NetworkUtil.sendPayloadC2S(new ControlsModePayload(next.getName()));
            }
        }, option -> option.getDisplayText((class_2561)class_2561.method_43471((String)MidnightControlsConfig.controlsMode.method_7359())), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.controls_mode.tooltip")).build());
        this.autoSwitchModeOption = new SpruceToggleBooleanOption("midnightcontrols.menu.auto_switch_mode", () -> MidnightControlsConfig.autoSwitchMode, value -> {
            MidnightControlsConfig.autoSwitchMode = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.auto_switch_mode.tooltip")).build());
        this.rotationSpeedOption = new SpruceDoubleOption("midnightcontrols.menu.rotation_speed", 0.0, 100.0, 0.5f, () -> MidnightControlsConfig.rotationSpeed, value -> {
            MidnightControlsConfig.rotationSpeed = value;
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.rotation_speed.tooltip")).build());
        this.yAxisRotationSpeedOption = new SpruceDoubleOption("midnightcontrols.menu.y_axis_rotation_speed", 0.0, 100.0, 0.5f, () -> MidnightControlsConfig.yAxisRotationSpeed, value -> {
            MidnightControlsConfig.yAxisRotationSpeed = value;
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.y_axis_rotation_speed.tooltip")).build());
        this.mouseSpeedOption = new SpruceDoubleOption("midnightcontrols.menu.mouse_speed", 0.0, 150.0, 0.5f, () -> MidnightControlsConfig.mouseSpeed, value -> {
            MidnightControlsConfig.mouseSpeed = value;
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.mouse_speed.tooltip")).build());
        this.joystickAsMouseOption = new SpruceToggleBooleanOption("midnightcontrols.menu.joystick_as_mouse", () -> MidnightControlsConfig.joystickAsMouse, value -> {
            MidnightControlsConfig.joystickAsMouse = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.joystick_as_mouse.tooltip")).build());
        this.eyeTrackingAsMouseOption = new SpruceToggleBooleanOption("midnightcontrols.menu.eye_tracker_as_mouse", () -> MidnightControlsConfig.eyeTrackerAsMouse, value -> {
            MidnightControlsConfig.eyeTrackerAsMouse = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.eye_tracker_as_mouse.tooltip")).build());
        this.eyeTrackingDeadzone = new SpruceDoubleInputOption("midnightcontrols.menu.eye_tracker_deadzone", () -> MidnightControlsConfig.eyeTrackerDeadzone, value -> {
            MidnightControlsConfig.eyeTrackerDeadzone = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.eye_tracker_deadzone.tooltip")).build());
        this.resetOption = SpruceSimpleActionOption.reset(btn -> {
            MidnightControlsConfig.reset();
            class_310 client = class_310.method_1551();
            this.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
        });
        this.analogMovementOption = new SpruceToggleBooleanOption("midnightcontrols.menu.analog_movement", () -> MidnightControlsConfig.analogMovement, value -> {
            MidnightControlsConfig.analogMovement = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.analog_movement.tooltip")).build());
        this.autoJumpOption = new SpruceToggleBooleanOption("options.autoJump", () -> (Boolean)this.field_22787.field_1690.method_42423().method_41753(), newValue -> this.field_22787.field_1690.method_42423().method_41748(newValue), TooltipData.EMPTY);
        this.controllerToggleSneakOption = new SpruceToggleBooleanOption("midnightcontrols.menu.controller_toggle_sneak", () -> MidnightControlsConfig.controllerToggleSneak, value -> {
            MidnightControlsConfig.controllerToggleSneak = value;
        }, TooltipData.EMPTY);
        this.controllerToggleSprintOption = new SpruceToggleBooleanOption("midnightcontrols.menu.controller_toggle_sprint", () -> MidnightControlsConfig.controllerToggleSprint, value -> {
            MidnightControlsConfig.controllerToggleSprint = value;
        }, TooltipData.EMPTY);
        this.fastBlockPlacingOption = new SpruceToggleBooleanOption("midnightcontrols.menu.fast_block_placing", () -> MidnightControlsConfig.fastBlockPlacing, value -> {
            MidnightControlsConfig.fastBlockPlacing = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.fast_block_placing.tooltip")).build());
        this.frontBlockPlacingOption = new SpruceToggleBooleanOption("midnightcontrols.menu.reacharound.horizontal", () -> MidnightControlsConfig.horizontalReacharound, value -> {
            MidnightControlsConfig.horizontalReacharound = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.reacharound.horizontal.tooltip")).build());
        this.verticalReacharoundOption = new SpruceToggleBooleanOption("midnightcontrols.menu.reacharound.vertical", () -> MidnightControlsConfig.verticalReacharound, value -> {
            MidnightControlsConfig.verticalReacharound = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.reacharound.vertical.tooltip")).build());
        this.flyDriftingOption = new SpruceToggleBooleanOption("midnightcontrols.menu.fly_drifting", () -> MidnightControlsConfig.flyDrifting, value -> {
            MidnightControlsConfig.flyDrifting = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.fly_drifting.tooltip")).build());
        this.flyVerticalDriftingOption = new SpruceToggleBooleanOption("midnightcontrols.menu.fly_drifting_vertical", () -> MidnightControlsConfig.verticalFlyDrifting, value -> {
            MidnightControlsConfig.verticalFlyDrifting = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.fly_drifting_vertical.tooltip")).build());
        this.controllerTypeOption = new SpruceCyclingOption("midnightcontrols.menu.controller_type", amount -> {
            MidnightControlsConfig.controllerType = MidnightControlsConfig.controllerType.next();
        }, option -> option.getDisplayText(MidnightControlsConfig.controllerType.getTranslatedText()), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.controller_type.tooltip")).build());
        this.virtualMouseSkinOption = new SpruceCyclingOption("midnightcontrols.menu.virtual_mouse.skin", amount -> {
            MidnightControlsConfig.virtualMouseSkin = MidnightControlsConfig.virtualMouseSkin.next();
        }, option -> option.getDisplayText(MidnightControlsConfig.virtualMouseSkin.getTranslatedText()), TooltipData.EMPTY);
        this.hudEnableOption = new SpruceToggleBooleanOption("midnightcontrols.menu.hud_enable", () -> MidnightControlsConfig.hudEnable, MidnightControlsClient::setHudEnabled, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.hud_enable.tooltip")).build());
        this.hudSideOption = new SpruceCyclingOption("midnightcontrols.menu.hud_side", amount -> {
            MidnightControlsConfig.hudSide = MidnightControlsConfig.hudSide.next();
        }, option -> option.getDisplayText(MidnightControlsConfig.hudSide.getTranslatedText()), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.hud_side.tooltip")).build());
        this.moveChatOption = new SpruceToggleBooleanOption("midnightcontrols.menu.move_chat", () -> MidnightControlsConfig.moveChat, value -> {
            MidnightControlsConfig.moveChat = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.move_chat.tooltip")).build());
        this.toggleControllerProfileOption = new SpruceToggleBooleanOption("midnightcontrols.menu.separate_controller_profile", () -> MidnightControlsConfig.controllerBindingProfiles.containsKey(MidnightControlsConfig.getController().getGuid()), value -> {
            if (value.booleanValue()) {
                MidnightControlsConfig.controllerBindingProfiles.put(MidnightControlsConfig.getController().getGuid(), MidnightControlsConfig.getBindingsForController());
                MidnightControlsConfig.updateBindingsForController(MidnightControlsConfig.getController());
            } else {
                MidnightControlsConfig.controllerBindingProfiles.remove(MidnightControlsConfig.getController().getGuid());
                MidnightControlsConfig.updateBindingsForController(MidnightControlsConfig.getController());
            }
        }, TooltipData.EMPTY);
        this.cameraModeOption = new SpruceCyclingOption("midnightcontrols.menu.camera_mode", amount -> {
            MidnightControlsConfig.cameraMode = MidnightControlsConfig.cameraMode.next();
        }, option -> option.getDisplayText(MidnightControlsConfig.cameraMode.getTranslatedText()), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.camera_mode.tooltip")).build());
        this.rightDeadZoneOption = new SpruceDoubleOption("midnightcontrols.menu.right_dead_zone", 0.05, 1.0, 0.05f, () -> MidnightControlsConfig.rightDeadZone, value -> {
            MidnightControlsConfig.rightDeadZone = value;
        }, option -> {
            String value = String.valueOf(option.get());
            return option.getDisplayText((class_2561)class_2561.method_43470((String)value.substring(0, Math.min(value.length(), 5))));
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.right_dead_zone.tooltip")).build());
        this.leftDeadZoneOption = new SpruceDoubleOption("midnightcontrols.menu.left_dead_zone", 0.05, 1.0, 0.05f, () -> MidnightControlsConfig.leftDeadZone, value -> {
            MidnightControlsConfig.leftDeadZone = value;
        }, option -> {
            String value = String.valueOf(option.get());
            return option.getDisplayText((class_2561)class_2561.method_43470((String)value.substring(0, Math.min(value.length(), 5))));
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.left_dead_zone.tooltip")).build());
        this.invertsRightXAxis = new SpruceToggleBooleanOption("midnightcontrols.menu.invert_right_x_axis", () -> MidnightControlsConfig.invertRightXAxis, value -> {
            MidnightControlsConfig.invertRightXAxis = value;
        }, TooltipData.EMPTY);
        this.invertsRightYAxis = new SpruceToggleBooleanOption("midnightcontrols.menu.invert_right_y_axis", () -> MidnightControlsConfig.invertRightYAxis, value -> {
            MidnightControlsConfig.invertRightYAxis = value;
        }, TooltipData.EMPTY);
        this.unfocusedInputOption = new SpruceToggleBooleanOption("midnightcontrols.menu.unfocused_input", () -> MidnightControlsConfig.unfocusedInput, value -> {
            MidnightControlsConfig.unfocusedInput = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.unfocused_input.tooltip")).build());
        this.virtualMouseOption = new SpruceToggleBooleanOption("midnightcontrols.menu.virtual_mouse", () -> MidnightControlsConfig.virtualMouse, value -> {
            MidnightControlsConfig.virtualMouse = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.virtual_mouse.tooltip")).build());
        this.virtualKeyboardOption = new SpruceToggleBooleanOption("midnightcontrols.menu.virtual_keyboard", () -> MidnightControlsConfig.virtualMouse, value -> {
            MidnightControlsConfig.virtualKeyboard = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.virtual_keyboard.tooltip")).build());
        this.hideCursorOption = new SpruceToggleBooleanOption("midnightcontrols.menu.hide_cursor", () -> MidnightControlsConfig.hideNormalMouse, value -> {
            MidnightControlsConfig.hideNormalMouse = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.hide_cursor.tooltip")).build());
        this.touchModeOption = new SpruceCyclingOption("midnightcontrols.menu.touch_mode", amount -> {
            MidnightControlsConfig.touchMode = MidnightControlsConfig.touchMode.next();
        }, option -> option.getDisplayText(MidnightControlsConfig.touchMode.getTranslatedText()), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.touch_mode.tooltip")).build());
        this.touchWithControllerOption = new SpruceToggleBooleanOption("midnightcontrols.menu.touch_with_controller", () -> MidnightControlsConfig.touchInControllerMode, value -> {
            MidnightControlsConfig.touchInControllerMode = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.touch_with_controller.tooltip")).build());
        this.touchSpeedOption = new SpruceDoubleOption("midnightcontrols.menu.touch_speed", 0.0, 150.0, 0.5f, () -> MidnightControlsConfig.touchSpeed, value -> {
            MidnightControlsConfig.touchSpeed = value;
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.touch_speed.tooltip")).build());
        this.touchBreakDelayOption = new SpruceDoubleOption("midnightcontrols.menu.touch_break_delay", 50.0, 500.0, 1.0f, () -> MidnightControlsConfig.touchBreakDelay, value -> {
            MidnightControlsConfig.touchBreakDelay = value.intValue();
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.touch_break_delay.tooltip")).build());
        this.touchTransparencyOption = new SpruceDoubleOption("midnightcontrols.menu.touch_transparency", 0.0, 100.0, 1.0f, () -> MidnightControlsConfig.touchTransparency, value -> {
            MidnightControlsConfig.touchTransparency = value.intValue();
        }, option -> option.getDisplayText((class_2561)class_2561.method_43470((String)String.valueOf(option.get()))), TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.touch_break_delay.tooltip")).build());
        this.invertTouchOption = new SpruceToggleBooleanOption("midnightcontrols.menu.invert_touch", () -> MidnightControlsConfig.invertTouch, value -> {
            MidnightControlsConfig.invertTouch = value;
        }, TooltipData.builder().text((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.invert_touch.tooltip")).build());
    }

    public void method_25432() {
        MidnightControlsConfig.isEditing = false;
        MidnightControlsConfig.save();
        super.method_25432();
    }

    public void method_25419() {
        MidnightControlsConfig.isEditing = false;
        MidnightControlsConfig.save();
        super.method_25419();
    }

    private int getTextHeight() {
        Objects.requireNonNull(this.field_22793);
        return (5 + 9) * 3 + 5;
    }

    protected void method_25426() {
        super.method_25426();
        this.buildTabs();
        this.method_37063((class_364)this.resetOption.createWidget(Position.of((int)(this.field_22789 / 2 - 155), (int)(this.field_22790 - 29)), 150));
        this.method_37063((class_364)class_4185.method_46430((class_2561)SpruceTexts.GUI_DONE, btn -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - 155 + 160, this.field_22790 - 29, 150, 20).method_46431());
    }

    public void buildTabs() {
        SpruceTabbedWidget tabs = new SpruceTabbedWidget(Position.of((int)0, (int)24), this.field_22789, this.field_22790 - 32 - 24, null, Math.max(116, this.field_22789 / 8), 0);
        tabs.getList().setBackground((Background)new MidnightControlsBackground());
        this.method_37063((class_364)tabs);
        tabs.addSeparatorEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.separator.general"));
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.general"), null, this::buildGeneralTab);
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.gameplay"), null, this::buildGameplayTab);
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.visual"), null, this::buildVisualTab);
        tabs.addSeparatorEntry((class_2561)class_2561.method_43471((String)"options.controls"));
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.controller_controls"), null, this::buildControllerControlsTab);
        tabs.addSeparatorEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.separator.controller"));
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.controller"), null, this::buildControllerTab);
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.touch"), null, this::buildTouchTab);
        tabs.addTabEntry((class_2561)class_2561.method_43471((String)"midnightcontrols.menu.title.mappings.string"), null, this::buildMappingsStringEditorTab);
    }

    public SpruceOptionListWidget buildGeneralTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        list.setBackground((Background)new MidnightControlsBackground(130));
        list.addSingleOptionEntry(this.inputModeOption);
        list.addSingleOptionEntry(this.autoSwitchModeOption);
        list.addSingleOptionEntry(this.rotationSpeedOption);
        list.addSingleOptionEntry(this.yAxisRotationSpeedOption);
        list.addSingleOptionEntry(this.mouseSpeedOption);
        list.addSingleOptionEntry(this.virtualMouseOption);
        list.addSingleOptionEntry(this.virtualKeyboardOption);
        list.addSingleOptionEntry(virtualKeyboardLayoutOption);
        list.addSingleOptionEntry(this.hideCursorOption);
        list.addSingleOptionEntry(this.joystickAsMouseOption);
        list.addSingleOptionEntry(this.eyeTrackingAsMouseOption);
        return list;
    }

    public SpruceOptionListWidget buildGameplayTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        list.setBackground((Background)new MidnightControlsBackground(130));
        list.addSingleOptionEntry(this.analogMovementOption);
        list.addSingleOptionEntry(this.controllerToggleSneakOption);
        list.addSingleOptionEntry(this.controllerToggleSprintOption);
        if (MidnightControls.isExtrasLoaded) {
            list.addSingleOptionEntry(this.fastBlockPlacingOption);
        }
        if (MidnightControls.isExtrasLoaded) {
            list.addSingleOptionEntry(this.frontBlockPlacingOption);
        }
        if (MidnightControls.isExtrasLoaded) {
            list.addSingleOptionEntry(this.verticalReacharoundOption);
        }
        if (MidnightControls.isExtrasLoaded) {
            list.addSingleOptionEntry(this.flyDriftingOption);
        }
        if (MidnightControls.isExtrasLoaded) {
            list.addSingleOptionEntry(this.flyVerticalDriftingOption);
        }
        list.addSingleOptionEntry(this.autoJumpOption);
        return list;
    }

    public SpruceOptionListWidget buildVisualTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        list.setBackground((Background)new MidnightControlsBackground(130));
        list.addSingleOptionEntry(this.controllerTypeOption);
        list.addSingleOptionEntry(this.virtualMouseSkinOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption("midnightcontrols.menu.title.hud", true, TooltipData.EMPTY));
        list.addSingleOptionEntry(this.hudEnableOption);
        list.addSingleOptionEntry(this.hudSideOption);
        list.addSingleOptionEntry(this.moveChatOption);
        return list;
    }

    public ControllerControlsWidget buildControllerControlsTab(int width, int height) {
        return new ControllerControlsWidget(Position.origin(), width, height);
    }

    public AbstractSpruceWidget buildControllerTab(int width, int height) {
        SpruceContainerWidget root = new SpruceContainerWidget(Position.origin(), width, height);
        SpruceLabelWidget aboutMappings1 = new SpruceLabelWidget(Position.of((int)0, (int)2), (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.mappings.1", (Object[])new Object[]{SDL2_GAMEPAD_TOOL}), width);
        SpruceLabelWidget gamepadToolUrlLabel = new SpruceLabelWidget(Position.of((int)0, (int)(aboutMappings1.getHeight() + 4)), (class_2561)this.controllerMappingsUrlText, width, label -> class_156.method_668().method_670(GAMEPAD_TOOL_URL));
        gamepadToolUrlLabel.setTooltip((class_2561)class_2561.method_43471((String)"chat.link.open"));
        SpruceLabelWidget aboutMappings3 = new SpruceLabelWidget(Position.of((int)0, (int)(aboutMappings1.getHeight() + gamepadToolUrlLabel.getHeight() + 6)), (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.mappings.3", (Object[])new Object[]{class_124.field_1060.toString(), class_124.field_1070.toString()}), width);
        int listHeight = height - 8 - aboutMappings1.getHeight() - aboutMappings3.getHeight() - gamepadToolUrlLabel.getHeight();
        SpruceContainerWidget labels = new SpruceContainerWidget(Position.of((int)0, (int)listHeight), width, height - listHeight);
        labels.addChild((SpruceWidget)aboutMappings1);
        labels.addChild((SpruceWidget)gamepadToolUrlLabel);
        labels.addChild((SpruceWidget)aboutMappings3);
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, listHeight);
        list.setBackground((Background)new MidnightControlsBackground(130));
        list.addSingleOptionEntry(this.controllerOption);
        list.addSingleOptionEntry(this.secondControllerOption);
        list.addSingleOptionEntry(this.toggleControllerProfileOption);
        list.addSingleOptionEntry(this.unfocusedInputOption);
        list.addSingleOptionEntry(this.cameraModeOption);
        list.addOptionEntry(this.invertsRightXAxis, this.invertsRightYAxis);
        list.addSingleOptionEntry(this.rightDeadZoneOption);
        list.addSingleOptionEntry(this.leftDeadZoneOption);
        for (SpruceOption option : this.maxAnalogValueOptions) {
            list.addSingleOptionEntry(option);
        }
        root.addChild((SpruceWidget)list);
        root.addChild((SpruceWidget)labels);
        return root;
    }

    public SpruceOptionListWidget buildTouchTab(int width, int height) {
        SpruceOptionListWidget list = new SpruceOptionListWidget(Position.origin(), width, height);
        list.setBackground((Background)new MidnightControlsBackground(130));
        list.addSingleOptionEntry(this.touchSpeedOption);
        list.addSingleOptionEntry(this.touchWithControllerOption);
        list.addSingleOptionEntry(this.invertTouchOption);
        list.addSingleOptionEntry((SpruceOption)new SpruceSeparatorOption("midnightcontrols.menu.title.hud", true, TooltipData.EMPTY));
        list.addSingleOptionEntry(this.touchModeOption);
        list.addSingleOptionEntry(this.touchBreakDelayOption);
        list.addSingleOptionEntry(this.touchTransparencyOption);
        return list;
    }

    public SpruceContainerWidget buildMappingsStringEditorTab(int width, int height) {
        return new MappingsStringInputWidget(Position.origin(), width, height);
    }

    public void render(SpruceGuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        context.vanilla().method_25300(this.field_22793, class_1074.method_4662((String)"midnightcontrols.menu.title", (Object[])new Object[0]), this.field_22789 / 2, 8, -1);
    }

    public static class MidnightControlsBackground
    implements Background {
        private int transparency = 160;

        public MidnightControlsBackground() {
        }

        public MidnightControlsBackground(int transparency) {
            this.transparency = transparency;
        }

        public void render(SpruceGuiGraphics context, SpruceWidget widget, int vOffset, int mouseX, int mouseY, float delta) {
            context.fill(widget.getX(), widget.getY(), widget.getX() + widget.getWidth(), widget.getY() + widget.getHeight(), class_9848.method_61324((int)this.transparency, (int)0, (int)0, (int)0));
        }
    }
}

