/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.navigation.NavigationUtils;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceIconButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceSeparatorWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceEntryListWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceParentWidget;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerButtonWidget;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerControlsWidget;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8027;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlsListWidget
extends SpruceEntryListWidget<Entry> {
    private static final int[] UNBOUND = new int[]{-1};
    private final ControllerControlsWidget gui;
    protected int lastIndex = 0;
    private final int maxTextLength;

    public ControlsListWidget(Position position, int width, int height, ControllerControlsWidget gui) {
        super(position, width, height, 4, Entry.class);
        this.gui = gui;
        this.maxTextLength = InputManager.streamBindings().mapToInt(binding -> this.client.field_1772.method_27525((class_5348)binding.getText())).max().orElse(0);
        InputManager.streamCategories().sorted(Comparator.comparingInt(ButtonCategory::getPriority)).forEach(category -> {
            this.addEntry(new CategoryEntry(this, (ButtonCategory)category));
            category.getBindings().forEach(binding -> this.addEntry(new ButtonBindingEntry(this, (ButtonBinding)binding)));
        });
        this.setAllowOutsideHorizontalNavigation(true);
    }

    private int getRowWidth() {
        return this.getWidth() - 6 - this.getRowLeft() * 2;
    }

    public int getRowLeft() {
        int baseWidth = 252;
        return this.getWidth() / 2 - baseWidth / 2 + 72 - this.maxTextLength;
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends SpruceEntryListWidget.Entry {
        protected final ControlsListWidget parent;

        protected Entry(ControlsListWidget parent) {
            this.parent = parent;
        }

        public int getWidth() {
            return this.parent.getInnerWidth();
        }
    }

    public static class CategoryEntry
    extends Entry {
        private final SpruceSeparatorWidget separatorWidget;

        protected CategoryEntry(ControlsListWidget parent, ButtonCategory category) {
            super(parent);
            this.separatorWidget = new SpruceSeparatorWidget(Position.of((SprucePositioned)this, (int)2, (int)0), this.getWidth() - 4, (class_2561)class_2561.method_43470((String)category.getTranslatedName())){

                public int getWidth() {
                    return this.getWidth() - 4;
                }
            };
        }

        public SpruceSeparatorWidget getSeparatorWidget() {
            return this.separatorWidget;
        }

        public int getHeight() {
            return this.separatorWidget.getHeight() + 4;
        }

        public boolean onNavigation(NavigationEvent event) {
            return this.separatorWidget.onNavigation(event);
        }

        protected void renderWidget(SpruceGuiGraphics context, int mouseX, int mouseY, float delta) {
            this.separatorWidget.render(context, mouseX, mouseY, delta);
        }

        public String toString() {
            return "SpruceTabbedWidget$SeparatorEntry{position=" + String.valueOf(this.getPosition()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
        }
    }

    public class ButtonBindingEntry
    extends Entry
    implements SpruceParentWidget<SpruceWidget> {
        private final List<SpruceWidget> children;
        @Nullable
        private SpruceWidget focused;
        private final ButtonBinding binding;
        private final String bindingName;
        private final ControllerButtonWidget editButton;
        private final SpruceButtonWidget resetButton;
        private final SpruceButtonWidget unbindButton;

        ButtonBindingEntry(@NotNull ControlsListWidget parent, final ButtonBinding binding) {
            super(parent);
            this.children = new ArrayList<SpruceWidget>();
            this.binding = binding;
            this.bindingName = class_1074.method_4662((String)this.binding.getTranslationKey(), (Object[])new Object[0]);
            this.editButton = new ControllerButtonWidget(Position.of((SprucePositioned)this, (int)(parent.getWidth() / 2 - 8), (int)0), 120, this.binding, btn -> {
                ControlsListWidget.this.gui.focusedBinding = binding;
                MidnightControlsClient.input.beginControlsInput(ControlsListWidget.this.gui);
            }){

                protected class_2561 getNarrationMessage() {
                    return binding.isNotBound() ? class_2561.method_43469((String)"narrator.controls.unbound", (Object[])new Object[]{ButtonBindingEntry.this.bindingName}) : class_2561.method_43469((String)"narrator.controls.bound", (Object[])new Object[]{ButtonBindingEntry.this.bindingName, super.getNarrationMessage()});
                }
            };
            this.children.add((SpruceWidget)this.editButton);
            this.resetButton = new SpruceIconButtonWidget(Position.of((SprucePositioned)this, (int)(this.editButton.getPosition().getRelativeX() + this.editButton.getWidth() + 2), (int)0), 37, 20, (class_2561)class_2561.method_43473(), btn -> MidnightControlsConfig.setButtonBinding(binding, binding.getDefaultButton())){
                private final class_2960 resetTexture;
                {
                    super(position, width, height, message, action);
                    this.resetTexture = class_2960.method_60655((String)"midnightlib", (String)"icon/reset");
                }

                protected class_2561 getNarrationMessage() {
                    return class_2561.method_43469((String)"narrator.controls.reset", (Object[])new Object[]{ButtonBindingEntry.this.bindingName});
                }

                protected int renderIcon(SpruceGuiGraphics context, int mouseX, int mouseY, float delta) {
                    int size = 12;
                    int x = this.getX() + this.getWidth() / 2 - size / 2;
                    int y = this.getY() + this.getHeight() / 2 - size / 2;
                    context.vanilla().method_52706(class_10799.field_56883, this.resetTexture, x, y, size, size);
                    return 1;
                }
            };
            this.children.add((SpruceWidget)this.resetButton);
            this.unbindButton = new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.editButton.getPosition().getRelativeX() + this.editButton.getWidth() + 2), (int)0), this.resetButton.getWidth(), this.resetButton.getHeight(), SpruceTexts.GUI_UNBIND, btn -> {
                MidnightControlsConfig.setButtonBinding(binding, UNBOUND);
                ControlsListWidget.this.gui.focusedBinding = null;
                MidnightControlsClient.input.beginControlsInput(null);
            }){

                protected class_2561 getNarrationMessage() {
                    return class_2561.method_43469((String)"midnightcontrols.narrator.unbound", (Object[])new Object[]{ButtonBindingEntry.this.bindingName});
                }
            };
            this.children.add((SpruceWidget)this.unbindButton);
            this.position.setRelativeX(4);
            this.width -= 10;
        }

        public List<SpruceWidget> children() {
            return this.children;
        }

        @Nullable
        public SpruceWidget getFocused() {
            return this.focused;
        }

        public void setFocused(@Nullable SpruceWidget focused) {
            if (this.focused == focused) {
                return;
            }
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            this.focused = focused;
        }

        public int getHeight() {
            return this.children.stream().mapToInt(SpruceWidget::getHeight).reduce(Integer::max).orElse(0) + 4;
        }

        protected boolean onMouseClick(class_11909 click, boolean doubleClick) {
            SpruceWidget element;
            Iterator<SpruceWidget> it = this.children().iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(element = it.next()).method_25402(click, false));
            this.setFocused(element);
            if (click.method_74245() == 0) {
                this.dragging = true;
            }
            return true;
        }

        protected boolean onMouseRelease(class_11909 click) {
            this.dragging = false;
            return this.hoveredElement(click.comp_4798(), click.comp_4799()).filter(element -> element.method_25406(click)).isPresent();
        }

        protected boolean onMouseDrag(@NotNull class_11909 click, double deltaX, double deltaY) {
            return this.getFocused() != null && this.dragging && click.method_74245() == 0 && this.getFocused().method_25403(click, deltaX, deltaY);
        }

        protected boolean onKeyPress(@NotNull class_11908 input) {
            return this.focused != null && this.focused.method_25404(input);
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
            if (!focused) {
                this.setFocused(null);
            }
        }

        public boolean onNavigation(NavigationEvent event) {
            if (this.requiresCursor()) {
                return false;
            }
            if (!event.tab() && event.direction().method_48237() == class_8027.field_41823) {
                if (this.method_25370()) {
                    this.setFocused(null);
                    return false;
                }
                int lastIndex = this.parent.lastIndex;
                if (lastIndex >= this.children.size()) {
                    lastIndex = this.children.size() - 1;
                }
                if (!this.children.get(lastIndex).onNavigation(event)) {
                    return false;
                }
                this.setFocused(this.children.get(lastIndex));
                return true;
            }
            boolean result = NavigationUtils.tryNavigate((NavigationEvent)event, this.children, (SpruceWidget)this.focused, this::setFocused, (boolean)true);
            if (result) {
                this.method_25365(true);
                if (event.direction().method_48237() == class_8027.field_41822 && this.getFocused() != null) {
                    this.parent.lastIndex = this.children.indexOf(this.getFocused());
                }
            }
            return result;
        }

        protected void renderWidget(SpruceGuiGraphics context, int mouseX, int mouseY, float delta) {
            boolean focused = ControlsListWidget.this.gui.focusedBinding == this.binding;
            class_327 textRenderer = ((ControlsListWidget)ControlsListWidget.this).client.field_1772;
            int height = this.getHeight();
            int textY = this.getY() + height / 2;
            context.drawText(textRenderer, this.bindingName, this.getX(), textY - 4, -1, true);
            this.resetButton.setVisible(!focused);
            this.unbindButton.setVisible(focused);
            this.resetButton.setActive(!this.binding.isDefault());
            this.editButton.update();
            if (focused) {
                class_5250 text = class_2561.method_43470((String)"> ").method_27692(class_124.field_1068);
                text.method_10852((class_2561)this.editButton.getMessage().method_27661().method_27692(class_124.field_1054));
                this.editButton.setMessage((class_2561)text.method_10852((class_2561)class_2561.method_43470((String)" <").method_27692(class_124.field_1068)));
            } else if (!this.binding.isNotBound() && InputManager.hasDuplicatedBindings(this.binding)) {
                class_5250 text = this.editButton.getMessage().method_27661();
                this.editButton.setMessage((class_2561)text.method_27692(class_124.field_1061));
            } else if (this.binding.isNotBound()) {
                class_5250 text = this.editButton.getMessage().method_27661();
                this.editButton.setMessage((class_2561)text.method_27692(class_124.field_1065));
            }
            this.children.forEach(widget -> widget.render(context, mouseX, mouseY, delta));
        }
    }
}

