/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.ring;

import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.ring.ButtonBindingRingAction;
import eu.midnightdust.midnightcontrols.client.ring.RingAction;
import eu.midnightdust.midnightcontrols.client.ring.RingPage;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public final class MidnightRing {
    public static final int ELEMENT_SIZE = 75;
    private final Map<String, RingAction.Factory> actionFactories = new Object2ObjectOpenHashMap();
    private final List<RingPage> pages = new ArrayList<RingPage>(Collections.singletonList(RingPage.DEFAULT));
    private int currentPage = 0;

    public void registerAction(@NotNull String name, @NotNull RingAction.Factory factory) {
        if (this.actionFactories.containsKey(name)) {
            MidnightControls.warn("Tried to register a ring action twice: \"" + name + "\".");
            return;
        }
        this.actionFactories.put(name, factory);
    }

    public void loadFromConfig() {
        List<String> configBindings = MidnightControlsConfig.ringBindings;
        if (configBindings != null) {
            this.pages.clear();
            int bindingIndex = 0;
            for (int i = 0; i < class_3532.method_15386((float)((float)configBindings.size() / 8.0f)); ++i) {
                this.pages.add(new RingPage(i + 1 + " / " + class_3532.method_15386((float)((float)configBindings.size() / 8.0f))));
            }
            for (String binding : configBindings) {
                ButtonBinding buttonBinding = InputManager.getBinding(binding);
                if (buttonBinding == null) continue;
                RingPage page = this.pages.get(class_3532.method_15375((float)((float)bindingIndex / 8.0f)));
                page.actions[bindingIndex - 8 * class_3532.method_15375((float)((float)bindingIndex / 8.0f))] = new ButtonBindingRingAction(buttonBinding);
                ++bindingIndex;
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add(RingPage.DEFAULT);
        }
    }

    public void loadFromUnbound() {
        List<ButtonBinding> unboundBindings = InputManager.getUnboundBindings();
        if (unboundBindings != null) {
            this.pages.clear();
            int bindingIndex = 0;
            for (int i = 0; i < class_3532.method_15386((float)((float)unboundBindings.size() / 8.0f)); ++i) {
                this.pages.add(new RingPage(i + 1 + " / " + class_3532.method_15386((float)((float)unboundBindings.size() / 8.0f))));
            }
            for (ButtonBinding buttonBinding : unboundBindings) {
                if (buttonBinding == null) continue;
                RingPage page = this.pages.get(class_3532.method_15375((float)((float)bindingIndex / 8.0f)));
                page.actions[bindingIndex - 8 * class_3532.method_15375((float)((float)bindingIndex / 8.0f))] = new ButtonBindingRingAction(buttonBinding);
                ++bindingIndex;
            }
        }
        if (this.pages.isEmpty()) {
            this.pages.add(RingPage.DEFAULT);
        }
    }

    public int getMaxPages() {
        return this.pages.size();
    }

    @NotNull
    public RingPage getCurrentPage() {
        if (this.currentPage >= this.pages.size()) {
            this.currentPage = this.pages.size() - 1;
        } else if (this.currentPage < 0) {
            this.currentPage = 0;
        }
        return this.pages.get(this.currentPage);
    }

    public void cyclePage(boolean forwards) {
        this.currentPage = forwards ? (this.currentPage < this.pages.size() - 1 ? ++this.currentPage : 0) : (this.currentPage > 0 ? --this.currentPage : this.pages.size());
    }
}

