/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.virtualkeyboard;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.KeyboardLayout;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;

public class KeyboardLayoutManager {
    private static final Map<String, KeyboardLayout> KEYBOARD_LAYOUTS = new HashMap<String, KeyboardLayout>();

    public static void loadLayout(class_2960 id, class_3298 resource) {
        try {
            JsonObject json = JsonParser.parseReader((Reader)resource.method_43039()).getAsJsonObject();
            KeyboardLayout layout = KeyboardLayout.fromJson(json);
            KEYBOARD_LAYOUTS.put(layout.getId(), layout);
            if (MidnightControlsConfig.debug) {
                System.out.printf("Loaded keyboard layout: %s\n", layout.getId());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static KeyboardLayout getById(String id) {
        return KEYBOARD_LAYOUTS.get(id) == null ? KeyboardLayout.QWERTY : KEYBOARD_LAYOUTS.get(id);
    }

    public static KeyboardLayout getNext(KeyboardLayout current) {
        KeyboardLayout[] layouts = (KeyboardLayout[])KEYBOARD_LAYOUTS.values().toArray(KeyboardLayout[]::new);
        int currentIndex = -1;
        for (int i = 0; i < layouts.length; ++i) {
            if (layouts[i] != current) continue;
            currentIndex = i;
        }
        currentIndex = currentIndex + 1 >= layouts.length ? 0 : currentIndex + 1;
        return layouts[currentIndex];
    }
}

