/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.virtualkeyboard.gui;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.SpruceTexts;
import dev.lambdaurora.spruceui.screen.SpruceScreen;
import dev.lambdaurora.spruceui.widget.SpruceButtonWidget;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextAreaWidget;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.KeyboardLayout;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.KeyboardLayoutManager;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_364;

public class VirtualKeyboardScreen
extends SpruceScreen {
    private static final int STANDARD_KEY_WIDTH = 20;
    private static final int SPECIAL_KEY_WIDTH = 30;
    private static final int KEY_HEIGHT = 20;
    private static final int HORIZONTAL_SPACING = 2;
    private static final int VERTICAL_SPACING = 4;
    private static final int CONTAINER_PADDING = 10;
    private static final String BACKSPACE_SYMBOL = "\b";
    private static final String NEWLINE_SYMBOL = "\n";
    private static final String SPACE_SYMBOL = " ";
    private final StringBuilder buffer;
    private final CloseCallback closeCallback;
    private final KeyboardLayout layout;
    private final boolean newLineSupport;
    private boolean capsMode;
    private boolean symbolMode;
    private SpruceTextAreaWidget bufferDisplayArea;
    private SpruceContainerWidget keyboardContainer;

    public VirtualKeyboardScreen(String initialText, CloseCallback closeCallback, boolean newLineSupport) {
        super((class_2561)class_2561.method_43471((String)"midnightcontrols.virtual_keyboard.screen"));
        this.buffer = new StringBuilder(initialText);
        this.closeCallback = closeCallback;
        this.layout = KeyboardLayoutManager.getById(MidnightControlsConfig.keyboardLayout);
        this.capsMode = false;
        this.symbolMode = false;
        this.newLineSupport = newLineSupport;
    }

    protected void method_25426() {
        super.method_25426();
        this.bufferDisplayArea = this.createBufferDisplayArea();
        this.method_37063((class_364)this.bufferDisplayArea);
        this.rebuildKeyboard();
        int doneButtonY = this.keyboardContainer.getY() + this.keyboardContainer.getHeight() + 8;
        this.method_37063((class_364)new SpruceButtonWidget(Position.of((SprucePositioned)this, (int)(this.field_22789 / 2 - 50), (int)doneButtonY), 100, 20, SpruceTexts.GUI_DONE, btn -> this.method_25419()));
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25419() {
        super.method_25419();
        if (this.closeCallback != null) {
            this.closeCallback.onClose(this.buffer.toString());
        }
    }

    private void rebuildKeyboard() {
        if (this.keyboardContainer != null) {
            this.method_37066((class_364)this.keyboardContainer);
        }
        List<List<String>> layoutKeys = this.getActiveKeyLayout();
        SpruceContainerWidget keyboardContainer = this.createKeyboardContainer(layoutKeys);
        this.addLayoutRows(keyboardContainer, layoutKeys);
        this.addFunctionKeys(keyboardContainer);
        this.addBottomRow(keyboardContainer);
        this.keyboardContainer = keyboardContainer;
        this.method_37063((class_364)this.keyboardContainer);
    }

    private SpruceContainerWidget createKeyboardContainer(List<List<String>> layoutKeys) {
        int containerWidth = this.field_22789;
        int totalKeyboardHeight = this.calculateKeyboardHeight(layoutKeys);
        int keyboardY = this.bufferDisplayArea.getY() + this.bufferDisplayArea.getHeight() + 8;
        return new SpruceContainerWidget(Position.of((int)0, (int)keyboardY), containerWidth, totalKeyboardHeight);
    }

    private SpruceTextAreaWidget createBufferDisplayArea() {
        int lineCount = this.newLineSupport ? 4 : 1;
        int bufferX = this.field_22789 / 2 - 100;
        int bufferY = this.field_22790 / 4 - 20 - 5;
        int bufferWidth = 200;
        Objects.requireNonNull(this.field_22793);
        int desiredHeight = (9 + 2) * lineCount + 6;
        SpruceTextAreaWidget bufferDisplay = new SpruceTextAreaWidget(Position.of((int)bufferX, (int)bufferY), bufferWidth, desiredHeight, (class_2561)class_2561.method_43470((String)"Buffer Display"));
        bufferDisplay.setText(this.buffer.toString());
        bufferDisplay.setEditable(false);
        bufferDisplay.setUneditableColor(-1);
        bufferDisplay.setDisplayedLines(lineCount);
        bufferDisplay.setCursorToEnd();
        return bufferDisplay;
    }

    private int calculateKeyboardHeight(List<List<String>> keyRows) {
        return keyRows.size() * 24 + 24 + 20;
    }

    private void addLayoutRows(SpruceContainerWidget container, List<List<String>> keyLayoutRows) {
        int currentY = 10;
        for (List<String> row : keyLayoutRows) {
            int rowWidth = this.calculateRowWidth(row);
            int currentX = (container.getWidth() - rowWidth) / 2;
            for (String key : row) {
                String displayText = this.capsMode && !this.symbolMode ? key.toUpperCase() : key;
                container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((int)currentX, (int)currentY), 20, 20, (class_2561)class_2561.method_43470((String)displayText), btn -> this.handleKeyPress(displayText)));
                currentX += 22;
            }
            currentY += 24;
        }
    }

    private int calculateRowWidth(List<String> row) {
        int rowWidth = 0;
        for (int i = 0; i < row.size(); ++i) {
            rowWidth += 20;
            if (i >= row.size() - 1) continue;
            rowWidth += 2;
        }
        return rowWidth;
    }

    private void addFunctionKeys(SpruceContainerWidget container) {
        List<String> firstRow = this.getActiveKeyLayout().getFirst();
        int firstRowWidth = this.calculateRowWidth(firstRow);
        int backspaceWidth = 30;
        int backspaceX = (container.getWidth() + firstRowWidth) / 2 + 2;
        container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((int)backspaceX, (int)10), backspaceWidth, 20, (class_2561)class_2561.method_43470((String)"\u2190"), btn -> this.handleKeyPress(BACKSPACE_SYMBOL)));
        if (this.newLineSupport) {
            List<String> secondRow = this.getActiveKeyLayout().get(1);
            int newlineWidth = 30;
            int secondRowWidth = this.calculateRowWidth(secondRow);
            int newlineX = (container.getWidth() + secondRowWidth) / 2 + 2;
            int newlineY = 34;
            container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((int)newlineX, (int)newlineY), newlineWidth, 20, (class_2561)class_2561.method_43470((String)"\u23ce"), btn -> this.handleKeyPress(NEWLINE_SYMBOL)));
        }
    }

    private void addBottomRow(SpruceContainerWidget container) {
        int rowY = 10 + this.getActiveKeyLayout().size() * 24;
        double spaceWidthFactor = 5.0;
        int spaceKeyWidth = (int)(20.0 * spaceWidthFactor);
        int spaceX = (container.getWidth() - spaceKeyWidth) / 2;
        container.addChild((SpruceWidget)new SpruceButtonWidget(Position.of((int)spaceX, (int)rowY), spaceKeyWidth, 20, (class_2561)class_2561.method_43471((String)"midnightcontrols.virtual_keyboard.keyboard.space"), btn -> this.handleKeyPress(SPACE_SYMBOL)));
        if (!this.symbolMode) {
            int capsX = spaceX - 30 - 4;
            SpruceButtonWidget capsModeButton = new SpruceButtonWidget(Position.of((int)capsX, (int)rowY), 30, 20, (class_2561)class_2561.method_43470((String)(this.capsMode ? "caps" : "CAPS")), btn -> this.toggleCapsMode());
            container.addChild((SpruceWidget)capsModeButton);
        }
        int symbolsX = spaceX + spaceKeyWidth + 4;
        SpruceButtonWidget symbolModeButton = new SpruceButtonWidget(Position.of((int)symbolsX, (int)rowY), 30, 20, (class_2561)class_2561.method_43470((String)(this.symbolMode ? "ABC" : "123?!")), btn -> this.toggleSymbolMode());
        container.addChild((SpruceWidget)symbolModeButton);
    }

    private void handleKeyPress(String key) {
        if (key.equals(BACKSPACE_SYMBOL)) {
            if (!this.buffer.isEmpty()) {
                this.buffer.deleteCharAt(this.buffer.length() - 1);
            }
        } else {
            this.buffer.append(key);
        }
        if (this.bufferDisplayArea != null) {
            this.bufferDisplayArea.setText(this.buffer.toString());
            this.bufferDisplayArea.setCursorToEnd();
        }
    }

    private List<List<String>> getActiveKeyLayout() {
        return this.symbolMode ? this.layout.getSymbols() : this.layout.getLetters();
    }

    private void toggleCapsMode() {
        this.capsMode = !this.capsMode;
        this.rebuildKeyboard();
    }

    private void toggleSymbolMode() {
        this.symbolMode = !this.symbolMode;
        this.rebuildKeyboard();
    }

    @FunctionalInterface
    public static interface CloseCallback {
        public void onClose(String var1);
    }
}

