/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GLX;
import eu.midnightdust.lib.config.EntryInfo;
import eu.midnightdust.lib.config.MidnightConfig;
import eu.midnightdust.lib.config.MidnightConfigListWidget;
import eu.midnightdust.lib.config.MidnightConfigScreen;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.enums.CameraMode;
import eu.midnightdust.midnightcontrols.client.enums.ControllerType;
import eu.midnightdust.midnightcontrols.client.enums.HudSide;
import eu.midnightdust.midnightcontrols.client.enums.TouchMode;
import eu.midnightdust.midnightcontrols.client.enums.VirtualMouseSkin;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsSettingsScreen;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.config.ControllerBindingButton;
import eu.midnightdust.midnightcontrols.client.gui.config.ControllerSelectionButton;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.KeyboardLayoutManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_8662;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MidnightControlsConfig
extends MidnightConfig {
    public static final String CONTROLLER = "controller";
    public static final String TOUCH = "touch";
    public static final String GAMEPLAY = "gameplay";
    public static final String SCREENS = "screens";
    public static final String VISUAL = "visual";
    public static final String MISC = "misc";
    public static final String BUTTONS = "buttons";
    public static boolean isEditing = false;
    @MidnightConfig.Hidden
    @MidnightConfig.Entry
    public static int configVersion = 2;
    @MidnightConfig.Entry(category="controller", name="Controller ID")
    @MidnightConfig.Hidden
    public static Object controllerID = 0;
    @MidnightConfig.Entry(category="controller", name="2nd Controller ID")
    @MidnightConfig.Hidden
    public static Object secondControllerID = -1;
    @MidnightConfig.Comment(category="controller", centered=true, name="\ud83d\udd90 Input Mode")
    public static MidnightConfig.Comment _input_mode;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.controls_mode")
    public static ControlsMode controlsMode;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.auto_switch_mode")
    public static boolean autoSwitchMode;
    @MidnightConfig.Comment(category="controller", centered=true, name="\ud83d\udcf7 Camera Settings")
    public static MidnightConfig.Comment _cameraSettings;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.invert_right_y_axis")
    public static boolean invertRightYAxis;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.invert_right_x_axis")
    public static boolean invertRightXAxis;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.rotation_speed", isSlider=true, min=0.0, max=100.0, precision=10)
    public static double rotationSpeed;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.y_axis_rotation_speed", isSlider=true, min=0.0, max=100.0, precision=10)
    public static double yAxisRotationSpeed;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.camera_mode")
    public static CameraMode cameraMode;
    @MidnightConfig.Comment(category="controller", centered=true, name="\ud83d\udc40 Eye Tracking")
    public static MidnightConfig.Comment _eyeTracker;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.eye_tracker_as_mouse")
    public static boolean eyeTrackerAsMouse;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.eye_tracker_deadzone", isSlider=true, min=0.0, max=0.4)
    public static double eyeTrackerDeadzone;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.unfocused_input")
    public static boolean unfocusedInput;
    @MidnightConfig.Comment(category="controller", centered=true, name="\ud83d\udd79 Max Analog Stick Values")
    public static MidnightConfig.Comment _maxAnalogValues;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Left X", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueLeftX;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Left Y", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueLeftY;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Right X", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueRightX;
    @MidnightConfig.Entry(category="controller", name="Max analog value: Right Y", isSlider=true, min=0.25, max=1.0)
    public static double maxAnalogValueRightY;
    @MidnightConfig.Comment(category="controller", centered=true, name="\u2620 Dead Zones")
    public static MidnightConfig.Comment _deadZones;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.right_dead_zone", isSlider=true, min=0.05, max=1.0)
    public static double rightDeadZone;
    @MidnightConfig.Entry(category="controller", name="midnightcontrols.menu.left_dead_zone", isSlider=true, min=0.05, max=1.0)
    public static double leftDeadZone;
    @MidnightConfig.Entry(category="controller", name="Trigger Dead-Zone", isSlider=true, min=0.05, max=1.0)
    public static double triggerDeadZone;
    @MidnightConfig.Comment(category="buttons")
    @MidnightConfig.Condition(requiredModId="thisModDoesNotExist")
    public static MidnightConfig.Comment this_spacer_will_never_be_visible;
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static Map<String, String> BINDING;
    private static final Pattern BUTTON_BINDING_PATTERN;
    @MidnightConfig.Comment(category="visual", centered=true, name="\ud83d\uddb9 Hud")
    public static MidnightConfig.Comment _hud;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.hud_enable")
    public static boolean hudEnable;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.hud_side")
    public static HudSide hudSide;
    @MidnightConfig.Entry(category="visual", name="midnightcontrols.menu.controller_type")
    public static ControllerType controllerType;
    @MidnightConfig.Comment(category="visual", centered=true, name="\u22bd Reacharound")
    public static MidnightConfig.Comment _reacharoundOutline;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline")
    public static boolean shouldRenderReacharoundOutline;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra", requiredOption="shouldRenderReacharoundOutline")
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline Color", isColor=true)
    public static String reacharoundOutlineColorHex;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra", requiredOption="shouldRenderReacharoundOutline")
    @MidnightConfig.Entry(category="visual", name="Reacharound Outline Alpha", isSlider=true, min=0.0, max=255.0)
    public static int reacharoundOutlineColorAlpha;
    @MidnightConfig.Comment(category="gameplay", centered=true, name="\ud83d\udecb Comfort")
    public static MidnightConfig.Comment _comfort;
    @MidnightConfig.Entry(category="gameplay", name="Enable Hints")
    public static boolean enableHints;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.analog_movement")
    public static boolean analogMovement;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.controller_toggle_sneak")
    public static boolean controllerToggleSneak;
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.controller_toggle_sprint")
    public static boolean controllerToggleSprint;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Comment(category="gameplay", centered=true, name="\u2728 Extras")
    public static MidnightConfig.Comment _extras;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fast_block_placing")
    public static boolean fastBlockPlacing;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fly_drifting")
    public static boolean flyDrifting;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.fly_drifting_vertical")
    public static boolean verticalFlyDrifting;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.reacharound.horizontal")
    public static boolean horizontalReacharound;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Entry(category="gameplay", name="midnightcontrols.menu.reacharound.vertical")
    public static boolean verticalReacharound;
    @MidnightConfig.Condition(requiredModId="midnightcontrols-extra")
    @MidnightConfig.Comment(category="screens", centered=true, name="\ud83d\uddb1 Mouse Behaviour")
    public static MidnightConfig.Comment _mouseBehaviour;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.mouse_speed", isSlider=true, min=0.0, max=150.0, precision=10)
    public static double mouseSpeed;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.joystick_as_mouse")
    public static boolean joystickAsMouse;
    @MidnightConfig.Entry(category="screens", name="Mouse screens")
    public static List<String> mouseScreens;
    @MidnightConfig.Entry(category="screens", name="Arrow screens")
    public static List<String> arrowScreens;
    @MidnightConfig.Entry(category="screens", name="WASD screens")
    public static List<String> wasdScreens;
    @MidnightConfig.Comment(category="screens", centered=true, name="\ud83d\udc46 Virtual Mouse")
    public static MidnightConfig.Comment _virtualMouse;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.virtual_mouse")
    public static boolean virtualMouse;
    @MidnightConfig.Condition(requiredOption="virtualMouse", visibleButLocked=true)
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.virtual_mouse.skin")
    public static VirtualMouseSkin virtualMouseSkin;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.hide_cursor")
    public static boolean hideNormalMouse;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.virtual_keyboard")
    public static boolean virtualKeyboard;
    @MidnightConfig.Comment(category="screens", centered=true, name="\ud83d\udd27 UI Modifications")
    public static MidnightConfig.Comment _uiMods;
    @MidnightConfig.Entry(category="screens", name="midnightcontrols.menu.move_chat")
    public static boolean moveChat;
    @MidnightConfig.Entry(category="screens", name="Enable Shortcut in Controls Options")
    public static boolean shortcutInControls;
    @MidnightConfig.Comment(category="touch", centered=true, name="\ud83e\ude84 Behaviour")
    public static MidnightConfig.Comment _touchBehaviour;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.touch_with_controller")
    public static boolean touchInControllerMode;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.touch_speed", isSlider=true, min=0.0, max=150.0, precision=10)
    public static double touchSpeed;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.invert_touch")
    public static boolean invertTouch;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.touch_mode")
    public static TouchMode touchMode;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.touch_break_delay", isSlider=true, min=50.0, max=500.0)
    public static int touchBreakDelay;
    @MidnightConfig.Comment(category="touch", centered=true, name="\ud83d\udca1 Visuals")
    public static MidnightConfig.Comment _visuals;
    @MidnightConfig.Entry(category="touch", name="midnightcontrols.menu.touch_transparency", isSlider=true, min=0.0, max=100.0)
    public static int touchTransparency;
    @MidnightConfig.Entry(category="touch", name="Touch Outline Color", isColor=true)
    public static String touchOutlineColorHex;
    @MidnightConfig.Entry(category="touch", name="Touch Outline Alpha", isSlider=true, min=0.0, max=255.0)
    public static int touchOutlineColorAlpha;
    @MidnightConfig.Comment(category="touch", centered=true, name="\ud83e\uddea Advanced")
    public static MidnightConfig.Comment _advanced;
    @MidnightConfig.Entry(category="touch", name="Screens with close button")
    public static List<String> closeButtonScreens;
    @MidnightConfig.Entry(category="touch", name="Left Touch button bindings")
    public static List<String> leftTouchBinds;
    @MidnightConfig.Entry(category="touch", name="Right Touch button bindings")
    public static List<String> rightTouchBinds;
    @MidnightConfig.Entry(category="misc")
    @MidnightConfig.Hidden
    public static String keyboardLayout;
    @MidnightConfig.Entry(category="misc", name="Debug")
    public static boolean debug;
    @MidnightConfig.Entry(category="misc", name="Excluded Keybindings")
    public static List<String> excludedKeybindings;
    @MidnightConfig.Entry(category="misc", name="Ring Bindings (WIP)")
    @MidnightConfig.Hidden
    public static List<String> ringBindings;
    @MidnightConfig.Entry(category="misc", name="Ignored Unbound Keys")
    public static List<String> ignoredUnboundKeys;
    @MidnightConfig.Comment(category="misc", centered=true, name="\u2606 Other Options")
    public static MidnightConfig.Comment _otherOptions;
    @MidnightConfig.Entry(category="misc", name="Trigger button fix")
    public static boolean triggerFix;
    @MidnightConfig.Entry(category="misc", name="Excluded Controllers (Name Regex)")
    public static List<String> excludedControllers;
    @MidnightConfig.Entry
    @MidnightConfig.Hidden
    public static Map<String, Map<String, String>> controllerBindingProfiles;
    private static Map<String, String> currentBindingProfile;
    private static Controller prevController;

    public void onTabInit(String tabName, MidnightConfigListWidget list, MidnightConfigScreen screen) {
        EntryInfo centeredComment = new EntryInfo(null, "midnightcontrols");
        centeredComment.comment = new MidnightConfig.Comment(this){

            public Class<? extends Annotation> annotationType() {
                return null;
            }

            public String category() {
                return "";
            }

            public String name() {
                return "";
            }

            public String url() {
                return "";
            }

            public String requiredMod() {
                return "";
            }

            public boolean centered() {
                return true;
            }
        };
        if (BUTTONS.equals(tabName)) {
            InputManager.streamCategories().sorted(Comparator.comparingInt(ButtonCategory::getPriority)).forEach(category -> {
                list.addButton((List)Lists.newArrayList(), (class_2561)class_2561.method_43470((String)category.getTranslatedName()), centeredComment);
                category.getBindings().forEach(binding -> ControllerBindingButton.add(binding, list, screen));
            });
        }
        if (MISC.equals(tabName)) {
            class_8662 resetButton = class_8662.method_52723((class_2561)class_2561.method_43471((String)"controls.reset"), button -> {
                keyboardLayout = "en_US:qwerty";
                screen.updateList();
            }, (boolean)true).method_52727(class_2960.method_60655((String)"midnightlib", (String)"icon/reset"), 12, 12).method_52726(20, 20).method_52724();
            resetButton.method_48229(screen.field_22789 - 205 + 150 + 25, 0);
            class_4185 editButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)KeyboardLayoutManager.getById(keyboardLayout).getTranslationKey()), button -> {
                resetButton.field_22763 = !(keyboardLayout = KeyboardLayoutManager.getNext(KeyboardLayoutManager.getById(keyboardLayout)).getId()).equals("en_US:qwerty");
                button.method_25355((class_2561)class_2561.method_43471((String)KeyboardLayoutManager.getById(keyboardLayout).getTranslationKey()));
            }).method_46434(screen.field_22789 - 185, 0, 150, 20).method_46431();
            resetButton.field_22763 = !keyboardLayout.equals("en_US:qwerty");
            list.addButton(List.of(editButton, resetButton), (class_2561)class_2561.method_43471((String)"midnightcontrols.menu.virtual_keyboard_layout"), new EntryInfo(null, screen.modid));
        }
        if (CONTROLLER.equals(tabName)) {
            list.addButton(List.of(), class_2561.method_30163((String)"\ud83c\udfae General"), centeredComment);
            ControllerSelectionButton.add(list, screen, false);
            ControllerSelectionButton.add(list, screen, true);
            class_4185 editButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)"OPEN"), button -> MidnightControlsClient.client.method_1507((class_437)new MidnightControlsSettingsScreen(MidnightControlsClient.client.field_1755, false))).method_46434(screen.field_22789 - 185, 0, 175, 20).method_46431();
            list.addButton(List.of(editButton), class_2561.method_30163((String)"Legacy Config UI"), new EntryInfo(null, screen.modid));
        }
    }

    public static void load() {
        MidnightControlsConfig.init((String)"midnightcontrols", MidnightControlsConfig.class);
        MidnightControls.log("Configuration loaded.");
        InputManager.loadButtonBindings();
    }

    public static void save() {
        MidnightControlsConfig.write((String)"midnightcontrols");
        MidnightControls.log("Configuration saved.");
        MidnightControlsFeature.refreshEnabled();
    }

    public static void updateBindingsForController(Controller controller) {
        currentBindingProfile = controller.isConnected() && controller.isGamepad() && controllerBindingProfiles.containsKey(controller.getGuid()) ? controllerBindingProfiles.get(controller.getGuid()) : Maps.newHashMap(BINDING);
        InputManager.loadButtonBindings();
    }

    public static Map<String, String> getBindingsForController() {
        return currentBindingProfile;
    }

    public static Controller getController() {
        Object raw = controllerID;
        Controller controller = Controller.byId(0);
        if (raw instanceof Number) {
            controller = Controller.byId(((Number)raw).intValue());
        } else if (raw instanceof String) {
            controller = Controller.byGuid((String)raw).orElse(Controller.byId(0));
        }
        if (!(controller.isConnected() && controller.isGamepad() || !autoSwitchMode || isEditing)) {
            for (int i = 0; i < 15; ++i) {
                Controller gamepad = Controller.byId(i);
                if (!gamepad.isConnected() || !gamepad.isGamepad()) continue;
                controller = gamepad;
                i = 15;
            }
        }
        if (controller.isConnected() && controller.isGamepad() && autoSwitchMode && !isEditing) {
            controlsMode = ControlsMode.CONTROLLER;
        }
        if (prevController != controller) {
            MidnightControlsConfig.updateBindingsForController(controller);
        }
        prevController = controller;
        return controller;
    }

    public static void setController(Controller controller) {
        controllerID = controller.id();
        MidnightControlsConfig.write((String)"midnightcontrols");
    }

    public static Optional<Controller> getSecondController() {
        Object raw = secondControllerID;
        if (raw instanceof Number) {
            if (((Number)raw).intValue() == -1) {
                return Optional.empty();
            }
            return Optional.of(Controller.byId(((Number)raw).intValue()));
        }
        if (raw instanceof String) {
            return Optional.of(Controller.byGuid((String)raw).orElse(Controller.byId(0)));
        }
        return Optional.empty();
    }

    public static void setSecondController(@Nullable Controller controller) {
        secondControllerID = controller == null ? -1 : controller.id();
    }

    public static double getRightXAxisSign() {
        return invertRightXAxis ? -1.0 : 1.0;
    }

    public static double getRightYAxisSign() {
        return invertRightYAxis ? -1.0 : 1.0;
    }

    public static double getAxisMaxValue(int axis) {
        return switch (axis) {
            case 0 -> maxAnalogValueLeftX;
            case 1 -> maxAnalogValueLeftY;
            case 2 -> maxAnalogValueRightX;
            default -> maxAnalogValueRightY;
        };
    }

    public static void setAxisMaxValue(int axis, double value) {
        switch (axis) {
            case 0: {
                maxAnalogValueLeftX = value;
                break;
            }
            case 1: {
                maxAnalogValueLeftY = value;
                break;
            }
            case 2: {
                maxAnalogValueRightX = value;
                break;
            }
            default: {
                maxAnalogValueRightY = value;
            }
        }
    }

    public static void loadButtonBinding(@NotNull ButtonBinding button) {
        button.setButton(button.getDefaultButton());
        String code = MidnightControlsConfig.getBindingsForController().getOrDefault("controller.controls." + button.getName(), button.getButtonCode());
        Matcher matcher = BUTTON_BINDING_PATTERN.matcher(code);
        try {
            int[] buttons = new int[1];
            int count = 0;
            while (matcher.find()) {
                String current;
                if (++count > buttons.length) {
                    buttons = Arrays.copyOf(buttons, count);
                }
                if (!MidnightControlsConfig.checkValidity(button, code, current = matcher.group(1))) {
                    return;
                }
                buttons[count - 1] = Integer.parseInt(current);
            }
            if (count == 0) {
                MidnightControls.warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
                MidnightControlsConfig.setButtonBinding(button, new int[]{-1});
            }
            button.setButton(buttons);
        }
        catch (Exception e) {
            MidnightControls.warn("Malformed config value \"" + code + "\" for binding \"" + button.getName() + "\".");
            MidnightControlsConfig.setButtonBinding(button, button.getButton());
        }
    }

    private static boolean checkValidity(@NotNull ButtonBinding binding, @NotNull String input, String group) {
        if (group == null) {
            MidnightControls.warn("Malformed config value \"" + input + "\" for binding \"" + binding.getName() + "\".");
            MidnightControlsConfig.setButtonBinding(binding, binding.getButton());
            return false;
        }
        return true;
    }

    public static void setButtonBinding(@NotNull ButtonBinding binding, int[] button) {
        binding.setButton(button);
        MidnightControlsConfig.getBindingsForController().put("controller.controls." + binding.getName(), binding.getButtonCode());
        if (controllerBindingProfiles.containsKey(MidnightControlsConfig.getController().getGuid())) {
            controllerBindingProfiles.get(MidnightControlsConfig.getController().getGuid()).put("controller.controls." + binding.getName(), binding.getButtonCode());
        } else {
            BINDING.put("controller.controls." + binding.getName(), binding.getButtonCode());
        }
    }

    public static boolean isBackButton(int btn, boolean isBtn, ButtonState state) {
        if (!isBtn && state == ButtonState.NONE) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, false) == ButtonBinding.axisAsButton(btn, state == ButtonState.PRESS);
    }

    public static boolean isForwardButton(int btn, boolean isBtn, ButtonState state) {
        if (!isBtn && state == ButtonState.NONE) {
            return false;
        }
        return ButtonBinding.axisAsButton(1, true) == ButtonBinding.axisAsButton(btn, state == ButtonState.PRESS);
    }

    public static boolean isLeftButton(int btn, boolean isBtn, ButtonState state) {
        if (!isBtn && state == ButtonState.NONE) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, false) == ButtonBinding.axisAsButton(btn, state == ButtonState.PRESS);
    }

    public static boolean isRightButton(int btn, boolean isBtn, ButtonState state) {
        if (!isBtn && state == ButtonState.NONE) {
            return false;
        }
        return ButtonBinding.axisAsButton(0, true) == ButtonBinding.axisAsButton(btn, state == ButtonState.PRESS);
    }

    public static boolean isMovementAxis(int axis) {
        return axis == 1 || axis == 0;
    }

    public static void reset() {
        controlsMode = ControlsMode.DEFAULT;
        autoSwitchMode = true;
        debug = false;
        hudEnable = true;
        hudSide = HudSide.LEFT;
        analogMovement = true;
        controllerToggleSneak = (Boolean)class_310.method_1551().field_1690.method_42449().method_41753();
        controllerToggleSprint = (Boolean)class_310.method_1551().field_1690.method_42450().method_41753();
        fastBlockPlacing = false;
        flyDrifting = true;
        verticalFlyDrifting = true;
        horizontalReacharound = false;
        verticalReacharound = false;
        shouldRenderReacharoundOutline = true;
        reacharoundOutlineColorHex = "#ffffff";
        reacharoundOutlineColorAlpha = 102;
        rightDeadZone = 0.25;
        leftDeadZone = 0.25;
        invertRightYAxis = false;
        invertRightXAxis = false;
        yAxisRotationSpeed = rotationSpeed = 35.0;
        mouseSpeed = 25.0;
        unfocusedInput = false;
        virtualMouse = false;
        virtualMouseSkin = VirtualMouseSkin.DEFAULT_LIGHT;
        virtualKeyboard = false;
        controllerID = 0;
        secondControllerID = -1;
        controllerType = ControllerType.DEFAULT;
        mouseScreens = Lists.newArrayList((Object[])new String[]{"net.minecraft.client.gui.screen.advancement", "net.minecraft.class_457", "net.minecraft.class_408", "net.minecraft.class_3872", "me.flashyreese.mods.reeses_sodium_options.client.gui", "dev.emi.emi.screen", "me.shedaniel.clothconfig2.gui.ClothConfigScreen", "com.mamiyaotaru.voxelmap.gui.GuiWaypoints", "com.mamiyaotaru.voxelmap.gui.GuiPersistentMap"});
        BINDING = new HashMap<String, String>();
        maxAnalogValueLeftX = 1.0;
        maxAnalogValueLeftY = 1.0;
        maxAnalogValueRightX = 1.0;
        maxAnalogValueRightY = 1.0;
        triggerFix = true;
        enableHints = true;
        shortcutInControls = true;
        ringBindings = new ArrayList<String>();
        ignoredUnboundKeys = Lists.newArrayList((Object[])new String[]{"inventorytabs.key.next_tab"});
        controllerBindingProfiles = new HashMap<String, Map<String, String>>();
    }

    @NotNull
    public static ControllerType matchControllerToType() {
        String name = MidnightControlsConfig.getController().getName().toLowerCase();
        if (MidnightControlsConfig.containsAny(name, "xbox 360")) {
            return ControllerType.XBOX_360;
        }
        if (MidnightControlsConfig.containsAny(name, "xbox") || name.contains("afterglow")) {
            return ControllerType.XBOX;
        }
        if (MidnightControlsConfig.containsAny(name, "steam") && GLX._getCpuInfo().contains("AMD Custom APU")) {
            return ControllerType.STEAM_DECK;
        }
        if (MidnightControlsConfig.containsAny(name, "steam")) {
            return ControllerType.STEAM_CONTROLLER;
        }
        if (MidnightControlsConfig.containsAny(name, "dualsense", "ps5")) {
            return ControllerType.DUALSENSE;
        }
        if (MidnightControlsConfig.containsAny(name, "dualshock", "ps4", "sony")) {
            return ControllerType.DUALSHOCK;
        }
        if (MidnightControlsConfig.containsAny(name, "switch", "joy-con", "wii", "nintendo")) {
            return ControllerType.SWITCH;
        }
        if (MidnightControlsConfig.containsAny(name, "ouya")) {
            return ControllerType.OUYA;
        }
        return ControllerType.DEFAULT;
    }

    private static boolean containsAny(String controller, String ... substring) {
        for (String s : substring) {
            if (!controller.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean doMixedInput() {
        return touchInControllerMode && controlsMode == ControlsMode.CONTROLLER;
    }

    static {
        controlsMode = ControlsMode.DEFAULT;
        autoSwitchMode = true;
        invertRightYAxis = false;
        invertRightXAxis = false;
        yAxisRotationSpeed = rotationSpeed = 35.0;
        cameraMode = CameraMode.FLAT;
        eyeTrackerAsMouse = false;
        eyeTrackerDeadzone = 0.05;
        unfocusedInput = false;
        maxAnalogValueLeftX = 1.0;
        maxAnalogValueLeftY = 1.0;
        maxAnalogValueRightX = 1.0;
        maxAnalogValueRightY = 1.0;
        rightDeadZone = 0.15;
        leftDeadZone = 0.15;
        triggerDeadZone = 0.1;
        BINDING = new HashMap<String, String>();
        BUTTON_BINDING_PATTERN = Pattern.compile("(-?\\d+)\\+?");
        hudEnable = true;
        hudSide = HudSide.LEFT;
        controllerType = ControllerType.DEFAULT;
        shouldRenderReacharoundOutline = true;
        reacharoundOutlineColorHex = "#ffffff";
        reacharoundOutlineColorAlpha = 102;
        enableHints = true;
        analogMovement = true;
        controllerToggleSneak = (Boolean)class_310.method_1551().field_1690.method_42449().method_41753();
        controllerToggleSprint = (Boolean)class_310.method_1551().field_1690.method_42450().method_41753();
        fastBlockPlacing = false;
        flyDrifting = true;
        verticalFlyDrifting = true;
        horizontalReacharound = false;
        verticalReacharound = false;
        mouseSpeed = 25.0;
        joystickAsMouse = false;
        mouseScreens = Lists.newArrayList((Object[])new String[]{"net.minecraft.client.gui.screen.advancement", "net.minecraft.class_457", "net.minecraft.class_408", "net.minecraft.class_3872", "me.flashyreese.mods.reeses_sodium_options.client.gui", "dev.emi.emi.screen", "hardcorequesting.client.interfaces.GuiQuestBook", "hardcorequesting.client.interfaces.GuiReward", "hardcorequesting.client.interfaces.EditTrackerScreen", "me.shedaniel.clothconfig2.gui.ClothConfigScreen", "com.mamiyaotaru.voxelmap.gui.GuiWaypoints", "com.mamiyaotaru.voxelmap.gui.GuiPersistentMap"});
        arrowScreens = Lists.newArrayList((Object[])new String[]{class_408.class.getCanonicalName()});
        wasdScreens = Lists.newArrayList((Object[])new String[]{"com.ultreon.devices.core.Laptop"});
        virtualMouse = false;
        virtualMouseSkin = VirtualMouseSkin.DEFAULT_LIGHT;
        hideNormalMouse = false;
        virtualKeyboard = false;
        moveChat = false;
        shortcutInControls = true;
        touchInControllerMode = false;
        touchSpeed = 50.0;
        invertTouch = false;
        touchMode = TouchMode.CROSSHAIR;
        touchBreakDelay = 120;
        touchTransparency = 75;
        touchOutlineColorHex = "#ffffff";
        touchOutlineColorAlpha = 150;
        closeButtonScreens = Lists.newArrayList((Object[])new String[]{class_408.class.getCanonicalName(), class_457.class.getCanonicalName(), RingScreen.class.getCanonicalName()});
        leftTouchBinds = Lists.newArrayList((Object[])new String[]{"debug_screen", "screenshot", "toggle_perspective"});
        rightTouchBinds = Lists.newArrayList((Object[])new String[]{"screenshot", "toggle_perspective", "use"});
        keyboardLayout = "en_US:qwerty";
        debug = false;
        excludedKeybindings = Lists.newArrayList((Object[])new String[]{"key.forward", "key.left", "key.back", "key.right", "key.jump", "key.sneak", "key.sprint", "key.inventory", "key.swapOffhand", "key.drop", "key.use", "key.attack", "key.chat", "key.playerlist", "key.screenshot", "key.togglePerspective", "key.smoothCamera", "key.fullscreen", "key.saveToolbarActivator", "key.loadToolbarActivator", "key.pickItem", "key.hotbar.1", "key.hotbar.2", "key.hotbar.3", "key.hotbar.4", "key.hotbar.5", "key.hotbar.6", "key.hotbar.7", "key.hotbar.8", "key.hotbar.9"});
        ringBindings = new ArrayList<String>();
        ignoredUnboundKeys = Lists.newArrayList((Object[])new String[]{"inventorytabs.key.next_tab"});
        triggerFix = true;
        excludedControllers = Lists.newArrayList((Object[])new String[]{".*(Keyboard)$", ".*(Touchpad)$", ".*(Pen)$", ".*(Finger)$"});
        controllerBindingProfiles = new HashMap<String, Map<String, String>>();
        currentBindingProfile = new HashMap<String, String>();
    }
}

