/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.gui;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.SprucePositioned;
import dev.lambdaurora.spruceui.option.SpruceOption;
import dev.lambdaurora.spruceui.option.SpruceSimpleActionOption;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import dev.lambdaurora.spruceui.widget.container.SpruceContainerWidget;
import dev.lambdaurora.spruceui.widget.text.SpruceTextAreaWidget;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.gui.ReloadControllerMappingsOption;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;

public class MappingsStringInputWidget
extends SpruceContainerWidget {
    private final SpruceOption copyGuidOption;
    private final SpruceOption reloadMappingsOption = ReloadControllerMappingsOption.newOption(btn -> this.writeMappings());
    private String mappings;
    private SpruceTextAreaWidget textArea;

    protected MappingsStringInputWidget(Position position, int width, int height) {
        super(position, width, height);
        this.copyGuidOption = SpruceSimpleActionOption.of((String)"midnightcontrols.menu.copy_controller_guid", button -> this.client.field_1774.method_1455(MidnightControlsConfig.getController().getGuid()));
        this.init();
    }

    public void removed() {
        this.writeMappings();
        Controller.updateMappings();
    }

    public void onClose() {
        this.removed();
    }

    public void writeMappings() {
        if (this.textArea != null) {
            this.mappings = this.textArea.getText();
            try {
                FileWriter fw = new FileWriter(MidnightControlsClient.MAPPINGS_FILE, false);
                fw.write(this.mappings);
                fw.close();
            }
            catch (IOException e) {
                if (this.client != null) {
                    this.client.method_1566().method_1999((class_368)class_370.method_29047((class_310)this.client, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"midnightcontrols.controller.mappings.error.write"), (class_2561)class_2561.method_43473()));
                }
                e.fillInStackTrace();
            }
        }
    }

    protected void init() {
        if (this.textArea != null) {
            this.mappings = this.textArea.getText();
        }
        String mappings = "";
        if (this.mappings != null) {
            mappings = this.mappings;
        } else if (MidnightControlsClient.MAPPINGS_FILE.exists()) {
            try {
                this.mappings = mappings = String.join((CharSequence)"\n", Files.readAllLines(MidnightControlsClient.MAPPINGS_FILE.toPath()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        int textFieldWidth = (int)((double)this.width * 0.8333333333333334);
        this.textArea = new SpruceTextAreaWidget(Position.of((SprucePositioned)this, (int)(this.width / 2 - textFieldWidth / 2), (int)0), textFieldWidth, this.height - 50, (class_2561)class_2561.method_43470((String)mappings));
        this.textArea.setText(mappings);
        int n = this.textArea.getInnerHeight();
        Objects.requireNonNull(this.client.field_1772);
        this.textArea.setDisplayedLines(n / 9);
        this.addChild((SpruceWidget)this.textArea);
        this.addChild(this.reloadMappingsOption.createWidget(Position.of((int)(this.width / 2 - 155), (int)(this.height - 29)), 257));
        this.addChild(this.copyGuidOption.createWidget(Position.of((int)(this.width / 2 + 105), (int)(this.height - 29)), 65));
    }

    public void renderWidget(SpruceGuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderWidget(context, mouseX, mouseY, delta);
        context.vanilla().method_27534(this.client.field_1772, (class_2561)class_2561.method_43471((String)"midnightcontrols.menu.multiple_mapping_tip"), this.textArea.getX() + this.textArea.getWidth() / 2, this.textArea.getY() + this.textArea.getHeight() - 12, -7829368);
        context.vanilla().method_27534(this.client.field_1772, (class_2561)class_2561.method_43469((String)"midnightcontrols.menu.current_controller_guid", (Object[])new Object[]{MidnightControlsConfig.getController().getGuid()}), this.textArea.getX() + this.textArea.getWidth() / 2, this.height - 21, -1);
    }
}

