/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.virtualkeyboard;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class KeyboardLayout {
    public static KeyboardLayout QWERTY = new KeyboardLayout("en_US:qwerty", KeyboardLayout.createQwertyLetterLayout(), KeyboardLayout.createSymbolLayout());
    private final String id;
    private final List<List<String>> letters;
    private final List<List<String>> symbols;

    private KeyboardLayout(String id, List<List<String>> letters, List<List<String>> symbols) {
        this.id = id;
        this.letters = letters;
        this.symbols = symbols;
    }

    public static KeyboardLayout fromJson(JsonObject json) {
        try {
            return new KeyboardLayout(json.get("id").getAsString(), KeyboardLayout.getFromJson(json, true), KeyboardLayout.getFromJson(json, false));
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading keyboard definition: %s".formatted(e));
        }
    }

    private static List<List<String>> getFromJson(JsonObject json, boolean letters) {
        String type = letters ? "letters" : "symbols";
        ArrayList<List<String>> arr = new ArrayList<List<String>>();
        if (json.has(type)) {
            JsonObject lettersJson = json.get(type).getAsJsonObject();
            int i = 0;
            while (lettersJson.has("row" + i)) {
                JsonArray rowJson = lettersJson.get("row%s".formatted(i)).getAsJsonArray();
                ArrayList<String> row = new ArrayList<String>();
                for (int j = 0; j < rowJson.size(); ++j) {
                    row.add(rowJson.get(j).getAsString());
                }
                arr.add(row);
                ++i;
            }
            return arr;
        }
        return letters ? KeyboardLayout.createQwertyLetterLayout() : KeyboardLayout.createSymbolLayout();
    }

    public String getId() {
        return this.id;
    }

    public String getTranslationKey() {
        String[] identifier = this.id.split(":");
        if (identifier.length != 2) {
            return "Invalid Keyboard ID: %s".formatted(this.id);
        }
        return "midnightcontrols.virtual_keyboard.layout.%s.%s".formatted(identifier[0], identifier[1]);
    }

    public List<List<String>> getLetters() {
        return this.letters;
    }

    public List<List<String>> getSymbols() {
        return this.symbols;
    }

    private static List<List<String>> createQwertyLetterLayout() {
        ArrayList<List<String>> letters = new ArrayList<List<String>>();
        letters.add(Arrays.asList("q", "w", "e", "r", "t", "y", "u", "i", "o", "p"));
        letters.add(Arrays.asList("a", "s", "d", "f", "g", "h", "j", "k", "l"));
        letters.add(Arrays.asList("z", "x", "c", "v", "b", "n", "m"));
        return letters;
    }

    private static List<List<String>> createSymbolLayout() {
        ArrayList<List<String>> symbols = new ArrayList<List<String>>();
        symbols.add(Arrays.asList("1", "2", "3", "4", "5", "6", "7", "8", "9", "0"));
        symbols.add(Arrays.asList("@", "#", "$", "%", "&", "*", "-", "+", "(", ")"));
        symbols.add(Arrays.asList("!", "\"", "'", ":", ";", ",", ".", "?", "/"));
        return symbols;
    }
}

