/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.virtualkeyboard.clickhandler;

import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.clickhandler.AbstractScreenClickHandler;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.clickhandler.TextFieldWrapper;
import eu.midnightdust.midnightcontrols.client.virtualkeyboard.gui.VirtualKeyboardScreen;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_481;

public class DefaultScreenClickHandler
extends AbstractScreenClickHandler<class_437> {
    private class_437 parentScreen;
    private List<Integer> textFieldElementPath;

    @Override
    public void handle(class_437 screen, double mouseX, double mouseY) {
        TextFieldWrapper textField = this.findClickedTextField(screen.method_25396(), mouseX, mouseY);
        if (textField == null) {
            return;
        }
        this.parentScreen = screen;
        this.textFieldElementPath = this.calculatePathToElement((class_364)screen, textField.asElement());
        VirtualKeyboardScreen virtualKeyboardScreen = new VirtualKeyboardScreen(textField.getText(), this::handleKeyboardClose, false);
        MidnightControlsClient.client.method_1507((class_437)virtualKeyboardScreen);
    }

    private void handleKeyboardClose(String newText) {
        if (this.parentScreen == null || this.textFieldElementPath == null) {
            return;
        }
        MidnightControlsClient.client.method_1507(this.parentScreen);
        TextFieldWrapper textField = this.findTextFieldByPath((class_364)this.parentScreen, this.textFieldElementPath);
        if (textField == null) {
            return;
        }
        textField.setText(newText);
        class_437 class_4372 = this.parentScreen;
        Objects.requireNonNull(class_4372);
        class_437 class_4373 = class_4372;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_481.class, class_408.class}, (Object)class_4373, n)) {
            case 0: {
                class_481 creativeInventoryScreen = (class_481)class_4373;
                CreativeInventoryScreenAccessor accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
                accessor.midnightcontrols$search();
                break;
            }
            case 1: {
                class_408 chatScreen = (class_408)class_4373;
                chatScreen.method_25404(MidnightInput.ENTER_KEY_INPUT);
                break;
            }
        }
    }

    private TextFieldWrapper findClickedTextField(List<? extends class_364> elements, double mouseX, double mouseY) {
        for (class_364 class_3642 : elements) {
            class_4069 parentElement;
            TextFieldWrapper found;
            TextFieldWrapper textField;
            if (TextFieldWrapper.isValidTextField(class_3642) && (textField = new TextFieldWrapper(class_3642)).isMouseOver(mouseX, mouseY) && textField.isFocused()) {
                return textField;
            }
            if (!(class_3642 instanceof class_4069) || (found = this.findClickedTextField((parentElement = (class_4069)class_3642).method_25396(), mouseX, mouseY)) == null) continue;
            return found;
        }
        return null;
    }

    protected List<Integer> calculatePathToElement(class_364 parent, class_364 target) {
        if (!(parent instanceof class_4069)) {
            return null;
        }
        class_4069 parentElement = (class_4069)parent;
        List children = parentElement.method_25396();
        for (int i = 0; i < children.size(); ++i) {
            List<Integer> subPath;
            class_364 child = (class_364)children.get(i);
            if (child == target) {
                return Collections.singletonList(i);
            }
            if (!(child instanceof class_4069) || (subPath = this.calculatePathToElement(child, target)) == null) continue;
            ArrayList<Integer> fullPath = new ArrayList<Integer>(subPath.size() + 1);
            fullPath.add(i);
            fullPath.addAll(subPath);
            return fullPath;
        }
        return null;
    }

    protected TextFieldWrapper findTextFieldByPath(class_364 parent, List<Integer> path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (!(parent instanceof class_4069)) {
            return null;
        }
        class_4069 parentElement = (class_4069)parent;
        List children = parentElement.method_25396();
        int index = path.get(0);
        if (index < 0 || index >= children.size()) {
            return null;
        }
        class_364 child = (class_364)children.get(index);
        if (path.size() == 1) {
            return TextFieldWrapper.isValidTextField(child) ? new TextFieldWrapper(child) : null;
        }
        if (child instanceof class_4069) {
            return this.findTextFieldByPath(child, path.subList(1, path.size()));
        }
        return null;
    }
}

