/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.packet;

import eu.midnightdust.midnightcontrols.MidnightControlsConstants;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import java.util.Optional;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public record FeaturePayload(MidnightControlsFeature[] features) implements class_8710
{
    public static final class_8710.class_9154<FeaturePayload> PACKET_ID = new class_8710.class_9154(MidnightControlsConstants.FEATURE_CHANNEL);
    public static final class_9139<class_9129, FeaturePayload> codec = class_9139.method_56438(FeaturePayload::write, FeaturePayload::read);

    public static FeaturePayload read(class_9129 buf) {
        int featureLength = buf.method_10816();
        MidnightControlsFeature[] receivedFeatures = new MidnightControlsFeature[featureLength];
        for (int i = 0; i < featureLength; ++i) {
            String name = buf.method_10800(64);
            boolean allowed = buf.readBoolean();
            Optional<MidnightControlsFeature> feature = MidnightControlsFeature.fromName(name);
            if (!feature.isPresent()) continue;
            feature.get().setAllowed(allowed);
            receivedFeatures[i] = feature.get();
        }
        return new FeaturePayload(receivedFeatures);
    }

    public void write(class_9129 buf) {
        if (this.features.length == 0) {
            throw new IllegalArgumentException("At least one feature must be provided.");
        }
        buf.method_10804(this.features.length);
        for (MidnightControlsFeature feature : this.features) {
            buf.method_10788(feature.getName(), 64);
            buf.method_52964(feature.isAllowed());
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }
}

