/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.bundleup.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.notcharrow.bundleup.config.BundleUpConfig;
import com.notcharrow.bundleup.config.ConfigManager;
import com.notcharrow.bundleup.helper.TextFormat;
import java.util.Collections;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_7923;

@Environment(value=EnvType.CLIENT)
public class ModifyList {
    private static final class_310 client = class_310.method_1551();

    public static LiteralArgumentBuilder<FabricClientCommandSource> registerCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"modifylist").then(ClientCommandManager.literal((String)"add").executes(ModifyList::executeAdd))).then(ClientCommandManager.literal((String)"list").executes(ModifyList::executeList))).then(ClientCommandManager.literal((String)"remove").executes(ModifyList::executeRemove));
    }

    private static int executeList(CommandContext<FabricClientCommandSource> context) {
        if (ModifyList.client.field_1724 != null) {
            List<String> configList = ConfigManager.config.items;
            Collections.sort(configList);
            if (ConfigManager.config.itemListMode.equals((Object)BundleUpConfig.ItemListMode.WHITELIST)) {
                ModifyList.client.field_1724.method_7353(TextFormat.styledText("Current items in your whitelist:"), false);
            } else {
                ModifyList.client.field_1724.method_7353(TextFormat.styledText("Current items in your blacklist:"), false);
            }
            StringBuilder displayText = new StringBuilder();
            for (String itemID : configList) {
                String itemName = ((class_1792)class_7923.field_41178.method_63535(class_2960.method_60654((String)itemID))).method_63680().getString();
                displayText.append(itemName);
                if (!configList.getLast().equals(itemID)) {
                    displayText.append(", ");
                    continue;
                }
                displayText.append(".");
            }
            ModifyList.client.field_1724.method_7353(TextFormat.styledText(displayText.toString()), false);
        }
        return 1;
    }

    private static int executeAdd(CommandContext<FabricClientCommandSource> context) {
        if (ModifyList.client.field_1724 != null) {
            class_1799 stack = ModifyList.client.field_1724.method_6047();
            if (stack.method_7909() == class_1802.field_8162) {
                ModifyList.client.field_1724.method_7353(TextFormat.styledText("You aren't holding anything!"), false);
            } else {
                String itemID = String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909()));
                String itemName = stack.method_7909().method_63680().getString();
                List<String> configList = ConfigManager.config.items;
                if (configList.contains(itemID)) {
                    if (ConfigManager.config.itemListMode.equals((Object)BundleUpConfig.ItemListMode.WHITELIST)) {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText(itemName + " is already in your whitelist!"), false);
                    } else {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText(itemName + " is already in your blacklist!"), false);
                    }
                } else {
                    ConfigManager.config.items.add(itemID);
                    ConfigManager.saveConfig();
                    if (ConfigManager.config.itemListMode.equals((Object)BundleUpConfig.ItemListMode.WHITELIST)) {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText("Added " + itemName + " to your whitelist!"), false);
                    } else {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText("Added " + itemName + " to your blacklist!"), false);
                    }
                }
            }
        }
        return 1;
    }

    private static int executeRemove(CommandContext<FabricClientCommandSource> context) {
        if (ModifyList.client.field_1724 != null) {
            class_1799 stack = ModifyList.client.field_1724.method_6047();
            if (stack.method_7909() == class_1802.field_8162) {
                ModifyList.client.field_1724.method_7353(TextFormat.styledText("You aren't holding anything!"), false);
            } else {
                String itemID = String.valueOf(class_7923.field_41178.method_10221((Object)stack.method_7909()));
                String itemName = stack.method_7909().method_63680().getString();
                List<String> configList = ConfigManager.config.items;
                if (!configList.contains(itemID)) {
                    if (ConfigManager.config.itemListMode.equals((Object)BundleUpConfig.ItemListMode.WHITELIST)) {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText(itemName + " is not in your whitelist!"), false);
                    } else {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText(itemName + " is not in your blacklist!"), false);
                    }
                } else {
                    ConfigManager.config.items.remove(itemID);
                    ConfigManager.saveConfig();
                    if (ConfigManager.config.itemListMode.equals((Object)BundleUpConfig.ItemListMode.WHITELIST)) {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText("Removed " + itemName + " from your whitelist!"), false);
                    } else {
                        ModifyList.client.field_1724.method_7353(TextFormat.styledText("Removed " + itemName + " from your blacklist!"), false);
                    }
                }
            }
        }
        return 1;
    }
}

