/*
 * Decompiled with CFR 0.152.
 */
package com.notcharrow.bundleup.helper;

import com.notcharrow.bundleup.config.BundleUpConfig;
import com.notcharrow.bundleup.config.ConfigManager;
import com.notcharrow.bundleup.mixin.ShulkerBoxScreenHandlerAccessor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1733;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_5537;
import net.minecraft.class_7923;
import net.minecraft.class_9276;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public class BundleUpHelper {
    public static Map<class_1792, Integer> getBundleContents(class_1799 bundleStack) {
        class_9276 bundleContentsComponent;
        HashMap<class_1792, Integer> bundleContents = new HashMap<class_1792, Integer>();
        try {
            bundleContentsComponent = (class_9276)bundleStack.method_58694(class_9334.field_49650);
        }
        catch (NoSuchMethodError ignored) {
            Method get;
            try {
                get = class_9322.class.getMethod("method_57824", class_9331.class);
            }
            catch (NoSuchMethodException e) {
                try {
                    get = class_9322.class.getMethod("get", class_9331.class);
                }
                catch (NoSuchMethodException ex) {
                    throw new RuntimeException(ex);
                }
            }
            get.setAccessible(true);
            try {
                bundleContentsComponent = (class_9276)get.invoke((Object)bundleStack, class_9334.field_49650);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        if (bundleStack.method_31573(class_3489.field_54294) && bundleContentsComponent != null) {
            for (class_1799 stack : bundleContentsComponent.method_57421()) {
                bundleContents.put(stack.method_7909(), stack.method_7947());
            }
        }
        return bundleContents;
    }

    public static int getRemainingSpace(class_1799 bundleStack) {
        if (bundleStack.method_31573(class_3489.field_54294)) {
            int amountFilled = (int)(class_5537.method_31561((class_1799)bundleStack) * 64.0f);
            return 64 - amountFilled;
        }
        return 0;
    }

    public static int getTotalSpace(Map<Integer, Integer> spaces) {
        return spaces.values().stream().mapToInt(Integer::intValue).sum();
    }

    public static int getSpacePerItem(class_1799 stack) {
        int maxStackSize = stack.method_7914();
        return 64 / maxStackSize;
    }

    public static List<Map<Integer, class_1799>> updateMaps(class_1661 inventory) {
        HashMap<Integer, class_1799> bundles = new HashMap<Integer, class_1799>();
        Map<Integer, class_1799> items = new HashMap<Integer, class_1799>();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null) {
            class_1799 stack;
            class_437 screen = client.field_1755;
            class_1703 screenHandler = client.field_1724.field_7512;
            int containerSize = 0;
            class_1263 containerInventory = null;
            if (screenHandler instanceof class_1707) {
                class_1707 containerScreenHandler = (class_1707)screenHandler;
                containerInventory = containerScreenHandler.method_7629();
            } else if (screenHandler instanceof class_1733) {
                class_1733 containerScreenHandler = (class_1733)screenHandler;
                containerInventory = ((ShulkerBoxScreenHandlerAccessor)containerScreenHandler).getInventory();
            }
            if (containerInventory != null) {
                containerSize = containerInventory.method_5439();
                for (int slot = 0; slot < containerSize; ++slot) {
                    stack = containerInventory.method_5438(slot);
                    if (stack.method_31573(class_3489.field_54294)) {
                        bundles.put(slot, stack);
                        continue;
                    }
                    if (stack.method_7960() || BundleUpHelper.getSpacePerItem(stack) >= 64) continue;
                    items.put(slot, stack);
                }
            }
            for (int slot = 0; slot < inventory.method_5439(); ++slot) {
                stack = inventory.method_5438(slot);
                int realSlot = BundleUpHelper.convertSlotID(slot, screen, containerSize);
                if (stack.method_31573(class_3489.field_54294)) {
                    bundles.put(realSlot, stack);
                    continue;
                }
                if (stack.method_7960() || BundleUpHelper.getSpacePerItem(stack) >= 64) continue;
                items.put(realSlot, stack);
            }
            items = BundleUpHelper.purgeItemsMap(items, containerSize);
        }
        return new ArrayList<Map<Integer, class_1799>>(Arrays.asList(bundles, items));
    }

    private static Map<Integer, class_1799> purgeItemsMap(Map<Integer, class_1799> items, int containerSize) {
        HashMap<Integer, class_1799> newItemsList = new HashMap<Integer, class_1799>();
        int indexShift = 9;
        if (containerSize > 0) {
            indexShift = containerSize;
        }
        for (Map.Entry<Integer, class_1799> entry : items.entrySet()) {
            class_1799 stack = entry.getValue();
            String itemID = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            if (entry.getKey() >= containerSize && ConfigManager.config.slotBlacklist[entry.getKey() - indexShift]) continue;
            if (ConfigManager.config.itemListMode == BundleUpConfig.ItemListMode.WHITELIST) {
                if (!ConfigManager.config.items.contains(itemID)) continue;
                newItemsList.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (ConfigManager.config.items.contains(itemID)) continue;
            newItemsList.put(entry.getKey(), entry.getValue());
        }
        return newItemsList;
    }

    public static Map<Integer, Integer> getSpaces(Map<Integer, class_1799> items) {
        HashMap<Integer, Integer> spaces = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, class_1799> entry : items.entrySet()) {
            class_1799 stack = entry.getValue();
            int remainingSpace = BundleUpHelper.getRemainingSpace(stack);
            spaces.put(entry.getKey(), remainingSpace);
        }
        return spaces;
    }

    public static Map<Integer, Integer> getSpaceRequirements(Map<Integer, class_1799> items) {
        HashMap<Integer, Integer> spaceRequirements = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, class_1799> entry : items.entrySet()) {
            class_1799 stack = entry.getValue();
            int spaceRequirement = BundleUpHelper.getSpacePerItem(stack) * stack.method_7947();
            spaceRequirements.put(entry.getKey(), spaceRequirement);
        }
        return spaceRequirements;
    }

    private static int convertSlotID(int slot, class_437 screen, int containerSize) {
        if (screen instanceof class_490) {
            if (slot < 9) {
                return slot + 36;
            }
            return slot;
        }
        if (slot < 9) {
            return slot + containerSize + 27;
        }
        return slot + containerSize - 9;
    }

    public static void clickSlot(int slot) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1761 != null) {
            client.field_1761.method_2906(client.field_1724.field_7512.field_7763, slot, 0, class_1713.field_7790, (class_1657)client.field_1724);
        }
    }
}

