/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.clear;

import com.janboerman.invsee.spigot.addon.clear.ItemType;
import com.janboerman.invsee.utils.Either;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;

class Convert {
    Convert() {
    }

    static Either<UUID, String> convertPlayer(String input) {
        assert (input != null);
        try {
            UUID uuid = UUID.fromString(input);
            return Either.left((Object)uuid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Either.right((Object)input);
        }
    }

    static Either<String, ItemType> convertItemType(String input) {
        Material material;
        Byte dataValue;
        String materialName;
        assert (input != null);
        int colonIndex = input.indexOf(58);
        if (colonIndex != -1) {
            materialName = input.substring(0, colonIndex);
            try {
                dataValue = Byte.parseByte(input.substring(colonIndex + 1));
            }
            catch (NumberFormatException ignored) {
                dataValue = null;
            }
        } else {
            materialName = input;
            dataValue = null;
        }
        if ((material = Material.matchMaterial((String)materialName)) != null) {
            if (dataValue != null) {
                return Either.right((Object)ItemType.withData(material, dataValue));
            }
            return Either.right((Object)ItemType.plain(material));
        }
        try {
            NamespacedKey tagKey = NamespacedKey.fromString((String)materialName, null);
            Tag tag = Bukkit.getTag((String)"items", (NamespacedKey)tagKey, Material.class);
            if (tag != null) {
                return Either.right((Object)ItemType.fromTag((Tag<Material>)tag));
            }
            tag = Bukkit.getTag((String)"blocks", (NamespacedKey)tagKey, Material.class);
            if (tag != null) {
                return Either.right((Object)ItemType.fromTag((Tag<Material>)tag));
            }
        }
        catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
            // empty catch block
        }
        return Either.left((Object)("Material " + input + " does not exist."));
    }

    static Either<String, Integer> convertAmount(String input) {
        assert (input != null);
        try {
            int value = Integer.parseInt(input);
            if (value > 0) {
                return Either.right((Object)value);
            }
            return Either.left((Object)(input + " is not a positive integer."));
        }
        catch (IllegalArgumentException e) {
            return Either.left((Object)(input + " is not a positive integer."));
        }
    }
}

