/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.clear;

import com.janboerman.invsee.spigot.addon.clear.ClearPlugin;
import com.janboerman.invsee.spigot.addon.clear.Convert;
import com.janboerman.invsee.spigot.addon.clear.ItemType;
import com.janboerman.invsee.spigot.api.CreationOptions;
import com.janboerman.invsee.spigot.api.InvseeAPI;
import com.janboerman.invsee.spigot.api.MainSpectatorInventory;
import com.janboerman.invsee.spigot.api.Scheduler;
import com.janboerman.invsee.spigot.api.response.ImplementationFault;
import com.janboerman.invsee.spigot.api.response.NotCreatedReason;
import com.janboerman.invsee.spigot.api.response.OfflineSupportDisabled;
import com.janboerman.invsee.spigot.api.response.TargetDoesNotExist;
import com.janboerman.invsee.spigot.api.response.TargetHasExemptPermission;
import com.janboerman.invsee.spigot.api.response.UnknownTarget;
import com.janboerman.invsee.utils.Either;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.Inventory;

class InvClearExecutor
implements CommandExecutor {
    private final ClearPlugin plugin;
    private final InvseeAPI api;

    InvClearExecutor(ClearPlugin plugin, InvseeAPI api) {
        this.plugin = plugin;
        this.api = api;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        CompletableFuture userNameFuture;
        CompletableFuture uuidFuture;
        if (args.length == 0) {
            return false;
        }
        String inputPlayer = args[0];
        Either<UUID, String> eitherPlayer = Convert.convertPlayer(inputPlayer);
        if (eitherPlayer.isLeft()) {
            UUID uuid = (UUID)eitherPlayer.getLeft();
            uuidFuture = CompletableFuture.completedFuture(Optional.of(uuid));
            userNameFuture = this.api.fetchUserName(uuid);
        } else {
            assert (eitherPlayer.isRight());
            String userName = (String)eitherPlayer.getRight();
            userNameFuture = CompletableFuture.completedFuture(Optional.of(userName));
            uuidFuture = this.api.fetchUniqueId(userName);
        }
        ItemType itemType = null;
        int maxCount = -1;
        if (args.length >= 2) {
            String inputItemType = args[1];
            Either<String, ItemType> eitherMaterial = Convert.convertItemType(inputItemType);
            if (eitherMaterial.isRight()) {
                itemType = (ItemType)eitherMaterial.getRight();
            } else {
                assert (eitherMaterial.isLeft());
                sender.sendMessage(ChatColor.RED + (String)eitherMaterial.getLeft());
                return true;
            }
        }
        if (args.length >= 3) {
            String inputMaxCount = args[2];
            Either<String, Integer> eitherMaxCount = Convert.convertAmount(inputMaxCount);
            if (eitherMaxCount.isRight()) {
                maxCount = (Integer)eitherMaxCount.getRight();
            } else {
                assert (eitherMaxCount.isLeft());
                sender.sendMessage(ChatColor.RED + (String)eitherMaxCount.getLeft());
                return true;
            }
        }
        ItemType finalItemType = itemType;
        int finalMaxCount = maxCount;
        CreationOptions creationOptions = this.api.mainInventoryCreationOptions().withOfflinePlayerSupport(this.plugin.offlinePlayerSupport()).withBypassExemptedPlayers(this.plugin.bypassExemptInvsee(sender));
        uuidFuture.thenCombineAsync((CompletionStage)userNameFuture, (optUuid, optName) -> {
            if (!optName.isPresent() || !optUuid.isPresent()) {
                sender.sendMessage(ChatColor.RED + "Unknown player: " + inputPlayer);
            } else {
                String userName = (String)optName.get();
                UUID uuid = (UUID)optUuid.get();
                CompletableFuture responseFuture = this.api.mainSpectatorInventory(uuid, userName, creationOptions);
                responseFuture.thenAcceptAsync(response -> {
                    if (response.isSuccess()) {
                        MainSpectatorInventory inventory = (MainSpectatorInventory)response.getInventory();
                        if (finalItemType == null) {
                            inventory.clear();
                            sender.sendMessage(ChatColor.GREEN + "Cleared " + userName + "'s inventory.");
                        } else if (finalMaxCount == -1) {
                            finalItemType.removeAllFrom((Inventory)inventory);
                            sender.sendMessage(ChatColor.GREEN + "Removed all " + finalItemType + " from " + userName + "'s inventory.");
                        } else {
                            int removed = finalItemType.removeAtMostFrom((Inventory)inventory, finalMaxCount);
                            sender.sendMessage(ChatColor.GREEN + "Removed " + removed + " " + finalItemType + " from " + userName + "'s inventory.");
                        }
                        this.api.saveInventory(inventory).whenComplete((v, e) -> {
                            if (e != null) {
                                this.plugin.getLogger().log(Level.SEVERE, "Could not save inventory", (Throwable)e);
                            }
                        });
                    } else {
                        NotCreatedReason reason = response.getReason();
                        if (reason instanceof TargetDoesNotExist) {
                            TargetDoesNotExist targetDoesNotExist = (TargetDoesNotExist)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + targetDoesNotExist.getTarget() + " does not exist.");
                        } else if (reason instanceof UnknownTarget) {
                            UnknownTarget unknownTarget = (UnknownTarget)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + unknownTarget.getTarget() + " has not logged onto the server yet.");
                        } else if (reason instanceof TargetHasExemptPermission) {
                            TargetHasExemptPermission targetHasExemptPermission = (TargetHasExemptPermission)reason;
                            sender.sendMessage(ChatColor.RED + "Player " + targetHasExemptPermission.getTarget() + " is exempted from being spectated.");
                        } else if (reason instanceof ImplementationFault) {
                            ImplementationFault implementationFault = (ImplementationFault)reason;
                            sender.sendMessage(ChatColor.RED + "An internal fault occurred when trying to load " + implementationFault.getTarget() + "'s inventory.");
                        } else if (reason instanceof OfflineSupportDisabled) {
                            sender.sendMessage(ChatColor.RED + "Spectating offline players' inventories is disabled.");
                        } else {
                            sender.sendMessage(ChatColor.RED + "Cannot clear from " + inputPlayer + "'s inventory for an unknown reason.");
                        }
                    }
                }, runnable -> this.api.getScheduler().executeSyncPlayer(uuid, runnable, null));
            }
            return null;
        }, arg_0 -> ((Scheduler)this.api.getScheduler()).executeSyncGlobal(arg_0));
        return true;
    }
}

