/*
 * Decompiled with CFR 0.152.
 */
package com.janboerman.invsee.spigot.addon.clear;

import com.janboerman.invsee.spigot.addon.clear.RemoveUtil;
import java.util.Objects;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.Inventory;

interface ItemType {
    public static ItemType plain(Material material) {
        return new Plain(material);
    }

    public static ItemType withData(Material material, byte data) {
        return new WithData(material, data);
    }

    public static ItemType fromTag(Tag<Material> tag) {
        return new FromTag(tag);
    }

    public void removeAllFrom(Inventory var1);

    public int removeAtMostFrom(Inventory var1, int var2);

    public static class Plain
    implements ItemType {
        private final Material material;

        Plain(Material material) {
            this.material = Objects.requireNonNull(material);
        }

        @Override
        public void removeAllFrom(Inventory inventory) {
            inventory.remove(this.material);
        }

        @Override
        public int removeAtMostFrom(Inventory inventory, int atMost) {
            return RemoveUtil.removeAtMost(inventory, this.material, atMost);
        }

        public String toString() {
            return this.material.toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Plain)) {
                return false;
            }
            Plain that = (Plain)o;
            return this.material == that.material;
        }

        public int hashCode() {
            return Objects.hashCode(this.material);
        }
    }

    public static class WithData
    implements ItemType {
        private final Material material;
        private final byte data;

        WithData(Material material, byte data) {
            this.material = Objects.requireNonNull(material);
            this.data = data;
        }

        @Override
        public void removeAllFrom(Inventory inventory) {
            RemoveUtil.removeIf(inventory, stack -> stack.getType() == this.material && stack.getDurability() == (short)this.data);
        }

        @Override
        public int removeAtMostFrom(Inventory inventory, int atMost) {
            return RemoveUtil.removeIfAtMost(inventory, stack -> stack.getType() == this.material && stack.getDurability() == (short)this.data, atMost);
        }

        public String toString() {
            return this.material.toString() + ":" + this.data;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithData)) {
                return false;
            }
            WithData that = (WithData)o;
            return this.material == that.material && this.data == that.data;
        }

        public int hashCode() {
            return Objects.hash(this.material, this.data);
        }
    }

    public static class FromTag
    implements ItemType {
        private final Tag<Material> tag;

        FromTag(Tag<Material> tag) {
            this.tag = tag;
        }

        @Override
        public void removeAllFrom(Inventory inventory) {
            RemoveUtil.removeIf(inventory, stack -> this.tag.isTagged((Keyed)stack.getType()));
        }

        @Override
        public int removeAtMostFrom(Inventory inventory, int atMost) {
            return RemoveUtil.removeIfAtMost(inventory, stack -> this.tag.isTagged((Keyed)stack.getType()), atMost);
        }

        public String toString() {
            return this.tag.getKey().toString();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FromTag)) {
                return false;
            }
            FromTag that = (FromTag)o;
            return Objects.equals(this.tag, that.tag);
        }

        public int hashCode() {
            return Objects.hashCode(this.tag);
        }
    }
}

